/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public abstract class AbstractJcrSessionFactory
implements DisposableBean,
InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Repository repository;
    protected String workspaceName;
    protected Credentials credentials;
    protected Set<Resource> nodeTypeDefinitions;
    private Set<Session> sessionsCache = new HashSet<Session>();

    public AbstractJcrSessionFactory() {
    }

    public AbstractJcrSessionFactory(Repository repository, String workspaceName, Credentials credentials) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.credentials = credentials;
    }

    public AbstractJcrSessionFactory(Repository repository, String workspaceName, Credentials credentials, Set<Resource> nodeTypeDefinitions) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.credentials = credentials;
        this.nodeTypeDefinitions = nodeTypeDefinitions;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Set<Resource> getNodeTypeDefinitions() {
        return this.nodeTypeDefinitions;
    }

    public void setNodeTypeDefinitions(Set<Resource> nodeTypeDefinitions) {
        this.nodeTypeDefinitions = nodeTypeDefinitions;
    }

    private Session addListeners(Session session) {
        return session;
    }

    private Session addNodeTypes(Session session) throws RepositoryException {
        if (this.nodeTypeDefinitions == null || this.nodeTypeDefinitions.isEmpty()) {
            return session;
        }
        Workspace workspace = session.getWorkspace();
        NodeTypeManager nodeTypeManager = workspace.getNodeTypeManager();
        NodeTypeRegistry nodeTypeRegistry = ((NodeTypeManagerImpl)nodeTypeManager).getNodeTypeRegistry();
        for (Resource resource : this.nodeTypeDefinitions) {
            try {
                QNodeTypeDefinition[] nodeTypeDefinitions;
                for (QNodeTypeDefinition nodeTypeDefinition : nodeTypeDefinitions = NodeTypeReader.read((InputStream)resource.getInputStream())) {
                    try {
                        nodeTypeRegistry.getNodeTypeDef(nodeTypeDefinition.getName());
                    }
                    catch (NoSuchNodeTypeException e) {
                        nodeTypeRegistry.registerNodeType(nodeTypeDefinition);
                    }
                }
            }
            catch (IOException | InvalidNodeTypeDefException e) {
                throw new RepositoryException("Erreur survenue lors de l'importation du");
            }
        }
        return session;
    }

    protected Session registerNamespace(Session session) throws RepositoryException {
        Map<String, String> namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.isEmpty()) {
            return session;
        }
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            try {
                session.getWorkspace().getNamespaceRegistry().registerNamespace(entry.getKey(), entry.getValue());
            }
            catch (NamespaceException namespaceException) {}
        }
        return session;
    }

    protected Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("spring-jcr", "http://spring.developpers.leadware.net/schema/jcr");
        namespaces.put("spring-jackrabbit", "http://spring.developpers.leadware.net/schema/jcr/jackrabbit");
        return namespaces;
    }

    public Session getSession() throws RepositoryException {
        Session session = this.addListeners(this.addNodeTypes(this.registerNamespace(this.repository.login(this.credentials, this.workspaceName))));
        this.sessionsCache.add(session);
        return session;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() throws Exception {
        if (this.sessionsCache.isEmpty()) {
            return;
        }
        for (Session session : this.sessionsCache) {
            try {
                session.logout();
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)String.format("Erreur survenue lors de la dexonnexion de la session JCR : %1$s", e.getMessage()), (Throwable)e);
            }
        }
        this.sessionsCache.clear();
    }
}

