/*
 * Decompiled with CFR 0.152.
 */
package net.lariverosc.jesquespring;

import java.util.Collection;
import java.util.concurrent.Callable;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.worker.WorkerImpl;
import net.lariverosc.jesquespring.SpringWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringWorkerFactory
implements Callable<WorkerImpl>,
ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(SpringWorkerFactory.class);
    private final Config config;
    private final Collection<String> queues;
    private ApplicationContext applicationContext;

    public SpringWorkerFactory(Config config, Collection<String> queues) {
        this.config = config;
        this.queues = queues;
    }

    @Override
    public WorkerImpl call() {
        this.logger.info("Create new Spring Worker");
        SpringWorker springWorker = new SpringWorker(this.config, this.queues);
        springWorker.setApplicationContext(this.applicationContext);
        return springWorker;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

