/*
 * Decompiled with CFR 0.152.
 */
package net.lariverosc.jesquespring;

import java.util.Collection;
import java.util.Collections;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.worker.Worker;
import net.greghaines.jesque.worker.WorkerEvent;
import net.greghaines.jesque.worker.WorkerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringWorker
extends WorkerImpl
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(SpringWorker.class);
    private ApplicationContext applicationContext;

    public SpringWorker(Config config, Collection<String> queues) {
        super(config, queues, Collections.EMPTY_MAP);
    }

    protected void process(Job job, String curQueue) {
        this.logger.info("Process new Job from queue {}", (Object)curQueue);
        try {
            Runnable runnableJob = null;
            if (this.applicationContext.containsBeanDefinition(job.getClassName())) {
                runnableJob = (Runnable)this.applicationContext.getBean(job.getClassName(), job.getArgs());
            } else {
                try {
                    Class<?> clazz = Class.forName(job.getClassName());
                    String[] beanNames = this.applicationContext.getBeanNamesForType(clazz, true, false);
                    if (this.applicationContext.containsBeanDefinition(job.getClassName())) {
                        runnableJob = (Runnable)this.applicationContext.getBean(beanNames[0], job.getArgs());
                    } else if (beanNames != null && beanNames.length == 1) {
                        runnableJob = (Runnable)this.applicationContext.getBean(beanNames[0], job.getArgs());
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.logger.error("Not bean Id or class definition found {}", (Object)job.getClassName());
                    throw new Exception("Not bean Id or class definition found " + job.getClassName());
                }
            }
            if (runnableJob != null) {
                this.listenerDelegate.fireEvent(WorkerEvent.JOB_PROCESS, (Worker)this, curQueue, job, null, null, null);
                if (SpringWorker.isThreadNameChangingEnabled()) {
                    this.renameThread("Processing " + curQueue + " since " + System.currentTimeMillis());
                }
                this.execute(job, curQueue, runnableJob);
            }
        }
        catch (Exception e) {
            this.failure(e, job, curQueue);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void init() {
        this.logger.info("Start a new thread for SpringWorker");
        new Thread((Runnable)((Object)this)).start();
    }

    public void destroy() {
        this.logger.info("End the SpringWorker thread");
        this.end(true);
    }
}

