/*
 * Decompiled with CFR 0.152.
 */
package net.lamberto.configuration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import net.lamberto.configuration.ConfigurationException;
import net.lamberto.configuration.ConfigurationOptionType;
import net.lamberto.configuration.ConfigurationOptionTypes;
import net.lamberto.configuration.ConfigurationOptions;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationOptionsModule
extends PrivateModule {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationOptionsModule.class);
    private final Configuration configuration;
    private final Map<Class<? extends ConfigurationOptionType<?>>, ConfigurationOptionType<?>> strategies;

    public ConfigurationOptionsModule(Map<String, String> configuration, Class<?> ... optionsHolderClasses) {
        log.debug("Configuration options values {}", configuration);
        this.configuration = new MapConfiguration(configuration);
        this.strategies = Maps.newHashMap();
        for (Class<?> optionsHolderClass : optionsHolderClasses) {
            this.discoverOptions(optionsHolderClass);
        }
    }

    private void discoverOptions(Class<?> optionsHolder) {
        if (this.isOption(optionsHolder)) {
            this.registerStrategy(optionsHolder);
            return;
        }
        for (Class<?> option : optionsHolder.getClasses()) {
            if (!this.isOption(option)) continue;
            this.registerStrategy(option);
        }
        for (Class<?> ifs : optionsHolder.getInterfaces()) {
            this.discoverOptions(ifs);
        }
    }

    private void registerStrategy(Class<? extends ConfigurationOptionType<?>> type) {
        log.debug("Registering configuration option '{}'", (Object)type.getSimpleName());
        try {
            this.strategies.put(type, type.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = String.format("Cannot create configuration option '%s'", type.getSimpleName());
            log.warn(message);
            throw new ConfigurationException(message);
        }
    }

    private boolean isOption(Class<?> option) {
        return option != null && (Iterables.contains(Arrays.asList(option.getInterfaces()), ConfigurationOptionType.class) || this.isOption(option.getSuperclass()));
    }

    protected void configure() {
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        for (Map.Entry<Class<ConfigurationOptionType<?>>, ConfigurationOptionType<?>> entry : this.strategies.entrySet()) {
            Class<ConfigurationOptionType<?>> configurationOption = entry.getKey();
            ConfigurationOptionType<?> strategy = entry.getValue();
            Class<?> fieldType = strategy.getConfigurationType();
            log.debug("Binding configuration named '{}' to field type '{}'", (Object)configurationOption.getSimpleName(), (Object)fieldType.getSimpleName());
            this.bind(fieldType).annotatedWith((Annotation)ConfigurationOptions.configuration(configurationOption)).toProvider(this.getProvider(strategy));
            this.expose(fieldType).annotatedWith((Annotation)ConfigurationOptions.configuration(configurationOption));
        }
    }

    public Object getValueFor(ConfigurationOptionType<?> strategy, Configuration configuration) {
        String name = strategy.getClass().getSimpleName();
        if (configuration.containsKey(name)) {
            return strategy.getValueFor(name, configuration);
        }
        String message = String.format("No configuration property found for '%s'", name);
        log.warn(message);
        throw new ConfigurationException(message);
    }

    public Provider getProvider(final ConfigurationOptionType<?> strategy) {
        return new Provider<Object>(){
            @Inject
            private Configuration configuration;

            public Object get() {
                return ConfigurationOptionsModule.this.getValueFor(strategy, this.configuration);
            }
        };
    }

    public String getString(Class<? extends ConfigurationOptionType<?>> key) {
        return new ConfigurationOptionTypes.StringOption().getValueFor(key.getSimpleName(), this.configuration);
    }

    public Boolean getBoolean(Class<? extends ConfigurationOptionType<?>> key) {
        return new ConfigurationOptionTypes.BooleanOption().getValueFor(key.getSimpleName(), this.configuration);
    }
}

