/*
 * Decompiled with CFR 0.152.
 */
package net.lamberto.configuration;

import com.google.common.base.Joiner;
import java.net.MalformedURLException;
import java.net.URL;
import net.lamberto.configuration.ConfigurationException;
import net.lamberto.configuration.ConfigurationOptionType;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConfigurationOptionTypes {

    public static class URLOption
    implements ConfigurationOptionType<URL> {
        private static final Logger log = LoggerFactory.getLogger(URLOption.class);

        @Override
        public Class<URL> getConfigurationType() {
            return URL.class;
        }

        @Override
        public URL getValueFor(String name, Configuration configuration) {
            String url = configuration.getString(name);
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                String message = String.format("Invalid URL '%s'", url);
                log.warn(message, (Throwable)e);
                throw new ConfigurationException(message);
            }
        }
    }

    public static class BooleanOption
    implements ConfigurationOptionType<Boolean> {
        @Override
        public Class<Boolean> getConfigurationType() {
            return Boolean.class;
        }

        @Override
        public Boolean getValueFor(String name, Configuration configuration) {
            return configuration.getBoolean(name);
        }
    }

    public static class LongOption
    implements ConfigurationOptionType<Long> {
        @Override
        public Class<Long> getConfigurationType() {
            return Long.class;
        }

        @Override
        public Long getValueFor(String name, Configuration configuration) {
            return configuration.getLong(name);
        }
    }

    public static class IntegerOption
    implements ConfigurationOptionType<Integer> {
        @Override
        public Class<Integer> getConfigurationType() {
            return Integer.class;
        }

        @Override
        public Integer getValueFor(String name, Configuration configuration) {
            return configuration.getInteger(name, Integer.valueOf(-1));
        }
    }

    public static class StringArrayOption
    implements ConfigurationOptionType<String[]> {
        @Override
        public Class<String[]> getConfigurationType() {
            return String[].class;
        }

        @Override
        public String[] getValueFor(String name, Configuration configuration) {
            return configuration.getStringArray(name);
        }
    }

    public static class StringOption
    implements ConfigurationOptionType<String> {
        @Override
        public Class<String> getConfigurationType() {
            return String.class;
        }

        @Override
        public String getValueFor(String name, Configuration configuration) {
            return Joiner.on((char)',').join((Object[])configuration.getStringArray(name));
        }
    }
}

