/*
 * Decompiled with CFR 0.152.
 */
package net.ladenthin.javacommons;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class StreamHelper {
    public static final int BUFFER_SIZE = 2048;
    public static final String UTF8 = StandardCharsets.UTF_8.name();

    public ByteArrayOutputStream readFully(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream(inputStream.available());
        byte[] buffer = new byte[2048];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result;
    }

    public byte[] readFullyAsBytes(InputStream inputStream) throws IOException {
        return this.readFully(inputStream).toByteArray();
    }

    public String readFullyAsString(InputStream inputStream, String encoding) throws IOException {
        return this.readFully(inputStream).toString(encoding);
    }

    public String readFullyAsUTF8String(InputStream inputStream) throws IOException {
        return this.readFullyAsString(inputStream, UTF8);
    }

    public String readFullyAsUTF8String(File file) throws IOException {
        return this.readFullyAsString(file, UTF8);
    }

    public String readFullyAsString(File file, String encoding) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String content;
            String string = content = this.readFullyAsString(fileInputStream, encoding);
            return string;
        }
    }
}

