/*
 * Decompiled with CFR 0.152.
 */
package gsonpath;

import com.google.common.collect.Sets;
import gsonpath.AutoGsonAdapterFactory;
import gsonpath.ProcessingException;
import gsonpath.adapter.AdapterGenerationResult;
import gsonpath.adapter.enums.EnumAdapterFactory;
import gsonpath.adapter.standard.StandardAdapterFactory;
import gsonpath.adapter.subType.SubTypeAdapterFactory;
import gsonpath.dependencies.Dependencies;
import gsonpath.dependencies.DependencyFactory;
import gsonpath.util.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0015\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lgsonpath/GsonProcessor;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "generateTypeAdapterFactories", "", "env", "Ljavax/annotation/processing/RoundEnvironment;", "dependencies", "Lgsonpath/dependencies/Dependencies;", "autoGsonAdapterResults", "", "Lgsonpath/adapter/AdapterGenerationResult;", "getSupportedAnnotationTypes", "", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "process", "", "annotations", "Ljavax/lang/model/element/TypeElement;", "processInternal", "logger", "Lgsonpath/util/Logger;", "standard"})
public class GsonProcessor
extends AbstractProcessor {
    @Override
    public boolean process(@Nullable Set<? extends TypeElement> annotations, @NotNull RoundEnvironment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        if (annotations == null) {
            return false;
        }
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        Logger logger = new Logger(processingEnvironment);
        try {
            this.processInternal(annotations, env, logger);
        }
        catch (ProcessingException e) {
            logger.printError(e.getMessage(), e.getElement());
        }
        return false;
    }

    private final void processInternal(Set<? extends TypeElement> annotations, RoundEnvironment env, Logger logger) {
        boolean bl = false;
        System.out.println();
        logger.printMessage("Started annotation processing");
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        Dependencies dependencies = DependencyFactory.INSTANCE.create(processingEnvironment);
        List autoGsonAdapterResults = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)StandardAdapterFactory.INSTANCE.generateGsonAdapters(env, logger, annotations, dependencies), (Iterable)SubTypeAdapterFactory.INSTANCE.generateGsonAdapters(env, logger, annotations, dependencies)), (Iterable)EnumAdapterFactory.INSTANCE.generateGsonAdapters(env, logger, annotations, dependencies));
        this.generateTypeAdapterFactories(env, dependencies, autoGsonAdapterResults);
        logger.printMessage("Finished annotation processing");
        boolean bl2 = false;
        System.out.println();
    }

    private final void generateTypeAdapterFactories(RoundEnvironment env, Dependencies dependencies, List<AdapterGenerationResult> autoGsonAdapterResults) {
        Collection collection = autoGsonAdapterResults;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Element factoryElement;
            Set<? extends Element> gsonPathFactories = env.getElementsAnnotatedWith(AutoGsonAdapterFactory.class);
            Set<? extends Element> set = gsonPathFactories;
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"gsonPathFactories");
            Collection collection2 = set;
            boolean bl2 = false;
            if (collection2.size() == 0) {
                throw (Throwable)new ProcessingException("An interface annotated with @AutoGsonAdapterFactory (that directly extends com.google.gson.TypeAdapterFactory) must exist before the annotation processor can succeed. See the AutoGsonAdapterFactory annotation for further details.", null, 2, null);
            }
            collection2 = gsonPathFactories;
            bl2 = false;
            if (collection2.size() > 1) {
                throw (Throwable)new ProcessingException("Only one interface annotated with @AutoGsonAdapterFactory can exist", null, 2, null);
            }
            Element element = factoryElement = (Element)CollectionsKt.first((Iterable)gsonPathFactories);
            if (element == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            dependencies.getTypeAdapterFactoryGenerator().generate((TypeElement)element, autoGsonAdapterResults);
        }
    }

    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"*"});
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet(\"*\")");
        return hashSet;
    }

    @Override
    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latestSupported();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceVersion), (String)"SourceVersion.latestSupported()");
        return sourceVersion;
    }
}

