/*
 * Decompiled with CFR 0.152.
 */
package gsonpath;

import gsonpath.Dependencies;
import gsonpath.ExtensionsLoader;
import gsonpath.Logger;
import gsonpath.compiler.GsonPathExtension;
import gsonpath.generator.adapter.AdapterModelMetadataFactory;
import gsonpath.generator.adapter.AutoGsonAdapterGenerator;
import gsonpath.generator.adapter.read.ReadFunctions;
import gsonpath.generator.adapter.write.WriteFunctions;
import gsonpath.generator.factory.TypeAdapterFactoryGenerator;
import gsonpath.generator.interf.InterfaceModelMetadataFactory;
import gsonpath.generator.interf.ModelInterfaceGenerator;
import gsonpath.model.FieldInfoFactory;
import gsonpath.model.FieldNamingPolicyMapper;
import gsonpath.model.FieldPathFetcher;
import gsonpath.model.FieldTypeFactory;
import gsonpath.model.GsonObjectFactory;
import gsonpath.model.GsonObjectTreeFactory;
import gsonpath.model.GsonObjectValidator;
import gsonpath.model.SerializedNameFetcher;
import gsonpath.util.AnnotationFetcher;
import gsonpath.util.DefaultValueDetector;
import gsonpath.util.DefaultValueDetectorImpl;
import gsonpath.util.ExtensionsHandler;
import gsonpath.util.FieldGetterFinder;
import gsonpath.util.FileWriter;
import gsonpath.util.ProcessorTypeHandler;
import gsonpath.util.TypeHandler;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgsonpath/DependencyFactory;", "", "()V", "create", "Lgsonpath/Dependencies;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "standard"})
public final class DependencyFactory {
    public static final DependencyFactory INSTANCE;

    @NotNull
    public final Dependencies create(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
        FileWriter fileWriter = new FileWriter(processingEnv);
        DefaultValueDetectorImpl defaultValueDetector = new DefaultValueDetectorImpl(processingEnv);
        ProcessorTypeHandler typeHandler = new ProcessorTypeHandler(processingEnv);
        FieldGetterFinder fieldGetterFinder = new FieldGetterFinder((TypeHandler)typeHandler);
        AnnotationFetcher annotationFetcher = new AnnotationFetcher((TypeHandler)typeHandler, fieldGetterFinder);
        GsonObjectFactory gsonObjectFactory = new GsonObjectFactory(new GsonObjectValidator(), new FieldPathFetcher(SerializedNameFetcher.INSTANCE, new FieldNamingPolicyMapper()));
        GsonObjectTreeFactory gsonObjectTreeFactory = new GsonObjectTreeFactory(gsonObjectFactory);
        List<GsonPathExtension> extensions = ExtensionsLoader.INSTANCE.loadExtensions((TypeHandler)typeHandler, new Logger(processingEnv));
        ExtensionsHandler extensionsHandler = new ExtensionsHandler(processingEnv, extensions);
        ReadFunctions readFunctions = new ReadFunctions(extensionsHandler);
        WriteFunctions writeFunctions = new WriteFunctions(extensionsHandler);
        ModelInterfaceGenerator modelInterfaceGenerator = new ModelInterfaceGenerator(new InterfaceModelMetadataFactory((TypeHandler)typeHandler), fileWriter);
        AdapterModelMetadataFactory adapterModelMetadataFactory = new AdapterModelMetadataFactory(new FieldInfoFactory((TypeHandler)typeHandler, new FieldTypeFactory((TypeHandler)typeHandler), fieldGetterFinder, annotationFetcher, (DefaultValueDetector)defaultValueDetector), gsonObjectTreeFactory, (TypeHandler)typeHandler, modelInterfaceGenerator);
        return new Dependencies(new AutoGsonAdapterGenerator(adapterModelMetadataFactory, fileWriter, readFunctions, writeFunctions), new TypeAdapterFactoryGenerator(fileWriter));
    }

    private DependencyFactory() {
    }

    static {
        DependencyFactory dependencyFactory;
        INSTANCE = dependencyFactory = new DependencyFactory();
    }
}

