/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.generator.adapter.read;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import gsonpath.FlattenJson;
import gsonpath.ProcessingException;
import gsonpath.compiler.SharedFunctionsKt;
import gsonpath.generator.adapter.read.ReadFunctions;
import gsonpath.generator.adapter.read.ReadParams;
import gsonpath.model.FieldInfo;
import gsonpath.model.GsonArray;
import gsonpath.model.GsonArrayElement;
import gsonpath.model.GsonField;
import gsonpath.model.GsonModel;
import gsonpath.model.GsonObject;
import gsonpath.model.MandatoryFieldInfoFactory;
import gsonpath.model.SubTypeMetadata;
import gsonpath.util.CodeBlockExtKt;
import gsonpath.util.ExtensionsHandler;
import gsonpath.util.MethodSpecExt;
import gsonpath.util.MethodSpecExtKt;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0013\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J.\u0010\u0014\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0018\u001a\u00020\u0015H\u0002J<\u0010\u0019\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J4\u0010\u001f\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J,\u0010!\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J.\u0010#\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010&\u001a\u00020'*\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006*"}, d2={"Lgsonpath/generator/adapter/read/ReadFunctions;", "", "()V", "createReadMethod", "Lcom/squareup/javapoet/MethodSpec;", "params", "Lgsonpath/generator/adapter/read/ReadParams;", "extensionsHandler", "Lgsonpath/util/ExtensionsHandler;", "getVariableName", "", "gsonField", "Lgsonpath/model/GsonField;", "requiresConstructorInjection", "", "isCheckIfNullApplicable", "addInitialisationBlock", "", "Lcom/squareup/javapoet/CodeBlock$Builder;", "addMandatoryValuesCheck", "addReadCodeForElements", "", "jsonMapping", "Lgsonpath/model/GsonObject;", "recursionCount", "addReadCodeForModel", "key", "value", "Lgsonpath/model/GsonModel;", "counterVariableName", "currentOverallRecursionCount", "writeGsonArrayReader", "Lgsonpath/model/GsonArray;", "writeGsonArrayReaderCases", "seedValue", "writeGsonFieldReader", "mandatoryFieldInfo", "Lgsonpath/model/MandatoryFieldInfoFactory$MandatoryFieldInfo;", "writeGsonFieldReading", "Lgsonpath/generator/adapter/read/ReadFunctions$FieldReaderResult;", "Companion", "FieldReaderResult", "standard"})
public final class ReadFunctions {
    private static final ClassName CLASS_NAME_JSON_ELEMENT;
    private static final String RESULT = "result";
    private static final String MANDATORY_FIELDS_CHECK_LIST = "mandatoryFieldsCheckList";
    private static final String MANDATORY_FIELDS_SIZE = "MANDATORY_FIELDS_SIZE";
    private static final String MANDATORY_FIELD_INDEX = "mandatoryFieldIndex";
    private static final String FIELD_NAME = "fieldName";
    private static final String JSON_FIELD_MISSING_EXCEPTION = "gsonpath.JsonFieldMissingException";
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final MethodSpec createReadMethod(@NotNull ReadParams params, @NotNull ExtensionsHandler extensionsHandler) throws ProcessingException {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)extensionsHandler, (String)"extensionsHandler");
        return MethodSpecExtKt.applyAndBuild((MethodSpec.Builder)MethodSpecExt.INSTANCE.overrideMethodBuilder("read"), (Function1)((Function1)new Function1<MethodSpec.Builder, Unit>(this, params, extensionsHandler){
            final /* synthetic */ ReadFunctions this$0;
            final /* synthetic */ ReadParams $params;
            final /* synthetic */ ExtensionsHandler $extensionsHandler;

            public final void invoke(@NotNull MethodSpec.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.returns((TypeName)this.$params.getBaseElement());
                $receiver.addParameter((Type)((Object)JsonReader.class), "in", new Modifier[0]);
                $receiver.addException((Type)((Object)IOException.class));
                MethodSpecExtKt.code((MethodSpec.Builder)$receiver, (Function1)((Function1)new Function1<CodeBlock.Builder, Unit>(this){
                    final /* synthetic */ createReadMethod.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull CodeBlock.Builder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Ensure the object is not null.");
                        Object object = new Object[]{};
                        Function1 function1 = createReadMethod.1.INSTANCE;
                        CodeBlockExtKt.if((CodeBlock.Builder)$receiver, (String)"!isValidValue(in)", (Object[])object, (Function1)function1);
                        ReadFunctions.access$addInitialisationBlock(this.this$0.this$0, $receiver, this.this$0.$params);
                        ReadFunctions.addReadCodeForElements$default(this.this$0.this$0, $receiver, this.this$0.$params.getRootElements(), this.this$0.$params, this.this$0.$extensionsHandler, 0, 8, null);
                        ReadFunctions.access$addMandatoryValuesCheck(this.this$0.this$0, $receiver, this.this$0.$params);
                        if (!this.this$0.$params.getRequiresConstructorInjection()) {
                            ReadFunctions.access$Companion();
                            CodeBlockExtKt.return((CodeBlock.Builder)$receiver, (String)"result", (Object[])new Object[0]);
                        } else {
                            Collection<String> collection;
                            void $receiver$iv$iv;
                            void $receiver$iv;
                            object = this.this$0.$params.getFlattenedFields();
                            TypeName typeName = (TypeName)this.this$0.$params.getConcreteElement();
                            CodeBlock.Builder builder = $receiver;
                            function1 = $receiver$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (T item$iv$iv : $receiver$iv$iv) {
                                void it;
                                GsonField gsonField = (GsonField)item$iv$iv;
                                collection = destination$iv$iv;
                                String string = it.getVariableName();
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            CodeBlockExtKt.multiLinedNewObject((CodeBlock.Builder)builder, (TypeName)typeName, (List)collection);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = readFunctions;
                this.$params = readParams;
                this.$extensionsHandler = extensionsHandler;
                super(1);
            }
        }));
    }

    private final void addInitialisationBlock(@NotNull CodeBlock.Builder $receiver, ReadParams params) {
        if (!params.getRequiresConstructorInjection()) {
            CodeBlockExtKt.createVariableNew((CodeBlock.Builder)$receiver, (String)"$T", (String)RESULT, (String)"$T()", (Object[])new Object[]{params.getConcreteElement(), params.getConcreteElement()});
        } else {
            Iterable $receiver$iv = params.getFlattenedFields();
            for (Object element$iv : $receiver$iv) {
                GsonField it = (GsonField)element$iv;
                CodeBlockExtKt.createVariable((CodeBlock.Builder)$receiver, (String)"$T", (String)it.getVariableName(), (String)SharedFunctionsKt.createDefaultVariableValueForTypeName((TypeName)it.getFieldInfo().getTypeName()), (Object[])new Object[]{it.getFieldInfo().getTypeName()});
            }
        }
        Map<String, MandatoryFieldInfoFactory.MandatoryFieldInfo> map2 = params.getMandatoryInfoMap();
        if (!map2.isEmpty()) {
            CodeBlockExtKt.createVariableNew((CodeBlock.Builder)$receiver, (String)"boolean[]", (String)MANDATORY_FIELDS_CHECK_LIST, (String)"boolean[MANDATORY_FIELDS_SIZE]", (Object[])new Object[0]);
        }
        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
    }

    private final int addReadCodeForElements(@NotNull CodeBlock.Builder $receiver, GsonObject jsonMapping, ReadParams params, ExtensionsHandler extensionsHandler, int recursionCount) throws ProcessingException {
        int jsonMappingSize = jsonMapping.size();
        if (jsonMappingSize == 0) {
            return recursionCount;
        }
        String counterVariableName = "jsonFieldCounter" + recursionCount;
        CodeBlockExtKt.createVariable((CodeBlock.Builder)$receiver, (String)"int", (String)counterVariableName, (String)"0", (Object[])new Object[0]);
        $receiver.addStatement("in.beginObject()", new Object[0]);
        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
        Object object = new Object[]{};
        Function1 function1 = (Function1)new Function1<CodeBlock.Builder, Integer>(this, counterVariableName, jsonMappingSize, jsonMapping, recursionCount, params, extensionsHandler){
            final /* synthetic */ ReadFunctions this$0;
            final /* synthetic */ String $counterVariableName;
            final /* synthetic */ int $jsonMappingSize;
            final /* synthetic */ GsonObject $jsonMapping;
            final /* synthetic */ int $recursionCount;
            final /* synthetic */ ReadParams $params;
            final /* synthetic */ ExtensionsHandler $extensionsHandler;

            public final int invoke(@NotNull CodeBlock.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Object[] objectArray = new Object[]{};
                Function1 function1 = addReadCodeForElements.1.INSTANCE;
                CodeBlockExtKt.if((CodeBlock.Builder)$receiver, (String)(this.$counterVariableName + " == " + this.$jsonMappingSize), (Object[])objectArray, (Function1)function1);
                CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
                objectArray = new Object[]{};
                function1 = (Function1)new Function1<CodeBlock.Builder, Integer>(this){
                    final /* synthetic */ addReadCodeForElements.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final int invoke(@NotNull CodeBlock.Builder $receiver) {
                        int n;
                        void $receiver$iv;
                        int initial$iv;
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Iterable iterable = this.this$0.$jsonMapping.entries();
                        int accumulator$iv = initial$iv = this.this$0.$recursionCount + 1;
                        for (T element$iv : $receiver$iv) {
                            void entry;
                            Map.Entry entry2 = (Map.Entry)element$iv;
                            int currentOverallRecursionCount = accumulator$iv;
                            accumulator$iv = ReadFunctions.access$addReadCodeForModel(this.this$0.this$0, $receiver, this.this$0.$params, this.this$0.$extensionsHandler, (String)entry.getKey(), (GsonModel)entry.getValue(), this.this$0.$counterVariableName, currentOverallRecursionCount);
                        }
                        int it = n = accumulator$iv;
                        CodeBlockExtKt.default((CodeBlock.Builder)$receiver, (Function1)addReadCodeForElements.2.1.INSTANCE);
                        return n;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                return ((Number)CodeBlockExtKt.switch((CodeBlock.Builder)$receiver, (String)"in.nextName()", (Object[])objectArray, (Function1)function1)).intValue();
            }
            {
                this.this$0 = readFunctions;
                this.$counterVariableName = string;
                this.$jsonMappingSize = n;
                this.$jsonMapping = gsonObject;
                this.$recursionCount = n2;
                this.$params = readParams;
                this.$extensionsHandler = extensionsHandler;
                super(1);
            }
        };
        object = CodeBlockExtKt.while((CodeBlock.Builder)$receiver, (String)"in.hasNext()", (Object[])object, (Function1)function1);
        int it = ((Number)object).intValue();
        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
        $receiver.addStatement("in.endObject()", new Object[0]);
        return ((Number)object).intValue();
    }

    static /* synthetic */ int addReadCodeForElements$default(ReadFunctions readFunctions, CodeBlock.Builder builder, GsonObject gsonObject, ReadParams readParams, ExtensionsHandler extensionsHandler, int n, int n2, Object object) throws ProcessingException {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return readFunctions.addReadCodeForElements(builder, gsonObject, readParams, extensionsHandler, n);
    }

    private final int addReadCodeForModel(@NotNull CodeBlock.Builder $receiver, ReadParams params, ExtensionsHandler extensionsHandler, String key, GsonModel value, String counterVariableName, int currentOverallRecursionCount) {
        return ((Number)CodeBlockExtKt.case((CodeBlock.Builder)$receiver, (String)('\"' + key + '\"'), (Function1)((Function1)new Function1<CodeBlock.Builder, Integer>(this, counterVariableName, value, params, extensionsHandler, currentOverallRecursionCount, key){
            final /* synthetic */ ReadFunctions this$0;
            final /* synthetic */ String $counterVariableName;
            final /* synthetic */ GsonModel $value;
            final /* synthetic */ ReadParams $params;
            final /* synthetic */ ExtensionsHandler $extensionsHandler;
            final /* synthetic */ int $currentOverallRecursionCount;
            final /* synthetic */ String $key;

            public final int invoke(@NotNull CodeBlock.Builder $receiver) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.addStatement(this.$counterVariableName + "++", new Object[0]);
                GsonModel gsonModel = this.$value;
                if (gsonModel instanceof GsonField) {
                    ReadFunctions.access$writeGsonFieldReader(this.this$0, $receiver, (GsonField)this.$value, this.$params.getRequiresConstructorInjection(), this.$params.getMandatoryInfoMap().get(((GsonField)this.$value).getFieldInfo().getFieldName()), this.$extensionsHandler);
                    n = this.$currentOverallRecursionCount;
                } else if (gsonModel instanceof GsonObject) {
                    CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
                    CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Ensure the object is not null.");
                    Object[] objectArray = new Object[]{};
                    Function1 function1 = addReadCodeForModel.1.INSTANCE;
                    CodeBlockExtKt.if((CodeBlock.Builder)$receiver, (String)"!isValidValue(in)", (Object[])objectArray, (Function1)function1);
                    n = ReadFunctions.access$addReadCodeForElements(this.this$0, $receiver, (GsonObject)this.$value, this.$params, this.$extensionsHandler, this.$currentOverallRecursionCount);
                } else if (gsonModel instanceof GsonArray) {
                    n = ReadFunctions.access$writeGsonArrayReader(this.this$0, $receiver, (GsonArray)this.$value, this.$params, this.$key, this.$extensionsHandler, this.$currentOverallRecursionCount);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return n;
            }
            {
                this.this$0 = readFunctions;
                this.$counterVariableName = string;
                this.$value = gsonModel;
                this.$params = readParams;
                this.$extensionsHandler = extensionsHandler;
                this.$currentOverallRecursionCount = n;
                this.$key = string2;
                super(1);
            }
        }))).intValue();
    }

    private final void writeGsonFieldReader(@NotNull CodeBlock.Builder $receiver, GsonField gsonField, boolean requiresConstructorInjection, MandatoryFieldInfoFactory.MandatoryFieldInfo mandatoryFieldInfo, ExtensionsHandler extensionsHandler) throws ProcessingException {
        CodeBlock extensionsCodeBlock2;
        Object[] objectArray;
        FieldInfo fieldInfo = gsonField.getFieldInfo();
        TypeName fieldTypeName = fieldInfo.getTypeName();
        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
        FieldReaderResult result = this.writeGsonFieldReading($receiver, gsonField, requiresConstructorInjection);
        if (result.getCheckIfNull()) {
            Object[] objectArray2 = new Object[]{};
            objectArray = (Object[])new Function1<CodeBlock.Builder, Unit>(requiresConstructorInjection, fieldInfo, gsonField, result, mandatoryFieldInfo){
                final /* synthetic */ boolean $requiresConstructorInjection;
                final /* synthetic */ FieldInfo $fieldInfo;
                final /* synthetic */ GsonField $gsonField;
                final /* synthetic */ FieldReaderResult $result;
                final /* synthetic */ MandatoryFieldInfoFactory.MandatoryFieldInfo $mandatoryFieldInfo;

                public final void invoke(@NotNull CodeBlock.Builder $receiver) {
                    String assignmentBlock;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    String string = assignmentBlock = !this.$requiresConstructorInjection ? "result." + this.$fieldInfo.getFieldName() : this.$gsonField.getVariableName();
                    if (this.$result.getCallToString()) {
                        CodeBlockExtKt.assign((CodeBlock.Builder)$receiver, (String)assignmentBlock, (String)(this.$result.getVariableName() + ".toString()"), (Object[])new Object[0]);
                    } else {
                        CodeBlockExtKt.assign((CodeBlock.Builder)$receiver, (String)assignmentBlock, (String)this.$result.getVariableName(), (Object[])new Object[0]);
                    }
                    if (this.$mandatoryFieldInfo != null) {
                        CodeBlockExtKt.assign((CodeBlock.Builder)$receiver, (String)("mandatoryFieldsCheckList[" + this.$mandatoryFieldInfo.getIndexVariableName() + ']'), (String)"true", (Object[])new Object[0]);
                        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
                        $receiver.nextControlFlow("else", new Object[0]);
                        CodeBlockExtKt.addEscapedStatement((CodeBlock.Builder)$receiver, (String)("throw new gsonpath.JsonFieldMissingException(\"Mandatory JSON element '" + this.$gsonField.getJsonPath() + "' was null for class '" + this.$fieldInfo.getParentClassName() + "'\")"));
                    }
                }
                {
                    this.$requiresConstructorInjection = bl;
                    this.$fieldInfo = fieldInfo;
                    this.$gsonField = gsonField;
                    this.$result = fieldReaderResult;
                    this.$mandatoryFieldInfo = mandatoryFieldInfo;
                    super(1);
                }
            };
            CodeBlockExtKt.if((CodeBlock.Builder)$receiver, (String)(result.getVariableName() + " != null"), (Object[])objectArray2, (Function1)objectArray);
        }
        if (!(extensionsCodeBlock2 = CodeBlockExtKt.codeBlock((Function1)((Function1)new Function1<CodeBlock.Builder, Unit>(extensionsHandler, gsonField, result){
            final /* synthetic */ ExtensionsHandler $extensionsHandler;
            final /* synthetic */ GsonField $gsonField;
            final /* synthetic */ FieldReaderResult $result;

            public final void invoke(@NotNull CodeBlock.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                this.$extensionsHandler.handle(this.$gsonField, this.$result.getVariableName(), (Function2<? super String, ? super CodeBlock, Unit>)((Function2)new Function2<String, CodeBlock, Unit>($receiver){
                    final /* synthetic */ CodeBlock.Builder $this_codeBlock;

                    public final void invoke(@NotNull String extensionName, @NotNull CodeBlock validationCodeBlock) {
                        Intrinsics.checkParameterIsNotNull((Object)extensionName, (String)"extensionName");
                        Intrinsics.checkParameterIsNotNull((Object)validationCodeBlock, (String)"validationCodeBlock");
                        CodeBlockExtKt.newLine((CodeBlock.Builder)this.$this_codeBlock);
                        CodeBlockExtKt.comment((CodeBlock.Builder)this.$this_codeBlock, (String)("Extension - " + extensionName));
                        this.$this_codeBlock.add(validationCodeBlock);
                        CodeBlockExtKt.newLine((CodeBlock.Builder)this.$this_codeBlock);
                    }
                    {
                        this.$this_codeBlock = builder;
                        super(2);
                    }
                }));
            }
            {
                this.$extensionsHandler = extensionsHandler;
                this.$gsonField = gsonField;
                this.$result = fieldReaderResult;
                super(1);
            }
        }))).isEmpty()) {
            CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
            CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Gsonpath Extensions");
            if (!fieldTypeName.isPrimitive()) {
                objectArray = new Object[]{};
                Function1 function1 = (Function1)new Function1<CodeBlock.Builder, CodeBlock.Builder>(extensionsCodeBlock2){
                    final /* synthetic */ CodeBlock $extensionsCodeBlock;

                    public final CodeBlock.Builder invoke(@NotNull CodeBlock.Builder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        return $receiver.add(this.$extensionsCodeBlock);
                    }
                    {
                        this.$extensionsCodeBlock = codeBlock;
                        super(1);
                    }
                };
                CodeBlockExtKt.if((CodeBlock.Builder)$receiver, (String)(result.getVariableName() + " != null"), (Object[])objectArray, (Function1)function1);
            } else {
                $receiver.add(extensionsCodeBlock2);
            }
        }
    }

    private final FieldReaderResult writeGsonFieldReading(@NotNull CodeBlock.Builder $receiver, GsonField gsonField, boolean requiresConstructorInjection) {
        FlattenJson annotation;
        FieldInfo fieldInfo = gsonField.getFieldInfo();
        TypeName fieldTypeName = fieldInfo.getTypeName().box();
        if (Intrinsics.areEqual((Object)fieldInfo.getTypeName(), (Object)SharedFunctionsKt.getCLASS_NAME_STRING()) && (annotation = (FlattenJson)fieldInfo.getAnnotation(FlattenJson.class)) != null) {
            String variableName = requiresConstructorInjection ? gsonField.getVariableName() + "_safe" : gsonField.getVariableName();
            CodeBlockExtKt.createVariable((CodeBlock.Builder)$receiver, (String)"$T", (String)variableName, (String)"mGson.getAdapter($T.class).read(in)", (Object[])new Object[]{CLASS_NAME_JSON_ELEMENT, CLASS_NAME_JSON_ELEMENT});
            return new FieldReaderResult(variableName, true, true);
        }
        String variableName = this.getVariableName(gsonField, requiresConstructorInjection);
        boolean checkIfResultIsNull = this.isCheckIfNullApplicable(gsonField, requiresConstructorInjection);
        SubTypeMetadata subTypeMetadata = gsonField.getSubTypeMetadata();
        if (subTypeMetadata != null) {
            if (checkIfResultIsNull) {
                String string = "($T) " + subTypeMetadata.getGetterName() + "().read(in)";
                Object[] objectArray = new Object[2];
                TypeName typeName = fieldTypeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldTypeName");
                objectArray[0] = typeName;
                objectArray[1] = fieldTypeName;
                CodeBlockExtKt.createVariable((CodeBlock.Builder)$receiver, (String)"$T", (String)variableName, (String)string, (Object[])objectArray);
            } else {
                String string = "($T) " + subTypeMetadata.getGetterName() + "().read(in)";
                Object[] objectArray = new Object[1];
                TypeName typeName = fieldTypeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldTypeName");
                objectArray[0] = typeName;
                CodeBlockExtKt.assign((CodeBlock.Builder)$receiver, (String)variableName, (String)string, (Object[])objectArray);
            }
        } else {
            String adapterName;
            String string = adapterName = fieldTypeName instanceof ParameterizedTypeName ? "new com.google.gson.reflect.TypeToken<$T>(){}" : "$T.class";
            if (checkIfResultIsNull) {
                String string2 = "mGson.getAdapter(" + adapterName + ").read(in)";
                Object[] objectArray = new Object[2];
                TypeName typeName = fieldTypeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldTypeName");
                objectArray[0] = typeName;
                objectArray[1] = fieldTypeName;
                CodeBlockExtKt.createVariable((CodeBlock.Builder)$receiver, (String)"$T", (String)variableName, (String)string2, (Object[])objectArray);
            } else {
                String string3 = "mGson.getAdapter(" + adapterName + ").read(in)";
                Object[] objectArray = new Object[1];
                TypeName typeName = fieldTypeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldTypeName");
                objectArray[0] = typeName;
                CodeBlockExtKt.assign((CodeBlock.Builder)$receiver, (String)variableName, (String)string3, (Object[])objectArray);
            }
        }
        return new FieldReaderResult(variableName, checkIfResultIsNull, false, 4, null);
    }

    private final int writeGsonArrayReader(@NotNull CodeBlock.Builder $receiver, GsonArray value, ReadParams params, String key, ExtensionsHandler extensionsHandler, int currentOverallRecursionCount) {
        String arrayIndexVariableName = key + "_arrayIndex";
        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
        CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Ensure the array is not null.");
        Object object = new Object[]{};
        Function1 function1 = writeGsonArrayReader.1.INSTANCE;
        CodeBlockExtKt.if((CodeBlock.Builder)$receiver, (String)"!isValidValue(in)", (Object[])object, (Function1)function1);
        $receiver.addStatement("in.beginArray()", new Object[0]);
        CodeBlockExtKt.createVariable((CodeBlock.Builder)$receiver, (String)"int", (String)arrayIndexVariableName, (String)"0", (Object[])new Object[0]);
        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
        CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Iterate through the array.");
        object = new Object[]{};
        function1 = (Function1)new Function1<CodeBlock.Builder, Integer>(this, arrayIndexVariableName, value, params, currentOverallRecursionCount, extensionsHandler){
            final /* synthetic */ ReadFunctions this$0;
            final /* synthetic */ String $arrayIndexVariableName;
            final /* synthetic */ GsonArray $value;
            final /* synthetic */ ReadParams $params;
            final /* synthetic */ int $currentOverallRecursionCount;
            final /* synthetic */ ExtensionsHandler $extensionsHandler;

            public final int invoke(@NotNull CodeBlock.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Object object = new Object[]{};
                Function1 function1 = (Function1)new Function1<CodeBlock.Builder, Integer>(this){
                    final /* synthetic */ writeGsonArrayReader.2 this$0;

                    public final int invoke(@NotNull CodeBlock.Builder $receiver) {
                        int n;
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        int it = n = ReadFunctions.access$writeGsonArrayReaderCases(this.this$0.this$0, $receiver, this.this$0.$value, this.this$0.$params, this.this$0.$currentOverallRecursionCount, this.this$0.$extensionsHandler);
                        CodeBlockExtKt.default((CodeBlock.Builder)$receiver, (Function1)writeGsonArrayReader.1.1.INSTANCE);
                        return n;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                object = CodeBlockExtKt.switch((CodeBlock.Builder)$receiver, (String)this.$arrayIndexVariableName, (Object[])object, (Function1)function1);
                int it = ((Number)object).intValue();
                $receiver.addStatement(this.$arrayIndexVariableName + "++", new Object[0]);
                return ((Number)object).intValue();
            }
            {
                this.this$0 = readFunctions;
                this.$arrayIndexVariableName = string;
                this.$value = gsonArray;
                this.$params = readParams;
                this.$currentOverallRecursionCount = n;
                this.$extensionsHandler = extensionsHandler;
                super(1);
            }
        };
        object = CodeBlockExtKt.while((CodeBlock.Builder)$receiver, (String)"in.hasNext()", (Object[])object, (Function1)function1);
        int it = ((Number)object).intValue();
        $receiver.addStatement("in.endArray()", new Object[0]);
        return ((Number)object).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final int writeGsonArrayReaderCases(@NotNull CodeBlock.Builder $receiver, GsonArray value, ReadParams params, int seedValue, ExtensionsHandler extensionsHandler) {
        void $receiver$iv;
        int initial$iv;
        Iterable iterable = value.entries();
        int accumulator$iv = initial$iv = seedValue;
        for (Object element$iv : $receiver$iv) {
            void $arrayIndex_arrayItemValue;
            Map.Entry entry = (Map.Entry)element$iv;
            int previousRecursionCount = accumulator$iv;
            void var13_13 = $arrayIndex_arrayItemValue;
            int arrayIndex = ((Number)var13_13.getKey()).intValue();
            var13_13 = $arrayIndex_arrayItemValue;
            GsonArrayElement arrayItemValue = (GsonArrayElement)var13_13.getValue();
            accumulator$iv = ((Number)CodeBlockExtKt.case((CodeBlock.Builder)$receiver, (String)String.valueOf(arrayIndex), (Function1)((Function1)new Function1<CodeBlock.Builder, Integer>(arrayItemValue, previousRecursionCount, this, $receiver, params, extensionsHandler){
                final /* synthetic */ GsonArrayElement $arrayItemValue;
                final /* synthetic */ int $previousRecursionCount;
                final /* synthetic */ ReadFunctions this$0;
                final /* synthetic */ CodeBlock.Builder $this_writeGsonArrayReaderCases$inlined;
                final /* synthetic */ ReadParams $params$inlined;
                final /* synthetic */ ExtensionsHandler $extensionsHandler$inlined;
                {
                    this.$arrayItemValue = gsonArrayElement;
                    this.$previousRecursionCount = n;
                    this.this$0 = readFunctions;
                    this.$this_writeGsonArrayReaderCases$inlined = builder;
                    this.$params$inlined = readParams;
                    this.$extensionsHandler$inlined = extensionsHandler;
                    super(1);
                }

                public final int invoke(@NotNull CodeBlock.Builder $receiver) {
                    int n;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    GsonArrayElement gsonArrayElement = this.$arrayItemValue;
                    if (gsonArrayElement instanceof GsonField) {
                        ReadFunctions.access$writeGsonFieldReader(this.this$0, $receiver, (GsonField)this.$arrayItemValue, this.$params$inlined.getRequiresConstructorInjection(), this.$params$inlined.getMandatoryInfoMap().get(((GsonField)this.$arrayItemValue).getFieldInfo().getFieldName()), this.$extensionsHandler$inlined);
                        n = this.$previousRecursionCount;
                    } else if (gsonArrayElement instanceof GsonObject) {
                        n = ReadFunctions.access$addReadCodeForElements(this.this$0, $receiver, (GsonObject)this.$arrayItemValue, this.$params$inlined, this.$extensionsHandler$inlined, this.$previousRecursionCount);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return n;
                }
            }))).intValue();
        }
        return accumulator$iv;
    }

    private final void addMandatoryValuesCheck(@NotNull CodeBlock.Builder $receiver, ReadParams params) {
        if (params.getMandatoryInfoMap().isEmpty()) {
            return;
        }
        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
        CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Mandatory object validation");
        Object[] objectArray = new Object[]{};
        Function1 function1 = (Function1)new Function1<CodeBlock.Builder, CodeBlock.Builder>(params){
            final /* synthetic */ ReadParams $params;

            public final CodeBlock.Builder invoke(@NotNull CodeBlock.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
                CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Check if a mandatory value is missing.");
                Object[] objectArray = new Object[]{};
                Function1 function1 = (Function1)new Function1<CodeBlock.Builder, CodeBlock.Builder>(this){
                    final /* synthetic */ addMandatoryValuesCheck.1 this$0;

                    public final CodeBlock.Builder invoke(@NotNull CodeBlock.Builder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        CodeBlockExtKt.newLine((CodeBlock.Builder)$receiver);
                        CodeBlockExtKt.comment((CodeBlock.Builder)$receiver, (String)"Find the field name of the missing json value.");
                        ReadFunctions.access$Companion();
                        CodeBlockExtKt.createVariable((CodeBlock.Builder)$receiver, (String)"String", (String)"fieldName", (String)"null", (Object[])new Object[0]);
                        ReadFunctions.access$Companion();
                        Object[] objectArray = new Object[]{};
                        Function1 function1 = (Function1)new Function1<CodeBlock.Builder, Unit>(this){
                            final /* synthetic */ addMandatoryValuesCheck.1 this$0;

                            public final void invoke(@NotNull CodeBlock.Builder $receiver) {
                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                Map<String, MandatoryFieldInfoFactory.MandatoryFieldInfo> map2 = this.this$0.this$0.$params.getMandatoryInfoMap();
                                Iterator<Map.Entry<String, MandatoryFieldInfoFactory.MandatoryFieldInfo>> iterator = map2.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry<String, MandatoryFieldInfoFactory.MandatoryFieldInfo> entry;
                                    Map.Entry<String, MandatoryFieldInfoFactory.MandatoryFieldInfo> entry2 = entry = iterator.next();
                                    MandatoryFieldInfoFactory.MandatoryFieldInfo mandatoryFieldInfo = entry2.getValue();
                                    CodeBlockExtKt.case((CodeBlock.Builder)$receiver, (String)mandatoryFieldInfo.getIndexVariableName(), (Function1)((Function1)new Function1<CodeBlock.Builder, CodeBlock.Builder>(mandatoryFieldInfo){
                                        final /* synthetic */ MandatoryFieldInfoFactory.MandatoryFieldInfo $mandatoryFieldInfo;

                                        @NotNull
                                        public final CodeBlock.Builder invoke(@NotNull CodeBlock.Builder $receiver) {
                                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                            return CodeBlockExtKt.addEscapedStatement((CodeBlock.Builder)$receiver, (String)("fieldName = \"" + this.$mandatoryFieldInfo.getGsonField().getJsonPath() + '\"'));
                                        }
                                        {
                                            this.$mandatoryFieldInfo = mandatoryFieldInfo;
                                            super(1);
                                        }
                                    }));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        };
                        CodeBlockExtKt.switch((CodeBlock.Builder)$receiver, (String)"mandatoryFieldIndex", (Object[])objectArray, (Function1)function1);
                        return $receiver.addStatement("throw new gsonpath.JsonFieldMissingException(\"Mandatory JSON element '\" + fieldName + \"' was not found for class '" + this.this$0.$params.getConcreteElement() + "'\")", new Object[0]);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                return (CodeBlock.Builder)CodeBlockExtKt.if((CodeBlock.Builder)$receiver, (String)"!mandatoryFieldsCheckList[mandatoryFieldIndex]", (Object[])objectArray, (Function1)function1);
            }
            {
                this.$params = readParams;
                super(1);
            }
        };
        CodeBlockExtKt.for((CodeBlock.Builder)$receiver, (String)"int mandatoryFieldIndex = 0; mandatoryFieldIndex < MANDATORY_FIELDS_SIZE; mandatoryFieldIndex++", (Object[])objectArray, (Function1)function1);
    }

    private final String getVariableName(GsonField gsonField, boolean requiresConstructorInjection) {
        return gsonField.isRequired() && requiresConstructorInjection ? gsonField.getVariableName() + "_safe" : gsonField.getVariableName();
    }

    private final boolean isCheckIfNullApplicable(GsonField gsonField, boolean requiresConstructorInjection) {
        return !requiresConstructorInjection || gsonField.isRequired();
    }

    static {
        Companion = new Companion(null);
        ClassName className = ClassName.get(JsonElement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"ClassName.get(JsonElement::class.java)");
        CLASS_NAME_JSON_ELEMENT = className;
    }

    public static final /* synthetic */ void access$addInitialisationBlock(ReadFunctions $this, @NotNull CodeBlock.Builder $receiver, @NotNull ReadParams params) {
        $this.addInitialisationBlock($receiver, params);
    }

    public static final /* synthetic */ void access$addMandatoryValuesCheck(ReadFunctions $this, @NotNull CodeBlock.Builder $receiver, @NotNull ReadParams params) {
        $this.addMandatoryValuesCheck($receiver, params);
    }

    public static final /* synthetic */ int access$addReadCodeForModel(ReadFunctions $this, @NotNull CodeBlock.Builder $receiver, @NotNull ReadParams params, @NotNull ExtensionsHandler extensionsHandler, @NotNull String key, @NotNull GsonModel value, @NotNull String counterVariableName, int currentOverallRecursionCount) {
        return $this.addReadCodeForModel($receiver, params, extensionsHandler, key, value, counterVariableName, currentOverallRecursionCount);
    }

    public static final /* synthetic */ void access$writeGsonFieldReader(ReadFunctions $this, @NotNull CodeBlock.Builder $receiver, @NotNull GsonField gsonField, boolean requiresConstructorInjection, @Nullable MandatoryFieldInfoFactory.MandatoryFieldInfo mandatoryFieldInfo, @NotNull ExtensionsHandler extensionsHandler) {
        $this.writeGsonFieldReader($receiver, gsonField, requiresConstructorInjection, mandatoryFieldInfo, extensionsHandler);
    }

    public static final /* synthetic */ int access$addReadCodeForElements(ReadFunctions $this, @NotNull CodeBlock.Builder $receiver, @NotNull GsonObject jsonMapping, @NotNull ReadParams params, @NotNull ExtensionsHandler extensionsHandler, int recursionCount) {
        return $this.addReadCodeForElements($receiver, jsonMapping, params, extensionsHandler, recursionCount);
    }

    public static final /* synthetic */ int access$writeGsonArrayReader(ReadFunctions $this, @NotNull CodeBlock.Builder $receiver, @NotNull GsonArray value, @NotNull ReadParams params, @NotNull String key, @NotNull ExtensionsHandler extensionsHandler, int currentOverallRecursionCount) {
        return $this.writeGsonArrayReader($receiver, value, params, key, extensionsHandler, currentOverallRecursionCount);
    }

    public static final /* synthetic */ int access$writeGsonArrayReaderCases(ReadFunctions $this, @NotNull CodeBlock.Builder $receiver, @NotNull GsonArray value, @NotNull ReadParams params, int seedValue, @NotNull ExtensionsHandler extensionsHandler) {
        return $this.writeGsonArrayReaderCases($receiver, value, params, seedValue, extensionsHandler);
    }

    @NotNull
    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lgsonpath/generator/adapter/read/ReadFunctions$FieldReaderResult;", "", "variableName", "", "checkIfNull", "", "callToString", "(Ljava/lang/String;ZZ)V", "getCallToString", "()Z", "getCheckIfNull", "getVariableName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "standard"})
    private static final class FieldReaderResult {
        @NotNull
        private final String variableName;
        private final boolean checkIfNull;
        private final boolean callToString;

        @NotNull
        public final String getVariableName() {
            return this.variableName;
        }

        public final boolean getCheckIfNull() {
            return this.checkIfNull;
        }

        public final boolean getCallToString() {
            return this.callToString;
        }

        public FieldReaderResult(@NotNull String variableName, boolean checkIfNull, boolean callToString) {
            Intrinsics.checkParameterIsNotNull((Object)variableName, (String)"variableName");
            this.variableName = variableName;
            this.checkIfNull = checkIfNull;
            this.callToString = callToString;
        }

        public /* synthetic */ FieldReaderResult(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(string, bl, bl2);
        }

        @NotNull
        public final String component1() {
            return this.variableName;
        }

        public final boolean component2() {
            return this.checkIfNull;
        }

        public final boolean component3() {
            return this.callToString;
        }

        @NotNull
        public final FieldReaderResult copy(@NotNull String variableName, boolean checkIfNull, boolean callToString) {
            Intrinsics.checkParameterIsNotNull((Object)variableName, (String)"variableName");
            return new FieldReaderResult(variableName, checkIfNull, callToString);
        }

        @NotNull
        public static /* synthetic */ FieldReaderResult copy$default(FieldReaderResult fieldReaderResult, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = fieldReaderResult.variableName;
            }
            if ((n & 2) != 0) {
                bl = fieldReaderResult.checkIfNull;
            }
            if ((n & 4) != 0) {
                bl2 = fieldReaderResult.callToString;
            }
            return fieldReaderResult.copy(string, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "FieldReaderResult(variableName=" + this.variableName + ", checkIfNull=" + this.checkIfNull + ", callToString=" + this.callToString + ")";
        }

        public int hashCode() {
            String string = this.variableName;
            int n = (string != null ? string.hashCode() : 0) * 31;
            int n2 = this.checkIfNull ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.callToString ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FieldReaderResult)) break block3;
                    FieldReaderResult fieldReaderResult = (FieldReaderResult)object;
                    if (!Intrinsics.areEqual((Object)this.variableName, (Object)fieldReaderResult.variableName) || !(this.checkIfNull == fieldReaderResult.checkIfNull) || !(this.callToString == fieldReaderResult.callToString)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgsonpath/generator/adapter/read/ReadFunctions$Companion;", "", "()V", "CLASS_NAME_JSON_ELEMENT", "Lcom/squareup/javapoet/ClassName;", "FIELD_NAME", "", "JSON_FIELD_MISSING_EXCEPTION", "MANDATORY_FIELDS_CHECK_LIST", "MANDATORY_FIELDS_SIZE", "MANDATORY_FIELD_INDEX", "RESULT", "standard"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

