/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.generator.adapter;

import gsonpath.ProcessingException;
import gsonpath.model.FieldInfo;
import gsonpath.model.GsonField;
import gsonpath.util.TypeHandler;
import java.util.List;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lgsonpath/generator/adapter/SharedFunctions;", "", "()V", "getMirroredClass", "Ljavax/lang/model/type/TypeMirror;", "fieldInfo", "Lgsonpath/model/FieldInfo;", "accessorFunc", "Lkotlin/Function0;", "", "getRawType", "gsonField", "Lgsonpath/model/GsonField;", "isArrayType", "", "typeHandler", "Lgsonpath/util/TypeHandler;", "standard"})
public final class SharedFunctions {
    public static final SharedFunctions INSTANCE;

    @NotNull
    public final TypeMirror getMirroredClass(@NotNull FieldInfo fieldInfo, @NotNull Function0<Unit> accessorFunc) {
        Intrinsics.checkParameterIsNotNull((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkParameterIsNotNull(accessorFunc, (String)"accessorFunc");
        try {
            accessorFunc.invoke();
            throw (Throwable)new ProcessingException("Unexpected annotation processing defect while obtaining class.", fieldInfo.getElement());
        }
        catch (MirroredTypeException mte) {
            TypeMirror typeMirror = mte.getTypeMirror();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"mte.typeMirror");
            TypeMirror typeMirror2 = typeMirror;
            return typeMirror2;
        }
    }

    public final boolean isArrayType(@NotNull TypeHandler typeHandler, @NotNull GsonField gsonField) {
        Intrinsics.checkParameterIsNotNull((Object)typeHandler, (String)"typeHandler");
        Intrinsics.checkParameterIsNotNull((Object)gsonField, (String)"gsonField");
        TypeMirror typeMirror = gsonField.getFieldInfo().getTypeMirror();
        if (typeMirror instanceof ArrayType) {
            return true;
        }
        if (typeHandler.isMirrorOfCollectionType(typeMirror)) {
            return false;
        }
        throw (Throwable)new ProcessingException("Unexpected type found for GsonSubtype field, ensure you either use an array, or a collection class (List, Collection, etc).", gsonField.getFieldInfo().getElement());
    }

    @NotNull
    public final TypeMirror getRawType(@NotNull FieldInfo fieldInfo) {
        TypeMirror typeMirror;
        Intrinsics.checkParameterIsNotNull((Object)fieldInfo, (String)"fieldInfo");
        TypeMirror typeMirror2 = fieldInfo.getTypeMirror();
        if (typeMirror2 instanceof ArrayType) {
            TypeMirror typeMirror3 = ((ArrayType)typeMirror2).getComponentType();
            typeMirror = typeMirror3;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror3, (String)"typeMirror.componentType");
        } else if (typeMirror2 instanceof DeclaredType) {
            List<? extends TypeMirror> list = ((DeclaredType)typeMirror2).getTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeMirror.typeArguments");
            Object object = CollectionsKt.first(list);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"typeMirror.typeArguments.first()");
            typeMirror = (TypeMirror)object;
        } else {
            throw (Throwable)new ProcessingException("Unexpected type found for GsonSubtype field, ensure you either use an array, or a List class.", fieldInfo.getElement());
        }
        return typeMirror;
    }

    @NotNull
    public final TypeMirror getRawType(@NotNull GsonField gsonField) {
        Intrinsics.checkParameterIsNotNull((Object)gsonField, (String)"gsonField");
        return this.getRawType(gsonField.getFieldInfo());
    }

    private SharedFunctions() {
    }

    static {
        SharedFunctions sharedFunctions;
        INSTANCE = sharedFunctions = new SharedFunctions();
    }
}

