/*
 * Decompiled with CFR 0.152.
 */
package gsonpath;

import com.google.common.collect.Sets;
import gsonpath.AutoGsonAdapter;
import gsonpath.AutoGsonAdapterFactory;
import gsonpath.GsonProcessorImpl;
import gsonpath.ProcessingException;
import gsonpath.compiler.GsonPathExtension;
import gsonpath.generator.HandleResult;
import gsonpath.generator.adapter.AdapterModelMetadataFactory;
import gsonpath.generator.adapter.AutoGsonAdapterGenerator;
import gsonpath.generator.adapter.read.ReadFunctions;
import gsonpath.generator.adapter.subtype.SubtypeFunctions;
import gsonpath.generator.adapter.write.WriteFunctions;
import gsonpath.generator.factory.TypeAdapterFactoryGenerator;
import gsonpath.generator.interf.InterfaceModelMetadataFactory;
import gsonpath.generator.interf.ModelInterfaceGenerator;
import gsonpath.model.FieldInfoFactory;
import gsonpath.model.FieldNamingPolicyMapper;
import gsonpath.model.FieldPathFetcher;
import gsonpath.model.GsonObjectFactory;
import gsonpath.model.GsonObjectTreeFactory;
import gsonpath.model.GsonObjectValidator;
import gsonpath.model.SerializedNameFetcher;
import gsonpath.model.SubTypeMetadataFactoryImpl;
import gsonpath.util.AnnotationFetcher;
import gsonpath.util.DefaultValueDetector;
import gsonpath.util.DefaultValueDetectorImpl;
import gsonpath.util.ExtensionsHandler;
import gsonpath.util.FieldGetterFinder;
import gsonpath.util.FileWriter;
import gsonpath.util.Logger;
import gsonpath.util.LoggerImpl;
import gsonpath.util.ProcessorTypeHandler;
import gsonpath.util.TypeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J \u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001c"}, d2={"Lgsonpath/GsonProcessorImpl;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "getAnnotatedModelElements", "", "Lgsonpath/GsonProcessorImpl$ElementAndAutoGson;", "env", "Ljavax/annotation/processing/RoundEnvironment;", "customAnnotations", "", "Ljavax/lang/model/element/TypeElement;", "getSupportedAnnotationTypes", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "loadExtensions", "Lgsonpath/compiler/GsonPathExtension;", "printError", "", "message", "element", "Ljavax/lang/model/element/Element;", "printMessage", "process", "", "annotations", "Companion", "ElementAndAutoGson", "standard"})
public class GsonProcessorImpl
extends AbstractProcessor {
    private static final String LOG_PREFIX = "Gson Path: ";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(@Nullable Set<? extends TypeElement> annotations, @NotNull RoundEnvironment env) {
        Collection $receiver$iv$iv;
        Collection $receiver$iv;
        void $receiver$iv$iv2;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        if (annotations == null) {
            return false;
        }
        List supportedAnnotations2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)annotations), (Function1)process.supportedAnnotations.1.INSTANCE), (Function1)process.supportedAnnotations.2.INSTANCE));
        Iterable iterable = annotations;
        void var6_5 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            TypeElement it = (TypeElement)element$iv$iv;
            if (!(it.getAnnotation(AutoGsonAdapter.class) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List customAnnotations = (List)destination$iv$iv;
        if (supportedAnnotations2.isEmpty() && customAnnotations.isEmpty()) {
            return false;
        }
        List<GsonPathExtension> list = this.loadExtensions();
        if (list == null) {
            return false;
        }
        List<GsonPathExtension> extensions = list;
        System.out.println();
        this.printMessage("Started annotation processing");
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        FileWriter fileWriter = new FileWriter(processingEnvironment);
        ProcessingEnvironment processingEnvironment2 = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment2, (String)"processingEnv");
        LoggerImpl logger = new LoggerImpl(processingEnvironment2);
        ProcessingEnvironment processingEnvironment3 = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment3, (String)"processingEnv");
        ProcessorTypeHandler typeHandler = new ProcessorTypeHandler(processingEnvironment3);
        ProcessingEnvironment processingEnvironment4 = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment4, (String)"processingEnv");
        DefaultValueDetectorImpl defaultValueDetector = new DefaultValueDetectorImpl(processingEnvironment4);
        FieldGetterFinder fieldGetterFinder = new FieldGetterFinder((TypeHandler)typeHandler);
        AnnotationFetcher annotationFetcher = new AnnotationFetcher((TypeHandler)typeHandler, fieldGetterFinder);
        GsonObjectFactory gsonObjectFactory = new GsonObjectFactory(new GsonObjectValidator(), new FieldPathFetcher(SerializedNameFetcher.INSTANCE, new FieldNamingPolicyMapper()), new SubTypeMetadataFactoryImpl((TypeHandler)typeHandler));
        GsonObjectTreeFactory gsonObjectTreeFactory = new GsonObjectTreeFactory(gsonObjectFactory);
        ReadFunctions readFunctions = new ReadFunctions();
        WriteFunctions writeFunctions = new WriteFunctions();
        SubtypeFunctions subtypeFunctions = new SubtypeFunctions();
        ModelInterfaceGenerator modelInterfaceGenerator = new ModelInterfaceGenerator(new InterfaceModelMetadataFactory((TypeHandler)typeHandler), fileWriter, (Logger)logger);
        AdapterModelMetadataFactory adapterModelMetadataFactory = new AdapterModelMetadataFactory(new FieldInfoFactory((TypeHandler)typeHandler, fieldGetterFinder, annotationFetcher, (DefaultValueDetector)defaultValueDetector), gsonObjectTreeFactory, (TypeHandler)typeHandler, modelInterfaceGenerator);
        AutoGsonAdapterGenerator adapterGenerator = new AutoGsonAdapterGenerator(adapterModelMetadataFactory, fileWriter, readFunctions, writeFunctions, subtypeFunctions, (Logger)logger);
        Iterable iterable2 = this.getAnnotatedModelElements(env, customAnnotations);
        void var22_21 = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            HandleResult handleResult;
            void $element_autoGsonAdapter;
            ElementAndAutoGson elementAndAutoGson = (ElementAndAutoGson)item$iv$iv;
            Collection collection = destination$iv$iv2;
            TypeElement element = $element_autoGsonAdapter.component1();
            AutoGsonAdapter autoGsonAdapter = $element_autoGsonAdapter.component2();
            this.printMessage("Generating TypeAdapter (" + element + ')');
            try {
                ProcessingEnvironment processingEnvironment5 = this.processingEnv;
                Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment5, (String)"processingEnv");
                handleResult = adapterGenerator.handle(element, autoGsonAdapter, new ExtensionsHandler(processingEnvironment5, extensions));
            }
            catch (ProcessingException e) {
                String string = e.getMessage();
                Element element2 = e.getElement();
                if (element2 == null) {
                    element2 = element;
                }
                this.printError(string, element2);
                return false;
            }
            HandleResult handleResult2 = handleResult;
            collection.add(handleResult2);
        }
        List autoGsonAdapterResults = (List)destination$iv$iv2;
        $receiver$iv = autoGsonAdapterResults;
        if (!$receiver$iv.isEmpty()) {
            Set<? extends Element> gsonPathFactories;
            Set<? extends Element> set = gsonPathFactories = env.getElementsAnnotatedWith(AutoGsonAdapterFactory.class);
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"gsonPathFactories");
            $receiver$iv$iv = set;
            if ($receiver$iv$iv.size() == 0) {
                this.printError("An interface annotated with @AutoGsonAdapterFactory (that directly extends com.google.gson.TypeAdapterFactory) must exist before the annotation processor can succeed. See the AutoGsonAdapterFactory annotation for further details.");
                return false;
            }
            $receiver$iv$iv = gsonPathFactories;
            if ($receiver$iv$iv.size() > 1) {
                this.printError("Only one interface annotated with @AutoGsonAdapterFactory can exist");
                return false;
            }
            Element factoryElement = (Element)CollectionsKt.first((Iterable)gsonPathFactories);
            try {
                Element element = factoryElement;
                if (element == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                if (!new TypeAdapterFactoryGenerator(fileWriter, (Logger)logger).generate((TypeElement)element, autoGsonAdapterResults)) {
                    this.printError("Error while generating TypeAdapterFactory", factoryElement);
                    return false;
                }
            }
            catch (ProcessingException e) {
                String string = e.getMessage();
                Element element = e.getElement();
                if (element == null) {
                    Element element3 = factoryElement;
                    element = element3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"factoryElement");
                }
                this.printError(string, element);
                return false;
            }
        }
        this.printMessage("Finished annotation processing");
        System.out.println();
        return false;
    }

    private final List<GsonPathExtension> loadExtensions() {
        List list;
        System.out.println();
        try {
            ServiceLoader<GsonPathExtension> serviceLoader = ServiceLoader.load(GsonPathExtension.class, this.getClass().getClassLoader());
            Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(GsonP\u2026a, javaClass.classLoader)");
            list = CollectionsKt.toList((Iterable)serviceLoader);
        }
        catch (Throwable t) {
            this.printError("Failed to load one or more GsonPath extensions. Cause: " + t.getMessage());
            return null;
        }
        List extensions = list;
        Iterable $receiver$iv = extensions;
        for (Object element$iv : $receiver$iv) {
            GsonPathExtension it = (GsonPathExtension)element$iv;
            this.printMessage("Extension found: " + it.getExtensionName());
        }
        return extensions;
    }

    private final void printMessage(String message) {
        String string = LOG_PREFIX + message;
        System.out.println((Object)string);
    }

    private final void printError(String message) {
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, LOG_PREFIX + message);
    }

    private final void printError(String message, Element element) {
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, LOG_PREFIX + message, element);
    }

    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"*"});
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet(\"*\")");
        return hashSet;
    }

    @Override
    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latestSupported();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceVersion), (String)"SourceVersion.latestSupported()");
        return sourceVersion;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ElementAndAutoGson> getAnnotatedModelElements(RoundEnvironment env, List<? extends TypeElement> customAnnotations) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Set<? extends Element> set = env.getElementsAnnotatedWith(AutoGsonAdapter.class);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"env\n                .get\u2026oGsonAdapter::class.java)");
        Iterable iterable = customAnnotations;
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)getAnnotatedModelElements.1.INSTANCE), (Function1)((Function1)new Function1<ElementAndAutoGson, Boolean>(customAnnotations){
            final /* synthetic */ List $customAnnotations;

            public final boolean invoke(@NotNull ElementAndAutoGson it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !this.$customAnnotations.contains(it.getElement());
            }
            {
                this.$customAnnotations = list;
                super(1);
            }
        }));
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            TypeElement customAnnotation = (TypeElement)element$iv$iv;
            Set<? extends Element> set2 = env.getElementsAnnotatedWith(customAnnotation);
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"env\n                    \u2026tedWith(customAnnotation)");
            Iterable iterable2 = set2;
            void var10_11 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                Element element = (Element)item$iv$iv;
                Collection collection = destination$iv$iv2;
                void v2 = it;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                TypeElement typeElement = (TypeElement)v2;
                AutoGsonAdapter autoGsonAdapter = customAnnotation.getAnnotation(AutoGsonAdapter.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)autoGsonAdapter, (String)"customAnnotation.getAnno\u2026oGsonAdapter::class.java)");
                ElementAndAutoGson elementAndAutoGson = new ElementAndAutoGson(typeElement, autoGsonAdapter);
                collection.add(elementAndAutoGson);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return SequencesKt.toSet((Sequence)SequencesKt.plus((Sequence)sequence, (Iterable)list));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lgsonpath/GsonProcessorImpl$ElementAndAutoGson;", "", "element", "Ljavax/lang/model/element/TypeElement;", "autoGsonAdapter", "Lgsonpath/AutoGsonAdapter;", "(Ljavax/lang/model/element/TypeElement;Lgsonpath/AutoGsonAdapter;)V", "getAutoGsonAdapter", "()Lgsonpath/AutoGsonAdapter;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "standard"})
    private static final class ElementAndAutoGson {
        @NotNull
        private final TypeElement element;
        @NotNull
        private final AutoGsonAdapter autoGsonAdapter;

        @NotNull
        public final TypeElement getElement() {
            return this.element;
        }

        @NotNull
        public final AutoGsonAdapter getAutoGsonAdapter() {
            return this.autoGsonAdapter;
        }

        public ElementAndAutoGson(@NotNull TypeElement element, @NotNull AutoGsonAdapter autoGsonAdapter) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)autoGsonAdapter, (String)"autoGsonAdapter");
            this.element = element;
            this.autoGsonAdapter = autoGsonAdapter;
        }

        @NotNull
        public final TypeElement component1() {
            return this.element;
        }

        @NotNull
        public final AutoGsonAdapter component2() {
            return this.autoGsonAdapter;
        }

        @NotNull
        public final ElementAndAutoGson copy(@NotNull TypeElement element, @NotNull AutoGsonAdapter autoGsonAdapter) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)autoGsonAdapter, (String)"autoGsonAdapter");
            return new ElementAndAutoGson(element, autoGsonAdapter);
        }

        @NotNull
        public static /* synthetic */ ElementAndAutoGson copy$default(ElementAndAutoGson elementAndAutoGson, TypeElement typeElement, AutoGsonAdapter autoGsonAdapter, int n, Object object) {
            if ((n & 1) != 0) {
                typeElement = elementAndAutoGson.element;
            }
            if ((n & 2) != 0) {
                autoGsonAdapter = elementAndAutoGson.autoGsonAdapter;
            }
            return elementAndAutoGson.copy(typeElement, autoGsonAdapter);
        }

        @NotNull
        public String toString() {
            return "ElementAndAutoGson(element=" + this.element + ", autoGsonAdapter=" + this.autoGsonAdapter + ")";
        }

        public int hashCode() {
            TypeElement typeElement = this.element;
            AutoGsonAdapter autoGsonAdapter = this.autoGsonAdapter;
            return (typeElement != null ? typeElement.hashCode() : 0) * 31 + (autoGsonAdapter != null ? autoGsonAdapter.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ElementAndAutoGson)) break block3;
                    ElementAndAutoGson elementAndAutoGson = (ElementAndAutoGson)object;
                    if (!Intrinsics.areEqual((Object)this.element, (Object)elementAndAutoGson.element) || !Intrinsics.areEqual((Object)this.autoGsonAdapter, (Object)elementAndAutoGson.autoGsonAdapter)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgsonpath/GsonProcessorImpl$Companion;", "", "()V", "LOG_PREFIX", "", "standard"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

