/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.generator.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import gsonpath.AutoGsonAdapter;
import gsonpath.FlattenJson;
import gsonpath.GsonPathDefaultConfiguration;
import gsonpath.GsonUtil;
import gsonpath.ProcessingException;
import gsonpath.generator.AdapterGeneratorUtils;
import gsonpath.generator.Generator;
import gsonpath.generator.HandleResult;
import gsonpath.generator.adapter.AutoGsonAdapterProperties;
import gsonpath.generator.adapter.AutoGsonAdapterPropertiesFactory;
import gsonpath.generator.adapter.ModelInterfaceGenerator;
import gsonpath.model.FieldInfo;
import gsonpath.model.FieldInfoFactory;
import gsonpath.model.GsonField;
import gsonpath.model.GsonObject;
import gsonpath.model.GsonObjectTreeFactory;
import gsonpath.model.InterfaceInfo;
import gsonpath.model.MandatoryFieldInfo;
import gsonpath.model.MandatoryFieldInfoFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0003JR\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010$\u001a\u00020\u0011H\u0003J4\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010(\u001a\u00020\u0018H\u0003J \u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u001aH\u0003J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0003J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J4\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0003J\u0010\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0002J0\u0010<\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001aH\u0003R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000b0\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lgsonpath/generator/adapter/AutoGsonAdapterGenerator;", "Lgsonpath/generator/Generator;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "CLASS_NAME_JSON_ELEMENT", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "CLASS_NAME_STRING", "GSON_SUPPORTED_CLASSES", "", "Lcom/squareup/javapoet/TypeName;", "GSON_SUPPORTED_PRIMITIVE", "Ljava/util/HashSet;", "adapterGeneratorUtils", "Lgsonpath/generator/AdapterGeneratorUtils;", "mCounterVariableCount", "", "mSafeWriteVariableCount", "addGsonAdapterReadCode", "", "codeBlock", "Lcom/squareup/javapoet/CodeBlock$Builder;", "jsonMapping", "Lgsonpath/model/GsonObject;", "createModelAtBeginning", "", "mandatoryInfoMap", "", "", "Lgsonpath/model/MandatoryFieldInfo;", "concreteElement", "flattenedFields", "", "Lgsonpath/model/GsonField;", "addGsonAdapterReadCodeInternal", "fieldDepth", "createReadMethod", "Lcom/squareup/javapoet/MethodSpec;", "baseElement", "rootElements", "createWriteMethod", "elementClassName", "serializeNulls", "getDefaultsAnnotation", "Lgsonpath/GsonPathDefaultConfiguration;", "autoGsonAnnotation", "Lgsonpath/AutoGsonAdapter;", "handle", "Lgsonpath/generator/HandleResult;", "modelElement", "Ljavax/lang/model/element/TypeElement;", "handleGsonField", "gsonField", "onJavaFileBuilt", "builder", "Lcom/squareup/javapoet/JavaFile$Builder;", "validateFieldAnnotations", "fieldInfo", "Lgsonpath/model/FieldInfo;", "writeObject", "currentPath", "gsonpath-compiler_main"})
public final class AutoGsonAdapterGenerator
extends Generator {
    private final HashSet<TypeName> GSON_SUPPORTED_PRIMITIVE;
    private final Set<TypeName> GSON_SUPPORTED_CLASSES;
    private final ClassName CLASS_NAME_STRING;
    private final ClassName CLASS_NAME_JSON_ELEMENT;
    private final AdapterGeneratorUtils adapterGeneratorUtils;
    private int mSafeWriteVariableCount;
    private int mCounterVariableCount;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HandleResult handle(@NotNull TypeElement modelElement) throws ProcessingException {
        List<FieldInfo> fieldInfoList;
        ClassName concreteClassName;
        Intrinsics.checkParameterIsNotNull((Object)modelElement, (String)"modelElement");
        ClassName modelClassName = ClassName.get((TypeElement)modelElement);
        String string = modelClassName.packageName();
        ClassName className = modelClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"modelClassName");
        ClassName adapterClassName = ClassName.get((String)string, (String)this.adapterGeneratorUtils.generateClassName(className, "GsonTypeAdapter"), (String[])new String[0]);
        TypeSpec.Builder adapterTypeBuilder = TypeSpec.classBuilder((ClassName)adapterClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeAdapter.class), (TypeName[])new TypeName[]{(TypeName)modelClassName})).addField((Type)((Object)Gson.class), "mGson", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        adapterTypeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((Type)((Object)Gson.class), "gson", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"mGson", "gson"}).build());
        AutoGsonAdapter autoGsonAnnotation = modelElement.getAnnotation(AutoGsonAdapter.class);
        boolean isModelInterface = modelElement.getKind().isInterface();
        AutoGsonAdapterPropertiesFactory autoGsonAdapterPropertiesFactory = new AutoGsonAdapterPropertiesFactory();
        AutoGsonAdapter autoGsonAdapter = autoGsonAnnotation;
        Intrinsics.checkExpressionValueIsNotNull((Object)autoGsonAdapter, (String)"autoGsonAnnotation");
        AutoGsonAdapter autoGsonAdapter2 = autoGsonAnnotation;
        Intrinsics.checkExpressionValueIsNotNull((Object)autoGsonAdapter2, (String)"autoGsonAnnotation");
        AutoGsonAdapterProperties properties = autoGsonAdapterPropertiesFactory.create(autoGsonAdapter, this.getDefaultsAnnotation(autoGsonAdapter2), isModelInterface);
        FieldInfoFactory fieldInfoFactory = new FieldInfoFactory(this.getProcessingEnv());
        if (!isModelInterface) {
            ClassName className2 = modelClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className2, (String)"modelClassName");
            concreteClassName = className2;
            fieldInfoList = fieldInfoFactory.getModelFieldsFromElement(modelElement, properties.getFieldsRequireAnnotation());
        } else {
            InterfaceInfo interfaceInfo = new ModelInterfaceGenerator(this.getProcessingEnv()).handle(modelElement);
            concreteClassName = interfaceInfo.getParentClassName();
            fieldInfoList = fieldInfoFactory.getModelFieldsFromInterface(interfaceInfo);
        }
        GsonObject rootGsonObject = new GsonObjectTreeFactory().createGsonObject(fieldInfoList, properties.getRootField(), properties.getFlattenDelimiter(), properties.getGsonFieldNamingPolicy(), properties.getGsonFieldValidationType(), properties.getPathSubstitutions());
        Map<String, MandatoryFieldInfo> mandatoryInfoMap = new MandatoryFieldInfoFactory().createMandatoryFieldsFromGsonObject(rootGsonObject);
        Object object = mandatoryInfoMap;
        if (!object.isEmpty()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            object = mandatoryInfoMap.values();
            Iterator iterator = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void mandatoryIndex;
                void mandatoryField;
                int n = index$iv$iv++;
                MandatoryFieldInfo mandatoryFieldInfo = (MandatoryFieldInfo)item$iv$iv;
                int n2 = n;
                void var24_22 = destination$iv$iv;
                FieldSpec fieldSpec = FieldSpec.builder((TypeName)TypeName.INT, (String)mandatoryField.getIndexVariableName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("" + (int)mandatoryIndex, new Object[0]).build();
                var24_22.add(fieldSpec);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                FieldSpec it = (FieldSpec)element$iv;
                adapterTypeBuilder.addField(it);
            }
            adapterTypeBuilder.addField(FieldSpec.builder((TypeName)TypeName.INT, (String)"MANDATORY_FIELDS_SIZE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("" + mandatoryInfoMap.size(), new Object[0]).build());
        }
        ClassName className3 = modelClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)className3, (String)"modelClassName");
        adapterTypeBuilder.addMethod(this.createReadMethod(className3, concreteClassName, mandatoryInfoMap, rootGsonObject));
        if (!isModelInterface) {
            ClassName className4 = modelClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className4, (String)"modelClassName");
            adapterTypeBuilder.addMethod(this.createWriteMethod(className4, rootGsonObject, properties.getSerializeNulls()));
        } else {
            MethodSpec.Builder writeMethod = MethodSpec.methodBuilder((String)"write").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((Type)((Object)JsonWriter.class), "out", new Modifier[0]).addParameter((TypeName)modelClassName, "value", new Modifier[0]).addException((Type)((Object)IOException.class));
            adapterTypeBuilder.addMethod(writeMethod.build());
        }
        String string2 = adapterClassName.packageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"adapterClassName.packageName()");
        TypeSpec.Builder builder = adapterTypeBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"adapterTypeBuilder");
        if (this.writeFile(string2, builder)) {
            ClassName className5 = modelClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className5, (String)"modelClassName");
            ClassName className6 = adapterClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className6, (String)"adapterClassName");
            return new HandleResult(className5, className6);
        }
        throw (Throwable)new ProcessingException("Failed to write generated file: " + adapterClassName.simpleName(), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final MethodSpec createReadMethod(ClassName baseElement, ClassName concreteElement, Map<String, MandatoryFieldInfo> mandatoryInfoMap, GsonObject rootElements) throws ProcessingException {
        List<GsonField> flattenedFields = new GsonObjectTreeFactory().getFlattenedFieldsFromGsonObject(rootElements);
        MethodSpec.Builder readMethod = MethodSpec.methodBuilder((String)"read").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)baseElement).addParameter((Type)((Object)JsonReader.class), "in", new Modifier[0]).addException((Type)((Object)IOException.class));
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        boolean createModelAtBeginning = Intrinsics.areEqual((Object)baseElement, (Object)concreteElement);
        CodeBlock.Builder builder = codeBlock;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"codeBlock");
        this.addGsonAdapterReadCode(builder, rootElements, createModelAtBeginning, mandatoryInfoMap, concreteElement, flattenedFields);
        Object object = mandatoryInfoMap;
        if (!object.isEmpty()) {
            codeBlock.add("\n// Mandatory object validation\n", new Object[0]);
            codeBlock.beginControlFlow("for (int mandatoryFieldIndex = 0; mandatoryFieldIndex < MANDATORY_FIELDS_SIZE; mandatoryFieldIndex++)", new Object[0]);
            codeBlock.add("\n// Check if a mandatory value is missing.\n", new Object[0]);
            codeBlock.beginControlFlow("if (!mandatoryFieldsCheckList[mandatoryFieldIndex])", new Object[0]);
            codeBlock.add("\n// Find the field name of the missing json value.\n", new Object[0]);
            codeBlock.addStatement("String fieldName = null", new Object[0]);
            codeBlock.beginControlFlow("switch (mandatoryFieldIndex)", new Object[0]);
            Map<String, MandatoryFieldInfo> map2 = mandatoryInfoMap;
            Iterator<Map.Entry<String, MandatoryFieldInfo>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                String key = (String)object2.getKey();
                Object object3 = object;
                MandatoryFieldInfo mandatoryFieldInfo = (MandatoryFieldInfo)object3.getValue();
                codeBlock.add("case $L:\n", new Object[]{mandatoryFieldInfo.getIndexVariableName()});
                codeBlock.indent();
                codeBlock.addStatement("fieldName = \"$L\"", new Object[]{mandatoryFieldInfo.getGsonField().getJsonPath()});
                codeBlock.addStatement("break", new Object[0]);
                codeBlock.unindent();
                codeBlock.add("\n", new Object[0]);
            }
            codeBlock.endControlFlow();
            codeBlock.addStatement("throw new gsonpath.JsonFieldMissingException(\"Mandatory JSON element '\" + fieldName + \"' was not found for class '$L'\")", new Object[]{concreteElement});
            codeBlock.endControlFlow();
            codeBlock.endControlFlow();
        }
        if (createModelAtBeginning) {
            codeBlock.addStatement("return result", new Object[0]);
        } else {
            CodeBlock.Builder returnCodeBlock = CodeBlock.builder();
            returnCodeBlock.add("return new $T(\n", new Object[]{concreteElement});
            returnCodeBlock.indent();
            int n = 0;
            int n2 = ((Collection)flattenedFields).size() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    returnCodeBlock.add(flattenedFields.get((int)i).getVariableName(), new Object[0]);
                    if (i < flattenedFields.size() - 1) {
                        returnCodeBlock.add(",", new Object[0]);
                    }
                    returnCodeBlock.add("\n", new Object[0]);
                    if (i == n2) break;
                    ++i;
                }
            }
            returnCodeBlock.unindent();
            returnCodeBlock.add(");\n", new Object[0]);
            codeBlock.add(returnCodeBlock.build());
        }
        readMethod.addCode(codeBlock.build());
        MethodSpec methodSpec = readMethod.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"readMethod.build()");
        return methodSpec;
    }

    private final MethodSpec createWriteMethod(ClassName elementClassName, GsonObject rootElements, boolean serializeNulls) throws ProcessingException {
        MethodSpec.Builder writeMethod = MethodSpec.methodBuilder((String)"write").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((Type)((Object)JsonWriter.class), "out", new Modifier[0]).addParameter((TypeName)elementClassName, "value", new Modifier[0]).addException((Type)((Object)IOException.class));
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if (value == null)", new Object[0]);
        codeBlock.addStatement("out.nullValue()", new Object[0]);
        codeBlock.addStatement("return", new Object[0]);
        codeBlock.endControlFlow();
        codeBlock.add("\n", new Object[0]);
        codeBlock.add("// Begin\n", new Object[0]);
        this.mSafeWriteVariableCount = 0;
        CodeBlock.Builder builder = codeBlock;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"codeBlock");
        this.writeObject(0, builder, rootElements, "", serializeNulls);
        writeMethod.addCode(codeBlock.build());
        MethodSpec methodSpec = writeMethod.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"writeMethod.build()");
        return methodSpec;
    }

    private final void writeObject(int fieldDepth, CodeBlock.Builder codeBlock, GsonObject jsonMapping, String currentPath, boolean serializeNulls) throws ProcessingException {
        codeBlock.addStatement("out.beginObject()", new Object[0]);
        for (String key : jsonMapping.keySet()) {
            Object value = jsonMapping.get(key);
            if (value instanceof GsonField) {
                FieldInfo fieldInfo2 = ((GsonField)value).getFieldInfo();
                this.validateFieldAnnotations(fieldInfo2);
                TypeName fieldTypeName = fieldInfo2.getTypeName();
                boolean isPrimitive = fieldTypeName.isPrimitive();
                String objectName = "obj" + this.mSafeWriteVariableCount;
                int n = this.mSafeWriteVariableCount;
                this.mSafeWriteVariableCount = n + 1;
                codeBlock.addStatement("$T $L = value.$L", new Object[]{fieldTypeName, objectName, fieldInfo2.getFieldName()});
                if (!isPrimitive && !serializeNulls) {
                    codeBlock.beginControlFlow("if ($L != null)", new Object[]{objectName});
                }
                codeBlock.addStatement("out.name(\"$L\")", new Object[]{key});
                if (!isPrimitive && serializeNulls) {
                    codeBlock.beginControlFlow("if ($L != null)", new Object[]{objectName});
                }
                if (isPrimitive || this.GSON_SUPPORTED_CLASSES.contains(fieldTypeName)) {
                    codeBlock.addStatement("out.value($L)", new Object[]{objectName});
                } else {
                    String adapterName;
                    if (fieldTypeName instanceof ParameterizedTypeName) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "new com.google.gson.reflect.TypeToken<%s>(){}";
                        Object[] objectArray = new Object[]{fieldTypeName};
                        Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    } else {
                        adapterName = fieldTypeName.toString() + ".class";
                    }
                    codeBlock.addStatement("mGson.getAdapter($L).write(out, $L)", new Object[]{adapterName, objectName});
                }
                if (!isPrimitive) {
                    if (serializeNulls) {
                        codeBlock.nextControlFlow("else", new Object[0]);
                        codeBlock.addStatement("out.nullValue()", new Object[0]);
                    }
                    codeBlock.endControlFlow();
                }
                codeBlock.add("\n", new Object[0]);
                continue;
            }
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type gsonpath.model.GsonObject");
            }
            GsonObject nextLevelMap = (GsonObject)object;
            if (nextLevelMap.size() <= 0) continue;
            CharSequence charSequence = currentPath;
            String newPath = charSequence.length() > 0 ? currentPath + "." + key : key;
            codeBlock.add("\n// Begin $L\n", new Object[]{newPath});
            codeBlock.addStatement("out.name(\"$L\")", new Object[]{key});
            this.writeObject(fieldDepth + 1, codeBlock, nextLevelMap, newPath, serializeNulls);
        }
        codeBlock.add("// End $L\n", new Object[]{currentPath});
        codeBlock.addStatement("out.endObject()", new Object[0]);
    }

    @Override
    public void onJavaFileBuilt(@NotNull JavaFile.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.addStaticImport(GsonUtil.class, new String[]{"*"});
    }

    private final GsonPathDefaultConfiguration getDefaultsAnnotation(AutoGsonAdapter autoGsonAnnotation) throws ProcessingException {
        TypeMirror defaultsTypeMirror = null;
        try {
            autoGsonAnnotation.defaultConfiguration();
        }
        catch (MirroredTypeException mte) {
            defaultsTypeMirror = mte.getTypeMirror();
        }
        Element defaultsElement = this.getProcessingEnv().getTypeUtils().asElement(defaultsTypeMirror);
        GsonPathDefaultConfiguration defaultsAnnotation = null;
        if (defaultsElement != null && (defaultsAnnotation = defaultsElement.getAnnotation(GsonPathDefaultConfiguration.class)) == null) {
            throw (Throwable)new ProcessingException("Defaults property must point to a class which uses the @GsonPathDefaultConfiguration annotation", null, 2, null);
        }
        return defaultsAnnotation;
    }

    private final void addGsonAdapterReadCode(CodeBlock.Builder codeBlock, GsonObject jsonMapping, boolean createModelAtBeginning, Map<String, MandatoryFieldInfo> mandatoryInfoMap, ClassName concreteElement, List<GsonField> flattenedFields) throws ProcessingException {
        this.mCounterVariableCount = 0;
        this.addGsonAdapterReadCodeInternal(codeBlock, jsonMapping, createModelAtBeginning, mandatoryInfoMap, concreteElement, flattenedFields, 0);
    }

    private final void addGsonAdapterReadCodeInternal(CodeBlock.Builder codeBlock, GsonObject jsonMapping, boolean createModelAtBeginning, Map<String, MandatoryFieldInfo> mandatoryInfoMap, ClassName concreteElement, List<GsonField> flattenedFields, int fieldDepth) throws ProcessingException {
        boolean isDirectAccess;
        Object value;
        String counterVariableName = "jsonFieldCounter" + this.mCounterVariableCount;
        int n = this.mCounterVariableCount;
        this.mCounterVariableCount = n + 1;
        codeBlock.add("\n", new Object[0]);
        codeBlock.add("// Ensure the object is not null.\n", new Object[0]);
        codeBlock.beginControlFlow("if (!isValidValue(in))", new Object[0]);
        if (fieldDepth == 0) {
            codeBlock.addStatement("return null", new Object[0]);
        } else {
            codeBlock.addStatement("break", new Object[0]);
        }
        codeBlock.endControlFlow();
        if (fieldDepth == 0) {
            if (createModelAtBeginning) {
                codeBlock.addStatement("$T result = new $T()", new Object[]{concreteElement, concreteElement});
            } else {
                for (GsonField gsonField : flattenedFields) {
                    String string;
                    TypeName typeName = gsonField.getFieldInfo().getTypeName();
                    String defaultValue = this.adapterGeneratorUtils.createDefaultVariableValueForTypeName(typeName);
                    String string2 = "%s %s = %s";
                    Object[] objectArray = new Object[]{typeName, gsonField.getVariableName(), defaultValue};
                    CodeBlock.Builder builder = codeBlock;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                    builder.addStatement(string, new Object[]{typeName, gsonField.getVariableName()});
                }
            }
            Map<String, MandatoryFieldInfo> gsonField = mandatoryInfoMap;
            if (!gsonField.isEmpty()) {
                codeBlock.addStatement("boolean[] mandatoryFieldsCheckList = new boolean[MANDATORY_FIELDS_SIZE]", new Object[0]);
            }
            codeBlock.add("\n", new Object[0]);
        }
        if (jsonMapping.size() == 0) {
            return;
        }
        if (jsonMapping.size() == 1 && (value = jsonMapping.get(jsonMapping.keySet().iterator().next())) instanceof GsonField && (isDirectAccess = ((GsonField)value).getFieldInfo().isDirectAccess())) {
            this.handleGsonField((GsonField)value, codeBlock, createModelAtBeginning, mandatoryInfoMap);
            return;
        }
        codeBlock.addStatement("int $L = 0", new Object[]{counterVariableName});
        codeBlock.addStatement("in.beginObject()", new Object[0]);
        codeBlock.add("\n", new Object[0]);
        codeBlock.beginControlFlow("while (in.hasNext())", new Object[0]);
        codeBlock.beginControlFlow("if ($L == $L)", new Object[]{counterVariableName, jsonMapping.size()});
        codeBlock.addStatement("in.skipValue()", new Object[0]);
        codeBlock.addStatement("continue", new Object[0]);
        codeBlock.endControlFlow();
        codeBlock.add("\n", new Object[0]);
        codeBlock.beginControlFlow("switch (in.nextName())", new Object[0]);
        boolean addBreak = true;
        for (String key : jsonMapping.keySet()) {
            codeBlock.add("case \"$L\":\n", new Object[]{key});
            codeBlock.indent();
            codeBlock.addStatement("$L++", new Object[]{counterVariableName});
            Object value2 = jsonMapping.get(key);
            if (value2 instanceof GsonField) {
                this.handleGsonField((GsonField)value2, codeBlock, createModelAtBeginning, mandatoryInfoMap);
            } else {
                Object object = value2;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type gsonpath.model.GsonObject");
                }
                GsonObject nextLevelMap = (GsonObject)object;
                if (nextLevelMap.size() == 0) {
                    addBreak = false;
                } else {
                    this.addGsonAdapterReadCodeInternal(codeBlock, nextLevelMap, createModelAtBeginning, mandatoryInfoMap, concreteElement, flattenedFields, fieldDepth + 1);
                }
            }
            if (addBreak) {
                codeBlock.addStatement("break", new Object[0]);
            }
            codeBlock.add("\n", new Object[0]);
            codeBlock.unindent();
        }
        codeBlock.add("default:\n", new Object[0]);
        codeBlock.indent();
        codeBlock.addStatement("in.skipValue()", new Object[0]);
        codeBlock.addStatement("break", new Object[0]);
        codeBlock.unindent();
        codeBlock.endControlFlow();
        codeBlock.endControlFlow();
        codeBlock.add("\n", new Object[0]);
        codeBlock.add("\n", new Object[0]);
        codeBlock.addStatement("in.endObject()", new Object[0]);
    }

    private final void handleGsonField(GsonField gsonField, CodeBlock.Builder codeBlock, boolean createModelAtBeginning, Map<String, MandatoryFieldInfo> mandatoryInfoMap) throws ProcessingException {
        String variableAssignment;
        String variableName;
        FieldInfo fieldInfo2 = gsonField.getFieldInfo();
        this.validateFieldAnnotations(fieldInfo2);
        TypeName fieldTypeName = fieldInfo2.getTypeName();
        codeBlock.add("\n", new Object[0]);
        String safeVariableName = variableName = gsonField.getVariableName();
        boolean checkIfResultIsNull = createModelAtBeginning;
        if (gsonField.isRequired() && !createModelAtBeginning) {
            safeVariableName = safeVariableName + "_safe";
            checkIfResultIsNull = true;
        }
        boolean callToString = false;
        if (fieldTypeName.isPrimitive() && !this.GSON_SUPPORTED_PRIMITIVE.contains(fieldTypeName)) {
            throw (Throwable)new ProcessingException("Unsupported primitive type found. Only boolean, int, double and long can be used.", fieldInfo2.getElement());
        }
        if (this.GSON_SUPPORTED_CLASSES.contains(fieldTypeName.box())) {
            FlattenJson annotation;
            TypeName typeName = fieldTypeName.box();
            if (typeName == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            ClassName fieldClassName = (ClassName)typeName;
            boolean handled = false;
            if (Intrinsics.areEqual((Object)fieldTypeName, (Object)this.CLASS_NAME_STRING) && (annotation = fieldInfo2.getAnnotation(FlattenJson.class)) != null) {
                handled = true;
                if (!checkIfResultIsNull) {
                    safeVariableName = safeVariableName + "_safe";
                    checkIfResultIsNull = true;
                }
                codeBlock.addStatement("$T $L = mGson.getAdapter($T.class).read(in)", new Object[]{this.CLASS_NAME_JSON_ELEMENT, safeVariableName, this.CLASS_NAME_JSON_ELEMENT});
                callToString = true;
            }
            if (!handled) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%s = get%sSafely(in)";
                Object[] objectArray = new Object[]{safeVariableName, fieldClassName.simpleName()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                variableAssignment = string2;
                if (checkIfResultIsNull) {
                    codeBlock.addStatement("$L $L", new Object[]{fieldClassName.simpleName(), variableAssignment});
                } else {
                    codeBlock.addStatement(variableAssignment, new Object[0]);
                }
            }
        } else {
            String adapterName;
            Object object;
            if (fieldTypeName instanceof ParameterizedTypeName) {
                StringCompanionObject handled = StringCompanionObject.INSTANCE;
                variableAssignment = "new com.google.gson.reflect.TypeToken<%s>(){}";
                object = new Object[]{fieldTypeName};
                String string = String.format(variableAssignment, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                adapterName = string;
            } else {
                adapterName = fieldTypeName.toString() + ".class";
            }
            variableAssignment = StringCompanionObject.INSTANCE;
            object = "%s = mGson.getAdapter(%s).read(in)";
            Object[] objectArray = new Object[]{safeVariableName, adapterName};
            String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String variableAssignment2 = string;
            if (checkIfResultIsNull) {
                codeBlock.addStatement("$L $L", new Object[]{fieldTypeName, variableAssignment2});
            } else {
                codeBlock.addStatement(variableAssignment2, new Object[0]);
            }
        }
        if (checkIfResultIsNull) {
            String fieldName = fieldInfo2.getFieldName();
            codeBlock.beginControlFlow("if ($L != null)", new Object[]{safeVariableName});
            String assignmentBlock = createModelAtBeginning ? "result." + fieldName : variableName;
            codeBlock.addStatement("$L = $L$L", new Object[]{assignmentBlock, safeVariableName, callToString ? ".toString()" : ""});
            MandatoryFieldInfo mandatoryFieldInfo = mandatoryInfoMap.get(fieldName);
            if (mandatoryFieldInfo != null) {
                codeBlock.addStatement("mandatoryFieldsCheckList[$L] = true", new Object[]{mandatoryFieldInfo.getIndexVariableName()});
                codeBlock.add("\n", new Object[0]);
            }
            if (gsonField.isRequired()) {
                codeBlock.nextControlFlow("else", new Object[0]);
                codeBlock.addStatement("throw new gsonpath.JsonFieldMissingException(\"Mandatory JSON element '$L' was null for class '$L'\")", new Object[]{gsonField.getJsonPath(), fieldInfo2.getParentClassName()});
            }
            codeBlock.endControlFlow();
        }
    }

    private final void validateFieldAnnotations(FieldInfo fieldInfo2) {
        if (fieldInfo2.getAnnotation(FlattenJson.class) == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)fieldInfo2.getTypeName(), (Object)this.CLASS_NAME_STRING) ^ true) {
            throw (Throwable)new ProcessingException("FlattenObject can only be used on String variables", fieldInfo2.getElement());
        }
    }

    public AutoGsonAdapterGenerator(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
        super(processingEnv);
        this.GSON_SUPPORTED_PRIMITIVE = new HashSet(Arrays.asList(TypeName.BOOLEAN, TypeName.INT, TypeName.LONG, TypeName.DOUBLE));
        this.GSON_SUPPORTED_CLASSES = new HashSet(Arrays.asList(TypeName.get((Type)Boolean.TYPE).box(), TypeName.get((Type)Integer.TYPE).box(), TypeName.get((Type)Long.TYPE).box(), TypeName.get((Type)Double.TYPE).box(), TypeName.get((Type)((Type)((Object)String.class))).box()));
        this.CLASS_NAME_STRING = ClassName.get(String.class);
        this.CLASS_NAME_JSON_ELEMENT = ClassName.get(JsonElement.class);
        this.adapterGeneratorUtils = new AdapterGeneratorUtils();
    }
}

