/*
 * Decompiled with CFR 0.152.
 */
package gsonpath;

import gsonpath.AutoGsonAdapter;
import gsonpath.ProcessingException;
import gsonpath.generator.HandleResult;
import gsonpath.generator.adapter.AutoGsonAdapterGenerator;
import gsonpath.generator.adapter.TypeAdapterLoaderGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J \u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lgsonpath/GsonProcessorImpl;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "getSupportedAnnotationTypes", "", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "printError", "", "message", "element", "Ljavax/lang/model/element/Element;", "printMessage", "process", "", "annotations", "Ljavax/lang/model/element/TypeElement;", "env", "Ljavax/annotation/processing/RoundEnvironment;", "Companion", "gsonpath-compiler_main"})
public class GsonProcessorImpl
extends AbstractProcessor {
    private static final String LOG_PREFIX = "Gson Path: ";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean process(@Nullable Set<? extends TypeElement> annotations, @NotNull RoundEnvironment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        System.out.println();
        this.printMessage("Started annotation processing");
        Set<? extends Element> generatedAdapters = env.getElementsAnnotatedWith(AutoGsonAdapter.class);
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        AutoGsonAdapterGenerator adapterGenerator = new AutoGsonAdapterGenerator(processingEnvironment);
        ArrayList<HandleResult> autoGsonAdapterResults = new ArrayList<HandleResult>();
        for (Element collection : generatedAdapters) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "Generating TypeAdapter (%s)";
            Object[] objectArray = new Object[]{collection};
            GsonProcessorImpl gsonProcessorImpl = this;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            gsonProcessorImpl.printMessage(string);
            try {
                Element element = collection;
                if (element == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                autoGsonAdapterResults.add(adapterGenerator.handle((TypeElement)element));
            }
            catch (ProcessingException e) {
                String string3 = e.getMessage();
                Element element = e.getElement();
                if (element == null) {
                    Element element2 = collection;
                    element = element2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
                }
                this.printError(string3, element);
                return false;
            }
        }
        Collection collection = autoGsonAdapterResults;
        if (!collection.isEmpty()) {
            ProcessingEnvironment processingEnvironment2 = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment2, (String)"processingEnv");
            if (!new TypeAdapterLoaderGenerator(processingEnvironment2).generate((List<HandleResult>)autoGsonAdapterResults)) {
                this.printError("Error while generating TypeAdapterFactory");
                return false;
            }
        }
        this.printMessage("Finished annotation processing");
        System.out.println();
        return false;
    }

    private final void printMessage(String message) {
        String string = GsonProcessorImpl.Companion.getLOG_PREFIX() + message;
        System.out.println((Object)string);
    }

    private final void printError(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, GsonProcessorImpl.Companion.getLOG_PREFIX() + message);
    }

    private final void printError(String message, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, GsonProcessorImpl.Companion.getLOG_PREFIX() + message, element);
    }

    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> supportedTypes = new LinkedHashSet<String>();
        supportedTypes.add(AutoGsonAdapter.class.getCanonicalName());
        return supportedTypes;
    }

    @Override
    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latestSupported();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceVersion), (String)"SourceVersion.latestSupported()");
        return sourceVersion;
    }

    static {
        LOG_PREFIX = LOG_PREFIX;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgsonpath/GsonProcessorImpl$Companion;", "", "()V", "LOG_PREFIX", "", "getLOG_PREFIX", "()Ljava/lang/String;", "gsonpath-compiler_main"})
    public static final class Companion {
        private final String getLOG_PREFIX() {
            return LOG_PREFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

