/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.kyori.mammoth.test.GradleFunctionalTest;
import net.kyori.mammoth.test.GradleParameters;
import net.kyori.mammoth.test.TemplateInvocationExtensions;
import net.kyori.mammoth.test.TestContext;
import net.kyori.mammoth.test.TestVariant;
import net.kyori.mammoth.test.TestVariantResource;
import org.gradle.util.GradleVersion;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;

@NullMarked
class GradleFunctionalTestExtension
implements TestTemplateInvocationContextProvider {
    private static final int CURRENT_JVM;

    GradleFunctionalTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        Optional method = context.getTestMethod();
        if (!method.isPresent()) {
            return false;
        }
        return AnnotationSupport.isAnnotated((Optional)method, GradleFunctionalTest.class);
    }

    private static boolean permitsJavaVersion(int minVersion, int maxVersion) {
        if (maxVersion < minVersion) {
            throw new IllegalArgumentException("Maximum runtime version provided (" + maxVersion + ") is less than minimum version (" + minVersion + ")");
        }
        return CURRENT_JVM >= minVersion && CURRENT_JVM <= maxVersion;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Optional parameters = AnnotationSupport.findAnnotation((Optional)context.getElement(), GradleParameters.class);
        List variants = AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), TestVariant.class);
        List variantSources = AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), TestVariantResource.class);
        String[] commonArgs = parameters.map(GradleParameters::value).orElse(new String[0]);
        if (variants.isEmpty() && variantSources.isEmpty()) {
            return Stream.of(this.produce(context, commonArgs, "", new String[0]));
        }
        Stream<TestTemplateInvocationContext> directVariants = variants.stream().filter(variant -> GradleFunctionalTestExtension.permitsJavaVersion(variant.minimumRuntimeVersion(), variant.maximumRuntimeVersion())).map(variant -> this.produce(context, commonArgs, variant.gradleVersion(), variant.extraArguments()));
        Stream<TestTemplateInvocationContext> resourceVariants = variantSources.stream().filter(variantRes -> GradleFunctionalTestExtension.permitsJavaVersion(variantRes.minimumRuntimeVersion(), variantRes.maximumRuntimeVersion())).flatMap(source -> this.readLines(source.value(), context.getRequiredTestClass().getResource(source.value()), source.optional())).filter(arr -> ((String[])arr).length > 0).map(line -> this.produce(context, commonArgs, line[0], ((String[])line).length > 1 ? line[1].split(" ", -1) : new String[]{}));
        return Stream.concat(directVariants, resourceVariants);
    }

    private Stream<String[]> readLines(String name, @Nullable URL uri, boolean optional) {
        InputStreamReader reader;
        if (uri == null) {
            if (optional) {
                return Stream.empty();
            }
            throw new IllegalArgumentException("Unable to find resource '" + name + "'");
        }
        try {
            reader = new InputStreamReader(uri.openStream(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        BufferedReader buf = new BufferedReader(reader);
        return (Stream)buf.lines().filter(l -> !l.isEmpty()).map(s -> s.split(":", -1)).onClose(() -> {
            try {
                buf.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private TestTemplateInvocationContext produce(ExtensionContext context, String[] commonArgs, String gradleVersion, String ... extraArguments) {
        Path tempDirectory;
        final List<String> extraArgs = GradleFunctionalTestExtension.processArgs(commonArgs, extraArguments);
        try {
            tempDirectory = Files.createTempDirectory(context.getRequiredTestClass().getSimpleName(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final TestContext testContext = new TestContext(context.getRequiredTestClass(), context.getDisplayName(), tempDirectory, gradleVersion.isEmpty() ? GradleVersion.current().getVersion() : gradleVersion, extraArgs);
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return "gradle " + testContext.gradleVersion() + ", args=" + extraArgs;
            }

            public List<Extension> getAdditionalExtensions() {
                return Collections.singletonList(new TemplateInvocationExtensions(testContext));
            }
        };
    }

    private static List<String> processArgs(String[] common, String[] extra) {
        ArrayList<String> ret = new ArrayList<String>(common.length + extra.length);
        Collections.addAll(ret, common);
        Collections.addAll(ret, extra);
        return ret;
    }

    static {
        String versionProp = System.getProperty("java.version");
        if (versionProp == null) {
            throw new IllegalStateException("System property 'java.version' has not been set???");
        }
        String[] versionComps = versionProp.split("\\.", -1);
        if (versionComps.length < 1) {
            throw new IllegalStateException("Empty version components in property value '" + versionProp + "'");
        }
        String toParse = versionComps[0];
        if ("1".equals(toParse)) {
            toParse = versionComps[1];
        }
        try {
            CURRENT_JVM = Integer.parseInt(toParse);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid JVM version component '" + toParse + "' in version property '" + versionProp + "'", ex);
        }
    }
}

