/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util;

import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultFutureResult;

public class CountingCompletionHandler<T>
implements Handler<AsyncResult<T>> {
    private int count;
    private int required;
    private Handler<AsyncResult<T>> doneHandler;
    private Throwable cause;
    private boolean failed;

    public CountingCompletionHandler(int required) {
        this.required = required;
    }

    public void handle(AsyncResult<T> result) {
        if (result.failed()) {
            this.fail(result.cause());
        } else {
            this.succeed();
        }
    }

    public void succeed() {
        ++this.count;
        this.checkDone();
    }

    public void fail(Throwable t) {
        if (!this.failed) {
            if (this.doneHandler != null) {
                this.doneHandler.handle((Object)new DefaultFutureResult(t));
            } else {
                this.cause = t;
            }
            this.failed = true;
        }
    }

    public CountingCompletionHandler<T> setHandler(Handler<AsyncResult<T>> doneHandler) {
        this.doneHandler = doneHandler;
        this.checkDone();
        return this;
    }

    private void checkDone() {
        if (this.doneHandler != null) {
            if (this.cause != null) {
                this.doneHandler.handle((Object)new DefaultFutureResult(this.cause));
            } else if (this.count == this.required) {
                this.doneHandler.handle((Object)new DefaultFutureResult((Object)null));
            }
        }
    }
}

