/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.port.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.kuujo.vertigo.hook.OutputHook;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.io.OutputContext;
import net.kuujo.vertigo.io.port.OutputPortContext;
import net.kuujo.vertigo.io.stream.OutputStreamContext;
import net.kuujo.vertigo.io.stream.impl.DefaultOutputStreamContext;

public class DefaultOutputPortContext
extends BaseContext<OutputPortContext>
implements OutputPortContext {
    private static final String DEFAULT_PORT = "default";
    private String port = "default";
    private Collection<OutputStreamContext> streams = new ArrayList<OutputStreamContext>();
    private List<OutputHook> hooks = new ArrayList<OutputHook>();
    @JsonIgnore
    private OutputContext output;

    public DefaultOutputPortContext setOutput(OutputContext output) {
        this.output = output;
        return this;
    }

    @Override
    public String name() {
        return this.port;
    }

    @Override
    public OutputContext output() {
        return this.output;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Collection<OutputStreamContext> streams() {
        return this.streams;
    }

    @Override
    public List<OutputHook> hooks() {
        return this.hooks;
    }

    @Override
    public void notify(OutputPortContext update) {
        if (update == null) {
            for (OutputStreamContext stream : this.streams) {
                stream.notify(null);
            }
            this.streams.clear();
        } else {
            Iterator<OutputStreamContext> iter = this.streams.iterator();
            while (iter.hasNext()) {
                OutputStreamContext stream = iter.next();
                OutputStreamContext match = null;
                for (OutputStreamContext s : update.streams()) {
                    if (!stream.equals(s)) continue;
                    match = s;
                    break;
                }
                if (match != null) {
                    stream.notify(match);
                    continue;
                }
                stream.notify(null);
                iter.remove();
            }
            for (OutputStreamContext stream : update.streams()) {
                if (this.streams.contains(stream)) continue;
                this.streams.add(stream);
            }
        }
        super.notify(this);
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultOutputPortContext> {
        private Builder() {
            super(new DefaultOutputPortContext());
        }

        private Builder(DefaultOutputPortContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultOutputPortContext context) {
            return new Builder(context);
        }

        public Builder setName(String port) {
            ((DefaultOutputPortContext)this.context).port = port;
            return this;
        }

        public Builder setStreams(DefaultOutputStreamContext ... streams) {
            ((DefaultOutputPortContext)this.context).streams = new ArrayList();
            for (DefaultOutputStreamContext stream : streams) {
                ((DefaultOutputPortContext)this.context).streams.add(stream.setPort((OutputPortContext)((Object)this.context)));
            }
            return this;
        }

        public Builder setStreams(Collection<DefaultOutputStreamContext> streams) {
            ((DefaultOutputPortContext)this.context).streams = new ArrayList();
            for (DefaultOutputStreamContext stream : streams) {
                ((DefaultOutputPortContext)this.context).streams.add(stream.setPort((OutputPortContext)((Object)this.context)));
            }
            return this;
        }

        public Builder addStream(DefaultOutputStreamContext stream) {
            ((DefaultOutputPortContext)this.context).streams.add(stream.setPort((OutputPortContext)((Object)this.context)));
            return this;
        }

        public Builder removeStream(OutputStreamContext stream) {
            ((DefaultOutputPortContext)this.context).streams.remove(stream);
            return this;
        }

        public Builder setHooks(OutputHook ... hooks) {
            ((DefaultOutputPortContext)this.context).hooks = Arrays.asList(hooks);
            return this;
        }

        public Builder setHooks(List<OutputHook> hooks) {
            ((DefaultOutputPortContext)this.context).hooks = hooks;
            return this;
        }

        public Builder addHook(OutputHook hook) {
            ((DefaultOutputPortContext)this.context).hooks.add(hook);
            return this;
        }

        public Builder removeHook(OutputHook hook) {
            ((DefaultOutputPortContext)this.context).hooks.remove(hook);
            return this;
        }
    }
}

