/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.hook;

import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonObject;

public class EventBusHookListener {
    private final String address;
    private final EventBus eventBus;
    private Handler<InstanceContext> startHandler;
    private Handler sendHandler;
    private Handler receiveHandler;
    private Handler<InstanceContext> stopHandler;
    private final Handler<Message<JsonObject>> messageHandler = new Handler<Message<JsonObject>>(){

        public void handle(Message<JsonObject> message) {
            String event = ((JsonObject)message.body()).getString("event");
            if (event != null) {
                switch (event) {
                    case "start": {
                        if (EventBusHookListener.this.startHandler == null) break;
                        EventBusHookListener.this.startHandler.handle((Object)DefaultInstanceContext.fromJson(((JsonObject)message.body()).getObject("context")));
                        break;
                    }
                    case "send": {
                        if (EventBusHookListener.this.sendHandler == null) break;
                        EventBusHookListener.this.sendHandler.handle(((JsonObject)message.body()).getValue("message"));
                        break;
                    }
                    case "receive": {
                        if (EventBusHookListener.this.receiveHandler == null) break;
                        EventBusHookListener.this.receiveHandler.handle(((JsonObject)message.body()).getValue("message"));
                        break;
                    }
                    case "stop": {
                        if (EventBusHookListener.this.stopHandler == null) break;
                        EventBusHookListener.this.stopHandler.handle((Object)DefaultInstanceContext.fromJson(((JsonObject)message.body()).getObject("context")));
                    }
                }
            }
        }
    };

    public EventBusHookListener(String address, EventBus eventBus) {
        this.address = address;
        this.eventBus = eventBus;
    }

    public EventBusHookListener start() {
        return this.start(null);
    }

    public EventBusHookListener start(Handler<AsyncResult<Void>> doneHandler) {
        this.eventBus.registerHandler(this.address, this.messageHandler, doneHandler);
        return this;
    }

    public EventBusHookListener startHandler(Handler<InstanceContext> startHandler) {
        this.startHandler = startHandler;
        return this;
    }

    public EventBusHookListener receiveHandler(Handler receiveHandler) {
        this.receiveHandler = receiveHandler;
        return this;
    }

    public EventBusHookListener sendHandler(Handler sendHandler) {
        this.sendHandler = sendHandler;
        return this;
    }

    public EventBusHookListener stopHandler(Handler<InstanceContext> stopHandler) {
        this.stopHandler = stopHandler;
        return this;
    }
}

