/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.monitor.LocalMultiMapStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.kuujo.vertigo.cluster.manager.impl.ClusterData;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonArray;

class VertxClusterData
implements ClusterData {
    private final Vertx vertx;

    public VertxClusterData(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return new SharedDataMultiMap(this.vertx.sharedData().getMap(String.format("__map.%s", name)));
    }

    @Override
    public <K, V> Map<K, V> getMap(String name) {
        return this.vertx.sharedData().getMap(name);
    }

    @Override
    public <T> Set<T> getSet(String name) {
        return this.vertx.sharedData().getSet(name);
    }

    @Override
    public <T> List<T> getList(String name) {
        return new SharedDataList((Map<Integer, Object>)this.vertx.sharedData().getMap(String.format("__list.%s", name)));
    }

    @Override
    public <T> Queue<T> getQueue(String name) {
        return new SharedDataQueue((Map<Integer, Object>)this.vertx.sharedData().getMap(String.format("__queue.%s", name)));
    }

    private static class SharedDataQueue<T>
    implements Queue<T> {
        private final Map<Integer, Object> map;
        private int currentIndex;

        public SharedDataQueue(Map<Integer, Object> map) {
            this.map = map;
            this.currentIndex = (Integer)(map.containsKey(-1) ? map.get(-1) : Integer.valueOf(0));
            this.map.put(-1, this.currentIndex);
        }

        @Override
        public int size() {
            return this.map.size() - 1;
        }

        @Override
        public boolean isEmpty() {
            return this.map.size() == 1;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.values().contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.map.values().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public T remove() {
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                if (this.map.containsKey(this.currentIndex)) {
                    Object value = this.map.remove(this.currentIndex);
                    ++this.currentIndex;
                    this.map.put(-1, this.currentIndex);
                    return (T)value;
                }
                throw new IllegalStateException("Queue is empty.");
            }
        }

        @Override
        public T poll() {
            Object value = this.map.remove(this.currentIndex);
            if (value != null) {
                ++this.currentIndex;
                this.map.put(-1, this.currentIndex);
            }
            return (T)value;
        }

        @Override
        public T element() {
            Object value = this.map.get(this.currentIndex);
            if (value != null) {
                return (T)value;
            }
            throw new IllegalStateException("Queue is empty.");
        }

        @Override
        public T peek() {
            return (T)this.map.get(this.currentIndex);
        }

        @Override
        public boolean offer(T e) {
            int index = this.currentIndex + this.map.size() - 1;
            this.map.put(index, e);
            return true;
        }

        @Override
        public boolean add(T e) {
            int index = this.currentIndex + this.map.size() - 1;
            this.map.put(index, e);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                Iterator<Map.Entry<Integer, Object>> iter = this.map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Integer, Object> entry = iter.next();
                    if (!entry.getValue().equals(o)) continue;
                    iter.remove();
                    int index = entry.getKey() + 1;
                    while (this.map.containsKey(index)) {
                        this.map.put(index - 1, this.map.remove(index));
                        ++index;
                    }
                    return true;
                }
                return false;
            }
        }

        @Override
        public void clear() {
            this.map.clear();
            this.map.put(-1, this.currentIndex);
        }
    }

    private static class SharedDataList<T>
    implements List<T> {
        private final Map<Integer, Object> map;

        public SharedDataList(Map<Integer, Object> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.values().contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.map.values().containsAll(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> c) {
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                for (T value : c) {
                    this.add(value);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                int i = index;
                for (T value : c) {
                    this.add(i++, value);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                Iterator<Map.Entry<Integer, Object>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (!c.contains(iterator.next().getValue())) continue;
                    iterator.remove();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                Iterator<Map.Entry<Integer, Object>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (c.contains(iterator.next().getValue())) continue;
                    iterator.remove();
                }
            }
            return true;
        }

        @Override
        public T get(int index) {
            if (index < 0 || index > this.map.size() - 1) {
                throw new IndexOutOfBoundsException("Index out of bounds.");
            }
            return (T)this.map.get(index);
        }

        @Override
        public boolean add(T e) {
            this.map.put(this.map.size(), e);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, T element) {
            if (index < 0 || index > this.map.size() - 1) {
                throw new IndexOutOfBoundsException("Index out of bounds.");
            }
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                for (int i = this.map.size() - 1; i > index; --i) {
                    this.map.put(i + 1, this.map.remove(i));
                }
                this.map.put(index, element);
            }
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < this.map.size(); ++i) {
                if (!this.map.get(i).equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            for (int i = this.map.size() - 1; i >= 0; --i) {
                if (!this.map.get(i).equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator<T> listIterator() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Not supported.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                for (int i = 0; i < this.map.size(); ++i) {
                    Object value = this.map.get(i);
                    if (value == null || !value.equals(o)) continue;
                    this.map.remove(i);
                    ++i;
                    while (this.map.containsKey(i)) {
                        this.map.put(i - 1, this.map.remove(i));
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public T set(int index, T element) {
            return (T)this.map.put(index, element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T remove(int index) {
            if (index < 0 || index > this.map.size() - 1) {
                throw new IndexOutOfBoundsException("Index out of bounds.");
            }
            Map<Integer, Object> map = this.map;
            synchronized (map) {
                Object value = this.map.remove(index);
                int i = index + 1;
                while (this.map.containsKey(i)) {
                    this.map.put(i - 1, this.map.remove(i));
                    ++i;
                }
                return (T)value;
            }
        }
    }

    private static class SharedDataMultiMap<K, V>
    implements MultiMap<K, V> {
        private final Map<K, String> map;

        public SharedDataMultiMap(Map<K, String> map) {
            this.map = map;
        }

        public void destroy() {
            this.map.clear();
        }

        public Object getId() {
            return null;
        }

        public String getPartitionKey() {
            throw new UnsupportedOperationException("getPartitionKey not supported.");
        }

        public String getServiceName() {
            throw new UnsupportedOperationException("getServiceName not supported.");
        }

        public String addEntryListener(EntryListener<K, V> arg0, boolean arg1) {
            throw new UnsupportedOperationException("addEntryListener not supported.");
        }

        public String addEntryListener(EntryListener<K, V> arg0, K arg1, boolean arg2) {
            throw new UnsupportedOperationException("addEntryListener not supported.");
        }

        public String addLocalEntryListener(EntryListener<K, V> arg0) {
            throw new UnsupportedOperationException("addLocalEntryListener not supported.");
        }

        public void clear() {
            this.map.clear();
        }

        public boolean containsEntry(K key, V value) {
            String sdata = this.map.get(key);
            if (sdata == null) {
                return false;
            }
            JsonArray data = new JsonArray(sdata);
            return data.contains(value);
        }

        public boolean containsKey(K key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Set<Map.Entry<K, V>> entrySet() {
            throw new UnsupportedOperationException("entrySet not supported.");
        }

        public void forceUnlock(K key) {
            throw new UnsupportedOperationException("forceUnlock not supported.");
        }

        public Collection<V> get(K key) {
            String sdata = this.map.get(key);
            if (sdata == null) {
                return null;
            }
            JsonArray data = new JsonArray(sdata);
            return data.toList();
        }

        public LocalMultiMapStats getLocalMultiMapStats() {
            throw new UnsupportedOperationException("getLocalMultiMapStats not supported.");
        }

        public String getName() {
            throw new UnsupportedOperationException("getName not supported.");
        }

        public boolean isLocked(K key) {
            return false;
        }

        public Set<K> keySet() {
            return this.map.keySet();
        }

        public Set<K> localKeySet() {
            return this.map.keySet();
        }

        public void lock(K key) {
            throw new UnsupportedOperationException("lock not supported.");
        }

        public void lock(K key, long timeout, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("lock not supported.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(K key, V value) {
            Map<K, String> map = this.map;
            synchronized (map) {
                String sdata = this.map.get(key);
                JsonArray data = sdata != null ? new JsonArray(sdata) : new JsonArray();
                data.add(value);
                this.map.put(key, data.encode());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<V> remove(Object key) {
            Map<K, String> map = this.map;
            synchronized (map) {
                String sdata = this.map.remove(key);
                if (sdata == null) {
                    return null;
                }
                JsonArray data = new JsonArray(sdata);
                return data.toList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Object value) {
            Map<K, String> map = this.map;
            synchronized (map) {
                String sdata = this.map.get(key);
                if (sdata == null) {
                    return false;
                }
                JsonArray data = new JsonArray(sdata);
                if (data.contains(value)) {
                    JsonArray newData = new JsonArray();
                    boolean removed = false;
                    for (Object item : data) {
                        if (!removed) {
                            if (!item.equals(value)) {
                                newData.add(item);
                                continue;
                            }
                            removed = true;
                            continue;
                        }
                        newData.add(item);
                    }
                    if (newData.size() > 0) {
                        this.map.put(key, newData.encode());
                    } else {
                        this.map.remove(key);
                    }
                    return true;
                }
                return false;
            }
        }

        public boolean removeEntryListener(String registrationId) {
            throw new UnsupportedOperationException("removeEntryListener not supported.");
        }

        public int size() {
            return this.map.size();
        }

        public boolean tryLock(K key) {
            throw new UnsupportedOperationException("tryLock not supported.");
        }

        public boolean tryLock(K key, long timeout, TimeUnit timeUnit) throws InterruptedException {
            throw new UnsupportedOperationException("tryLock not supported.");
        }

        public void unlock(K key) {
            throw new UnsupportedOperationException("unlock not supported.");
        }

        public int valueCount(K key) {
            String sdata = this.map.get(key);
            JsonArray data = sdata != null ? new JsonArray(sdata) : new JsonArray();
            return data.size();
        }

        public Collection<V> values() {
            ArrayList values = new ArrayList();
            for (Map.Entry<K, String> entry : this.map.entrySet()) {
                values.addAll(new JsonArray(entry.getValue()).toList());
            }
            return values;
        }
    }
}

