/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import net.kuujo.vertigo.cluster.manager.impl.ClusterListener;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

class HazelcastClusterListener
implements ClusterListener,
MembershipListener {
    private final Vertx vertx;
    private final String nodeID;
    private Handler<String> joinHandler;
    private Handler<String> leaveHandler;

    public HazelcastClusterListener(HazelcastInstance hazelcast, Vertx vertx) {
        this.vertx = vertx;
        this.nodeID = hazelcast.getCluster().getLocalMember().getUuid();
        hazelcast.getCluster().addMembershipListener((MembershipListener)this);
    }

    @Override
    public String nodeId() {
        return this.nodeID;
    }

    @Override
    public void joinHandler(Handler<String> handler) {
        this.joinHandler = handler;
    }

    @Override
    public void leaveHandler(Handler<String> handler) {
        this.leaveHandler = handler;
    }

    public void memberAdded(final MembershipEvent event) {
        if (this.joinHandler != null) {
            this.vertx.runOnContext((Handler)new Handler<Void>(){

                public void handle(Void _) {
                    HazelcastClusterListener.this.joinHandler.handle((Object)event.getMember().getUuid());
                }
            });
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent event) {
    }

    public void memberRemoved(final MembershipEvent event) {
        if (this.leaveHandler != null) {
            this.vertx.runOnContext((Handler)new Handler<Void>(){

                public void handle(Void _) {
                    HazelcastClusterListener.this.leaveHandler.handle((Object)event.getMember().getUuid());
                }
            });
        }
    }
}

