/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import com.hazelcast.core.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import net.kuujo.vertigo.Config;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.cluster.manager.NodeManager;
import net.kuujo.vertigo.cluster.manager.impl.ClusterData;
import net.kuujo.vertigo.cluster.manager.impl.ClusterListener;
import net.kuujo.vertigo.cluster.manager.impl.WrappedWatchableMap;
import net.kuujo.vertigo.impl.ContextBuilder;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.network.manager.NetworkManager;
import net.kuujo.vertigo.platform.ModuleInfo;
import net.kuujo.vertigo.platform.PlatformManager;
import net.kuujo.vertigo.util.Configs;
import net.kuujo.vertigo.util.ContextManager;
import net.kuujo.vertigo.util.serialization.SerializationException;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.spi.Action;

public class DefaultNodeManager
implements NodeManager {
    private static final Serializer serializer = SerializerFactory.getSerializer(Config.class);
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private final String node;
    private final String group;
    private final String cluster;
    private final Vertx vertx;
    private final ContextManager context;
    private final PlatformManager platform;
    private final ClusterListener listener;
    private final ClusterData data;
    private final MultiMap<String, String> nodes;
    private final MultiMap<String, String> groups;
    private final MultiMap<String, String> deployments;
    private final Set<String> networks;
    private final Map<String, String> managers = new HashMap<String, String>();
    private final Handler<Message<JsonObject>> messageHandler = new Handler<Message<JsonObject>>(){

        public void handle(Message<JsonObject> message) {
            String action = ((JsonObject)message.body()).getString("action");
            if (action != null) {
                switch (action) {
                    case "ping": {
                        DefaultNodeManager.this.doPing((Message<JsonObject>)message);
                        break;
                    }
                    case "installed": {
                        DefaultNodeManager.this.doInstalled((Message<JsonObject>)message);
                        break;
                    }
                    case "install": {
                        DefaultNodeManager.this.doInstall((Message<JsonObject>)message);
                        break;
                    }
                    case "uninstall": {
                        DefaultNodeManager.this.doUninstall((Message<JsonObject>)message);
                        break;
                    }
                    case "upload": {
                        DefaultNodeManager.this.doUpload((Message<JsonObject>)message);
                        break;
                    }
                    case "deploy": {
                        DefaultNodeManager.this.doDeploy((Message<JsonObject>)message);
                        break;
                    }
                    case "undeploy": {
                        DefaultNodeManager.this.doUndeploy((Message<JsonObject>)message);
                        break;
                    }
                    default: {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                    }
                }
            }
        }
    };

    public DefaultNodeManager(String node, String group, String cluster, Vertx vertx, ContextManager context, PlatformManager platform, ClusterListener listener, ClusterData data) {
        this.node = node;
        this.group = group;
        this.cluster = cluster;
        this.vertx = vertx;
        this.context = context;
        this.platform = platform;
        this.listener = listener;
        this.data = data;
        this.nodes = data.getMultiMap(String.format("nodes.%s", cluster));
        this.groups = data.getMultiMap(String.format("groups.%s", cluster));
        this.deployments = data.getMultiMap(String.format("deployments.%s", cluster));
        this.networks = data.getSet(String.format("run.%s", cluster));
    }

    @Override
    public String address() {
        return String.format("%s.%s.%s", this.cluster, this.group, this.node);
    }

    @Override
    public NodeManager start() {
        return this.start(null);
    }

    @Override
    public NodeManager start(final Handler<AsyncResult<Void>> doneHandler) {
        this.vertx.eventBus().registerHandler(this.node, this.messageHandler, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    DefaultNodeManager.this.context.execute(new Action<Void>(){

                        public Void perform() {
                            if (!DefaultNodeManager.this.nodes.containsEntry((Object)DefaultNodeManager.this.listener.nodeId(), (Object)DefaultNodeManager.this.node)) {
                                DefaultNodeManager.this.nodes.put((Object)DefaultNodeManager.this.listener.nodeId(), (Object)DefaultNodeManager.this.node);
                            }
                            if (!DefaultNodeManager.this.groups.containsEntry((Object)DefaultNodeManager.this.group, (Object)DefaultNodeManager.this.node)) {
                                DefaultNodeManager.this.groups.put((Object)DefaultNodeManager.this.group, (Object)DefaultNodeManager.this.node);
                            }
                            return null;
                        }
                    }, doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(final Handler<AsyncResult<Void>> doneHandler) {
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultNodeManager.this.nodes.remove((Object)DefaultNodeManager.this.listener.nodeId(), (Object)DefaultNodeManager.this.node);
                DefaultNodeManager.this.groups.remove((Object)DefaultNodeManager.this.group, (Object)DefaultNodeManager.this.node);
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                DefaultNodeManager.this.vertx.eventBus().unregisterHandler(DefaultNodeManager.this.node, DefaultNodeManager.this.messageHandler, doneHandler);
            }
        });
    }

    private void doPing(Message<JsonObject> message) {
        message.reply(new JsonObject().putString("status", "pong").putString("result", "node"));
    }

    private void doInstalled(final Message<JsonObject> message) {
        String moduleName = ((JsonObject)message.body()).getString("module");
        if (moduleName == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No module specified."));
            return;
        }
        this.platform.getModuleInfo(moduleName, new Handler<AsyncResult<ModuleInfo>>(){

            public void handle(AsyncResult<ModuleInfo> result) {
                if (result.failed() || result.result() == null) {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", Boolean.valueOf(false)));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", Boolean.valueOf(true)));
                }
            }
        });
    }

    private void doInstall(final Message<JsonObject> message) {
        String moduleName = ((JsonObject)message.body()).getString("module");
        if (moduleName == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No module specified."));
            return;
        }
        String uploadID = ((JsonObject)message.body()).getString("upload");
        if (uploadID == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No upload found."));
            return;
        }
        File modRoot = new File(TEMP_DIR, "vertx-zip-mods");
        final File modZip = new File(modRoot, uploadID + ".zip");
        this.vertx.fileSystem().exists(modZip.getAbsolutePath(), (Handler)new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else if (!((Boolean)result.result()).booleanValue()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid upload."));
                } else {
                    DefaultNodeManager.this.platform.installModule(modZip.getAbsolutePath(), new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                }
            }
        });
    }

    private void doUninstall(final Message<JsonObject> message) {
        String moduleName = ((JsonObject)message.body()).getString("module");
        if (moduleName == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No module specified."));
            return;
        }
        this.platform.uninstallModule(moduleName, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doUpload(final Message<JsonObject> message) {
        final String id = UUID.randomUUID().toString();
        final File modRoot = new File(TEMP_DIR, "vertx-zip-mods");
        this.vertx.fileSystem().mkdir(modRoot.getAbsolutePath(), true, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Failed to create upload file."));
                } else {
                    File modZip = new File(modRoot, id + ".zip");
                    modZip.deleteOnExit();
                    DefaultNodeManager.this.vertx.fileSystem().open(modZip.getAbsolutePath(), (Handler)new Handler<AsyncResult<AsyncFile>>(){

                        public void handle(AsyncResult<AsyncFile> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", "Failed to create upload file."));
                            } else {
                                DefaultNodeManager.this.handleUpload((AsyncFile)result.result(), id, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        if (result.failed()) {
                                            message.reply(new JsonObject().putString("status", "error").putString("message", "Failed to register upload handler."));
                                        } else {
                                            message.reply(new JsonObject().putString("status", "ok").putString("id", id));
                                        }
                                    }
                                }));
                            }
                        }
                    });
                }
            }
        });
    }

    private void handleUpload(AsyncFile file, String address, Handler<AsyncResult<Void>> doneHandler) {
        this.vertx.eventBus().registerHandler(address, this.handleUpload(file, address), doneHandler);
    }

    private Handler<Message<Buffer>> handleUpload(final AsyncFile file, final String address) {
        final AtomicLong position = new AtomicLong();
        return new Handler<Message<Buffer>>(){

            public void handle(final Message<Buffer> message) {
                final 9 handler = this;
                final Buffer buffer = (Buffer)message.body();
                if (buffer.length() > 0) {
                    file.write(buffer, position.get(), (Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                file.close();
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                DefaultNodeManager.this.vertx.eventBus().unregisterHandler(address, handler);
                            } else {
                                position.addAndGet(buffer.length());
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                } else {
                    file.flush((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                DefaultNodeManager.this.vertx.eventBus().unregisterHandler(address, handler);
                            } else {
                                file.close((Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        if (result.failed()) {
                                            message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                            DefaultNodeManager.this.vertx.eventBus().unregisterHandler(address, handler);
                                        } else {
                                            DefaultNodeManager.this.vertx.eventBus().unregisterHandler(address, handler, (Handler)new Handler<AsyncResult<Void>>(){

                                                public void handle(AsyncResult<Void> result) {
                                                    message.reply(new JsonObject().putString("status", "ok"));
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        };
    }

    private void doDeploy(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment type specified."));
        } else {
            switch (type) {
                case "module": {
                    this.doDeployModule(message);
                    break;
                }
                case "verticle": {
                    this.doDeployVerticle(message);
                    break;
                }
                case "network": {
                    this.doDeployNetwork(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid deployment type."));
                }
            }
        }
    }

    private void doDeployModule(final Message<JsonObject> message) {
        String moduleName = ((JsonObject)message.body()).getString("module");
        if (moduleName == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No module name specified."));
            return;
        }
        JsonObject config = ((JsonObject)message.body()).getObject("config");
        if (config == null) {
            config = new JsonObject();
        }
        int instances = ((JsonObject)message.body()).getInteger("instances", 1);
        this.platform.deployModule(moduleName, config, instances, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    final String deploymentID = (String)result.result();
                    DefaultNodeManager.this.context.execute(new Action<String>(){

                        public String perform() {
                            DefaultNodeManager.this.deployments.put((Object)DefaultNodeManager.this.node, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                            return deploymentID;
                        }
                    }, new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> result) {
                            message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                        }
                    });
                }
            }
        });
    }

    private void doDeployVerticle(final Message<JsonObject> message) {
        String main = ((JsonObject)message.body()).getString("main");
        if (main == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No verticle main specified."));
            return;
        }
        JsonObject config = ((JsonObject)message.body()).getObject("config");
        if (config == null) {
            config = new JsonObject();
        }
        int instances = ((JsonObject)message.body()).getInteger("instances", 1);
        boolean worker = ((JsonObject)message.body()).getBoolean("worker", false);
        if (worker) {
            boolean multiThreaded = ((JsonObject)message.body()).getBoolean("multi-threaded", false);
            this.platform.deployWorkerVerticle(main, config, instances, multiThreaded, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultNodeManager.this.context.execute(new Action<String>(){

                            public String perform() {
                                DefaultNodeManager.this.deployments.put((Object)DefaultNodeManager.this.node, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                                return deploymentID;
                            }
                        }, new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                            }
                        });
                    }
                }
            });
        } else {
            this.platform.deployVerticle(main, config, instances, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultNodeManager.this.context.execute(new Action<String>(){

                            public String perform() {
                                DefaultNodeManager.this.deployments.put((Object)DefaultNodeManager.this.node, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                                return deploymentID;
                            }
                        }, new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                            }
                        });
                    }
                }
            });
        }
    }

    private void doDeployNetwork(Message<JsonObject> message) {
        Object network = ((JsonObject)message.body()).getValue("network");
        if (network != null) {
            if (network instanceof String) {
                this.doDeployNetwork((String)network, message);
            } else if (network instanceof JsonObject) {
                JsonObject jsonNetwork = (JsonObject)network;
                try {
                    NetworkConfig config = serializer.deserializeObject(jsonNetwork, NetworkConfig.class);
                    this.doDeployNetwork(config, message);
                }
                catch (SerializationException e) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid network configuration."));
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network specified."));
        }
    }

    private void doDeployNetwork(String name, final Message<JsonObject> message) {
        DefaultNetworkContext context;
        String scontext = (String)this.data.getMap(String.format("%s.%s", this.cluster, name)).get(String.format("%s.%s", this.cluster, name));
        NetworkContext networkContext = context = scontext != null ? DefaultNetworkContext.fromJson(new JsonObject(scontext)) : ContextBuilder.buildContext(new DefaultNetworkConfig(name), this.cluster);
        if (!this.managers.containsKey(context.address())) {
            this.platform.deployVerticle(NetworkManager.class.getName(), new JsonObject().putString("cluster", this.cluster).putString("address", context.address()), 1, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "Failed to deploy network manager."));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultNodeManager.this.context.execute(new Action<Void>(){

                            public Void perform() {
                                DefaultNodeManager.this.networks.add(context.name());
                                return null;
                            }
                        }, new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                DefaultNodeManager.this.managers.put(context.address(), deploymentID);
                                DefaultNodeManager.this.doDeployNetwork(context, (Message<JsonObject>)message);
                            }
                        });
                    }
                }
            });
        } else {
            message.reply(new JsonObject().putString("status", "ok").putObject("context", DefaultNetworkContext.toJson(context)));
        }
    }

    private void doDeployNetwork(NetworkConfig network, final Message<JsonObject> message) {
        String scontext = (String)this.data.getMap(String.format("%s.%s", this.cluster, network.getName())).get(String.format("%s.%s", this.cluster, network.getName()));
        NetworkContext updatedContext = scontext != null ? ContextBuilder.buildContext(Configs.mergeNetworks(DefaultNetworkContext.fromJson(new JsonObject(scontext)).config(), network), this.cluster) : ContextBuilder.buildContext(network, this.cluster);
        final NetworkContext context = updatedContext;
        if (!this.managers.containsKey(context.address())) {
            this.platform.deployVerticle(NetworkManager.class.getName(), new JsonObject().putString("cluster", this.cluster).putString("address", context.address()), 1, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "Failed to deploy network manager."));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultNodeManager.this.context.execute(new Action<Void>(){

                            public Void perform() {
                                DefaultNodeManager.this.networks.add(context.name());
                                return null;
                            }
                        }, new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                DefaultNodeManager.this.managers.put(context.address(), deploymentID);
                                DefaultNodeManager.this.doDeployNetwork(context, (Message<JsonObject>)message);
                            }
                        });
                    }
                }
            });
        } else {
            this.doDeployNetwork(context, message);
        }
    }

    private void doDeployNetwork(final NetworkContext context, final Message<JsonObject> message) {
        final WrappedWatchableMap<String, String> data = new WrappedWatchableMap<String, String>(context.address(), this.data.getMap(context.address()), this.vertx);
        data.watch(context.status(), null, new Handler<MapEvent<String, String>>(){

            public void handle(MapEvent<String, String> event) {
                if (event.type().equals((Object)MapEvent.Type.CREATE) && event.value().equals(context.version())) {
                    data.unwatch(context.status(), null, this, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            message.reply(new JsonObject().putString("status", "ok").putObject("context", DefaultNetworkContext.toJson(context)));
                        }
                    });
                }
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    try {
                        data.put(context.address(), DefaultNetworkContext.toJson(context).encode());
                    }
                    catch (Exception e) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                    }
                }
            }
        });
    }

    private void doUndeploy(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment type specified."));
        } else {
            switch (type) {
                case "module": {
                    this.doUndeployModule(message);
                    break;
                }
                case "verticle": {
                    this.doUndeployVerticle(message);
                    break;
                }
                case "network": {
                    this.doUndeployNetwork(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid deployment type " + type));
                }
            }
        }
    }

    private void doUndeployModule(final Message<JsonObject> message) {
        final String deploymentID = ((JsonObject)message.body()).getString("id");
        if (deploymentID == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment ID specified."));
        } else {
            this.removeDeployment(deploymentID, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    DefaultNodeManager.this.platform.undeployModule(deploymentID, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                }
            });
        }
    }

    private void doUndeployVerticle(final Message<JsonObject> message) {
        final String deploymentID = ((JsonObject)message.body()).getString("id");
        if (deploymentID == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment ID specified."));
        } else {
            this.removeDeployment(deploymentID, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    DefaultNodeManager.this.platform.undeployVerticle(deploymentID, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                }
            });
        }
    }

    private void removeDeployment(final String deploymentID, Handler<AsyncResult<Void>> doneHandler) {
        this.context.execute(new Action<Void>(){

            public Void perform() {
                Collection nodeDeployments = DefaultNodeManager.this.deployments.get((Object)DefaultNodeManager.this.node);
                if (nodeDeployments != null) {
                    String deployment = null;
                    for (String sdeployment : nodeDeployments) {
                        JsonObject info = new JsonObject(sdeployment);
                        if (!info.getString("id").equals(deploymentID)) continue;
                        deployment = sdeployment;
                        break;
                    }
                    if (deployment != null) {
                        DefaultNodeManager.this.deployments.remove((Object)DefaultNodeManager.this.node, deployment);
                    }
                }
                return null;
            }
        }, doneHandler);
    }

    private void doUndeployNetwork(Message<JsonObject> message) {
        Object network = ((JsonObject)message.body()).getValue("network");
        if (network != null) {
            if (network instanceof String) {
                this.doUndeployNetwork((String)network, message);
            } else if (network instanceof JsonObject) {
                JsonObject jsonNetwork = (JsonObject)network;
                try {
                    NetworkConfig config = serializer.deserializeObject(jsonNetwork, NetworkConfig.class);
                    this.doUndeployNetwork(config, message);
                }
                catch (SerializationException e) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid network configuration."));
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network specified."));
        }
    }

    private void doUndeployNetwork(String name, final Message<JsonObject> message) {
        final WrappedWatchableMap<String, String> data = new WrappedWatchableMap<String, String>(String.format("%s.%s", this.cluster, name), this.data.getMap(String.format("%s.%s", this.cluster, name)), this.vertx);
        String scontext = (String)data.get(String.format("%s.%s", this.cluster, name));
        if (scontext == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
        } else {
            final DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject(scontext));
            if (this.managers.containsKey(context.address())) {
                data.watch(context.status(), MapEvent.Type.CHANGE, new Handler<MapEvent<String, String>>(){

                    public void handle(MapEvent<String, String> event) {
                        if (event.value() != null && event.value().equals("")) {
                            data.unwatch(context.status(), MapEvent.Type.CHANGE, this, new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> result) {
                                    DefaultNodeManager.this.platform.undeployVerticle((String)DefaultNodeManager.this.managers.remove(context.address()), new Handler<AsyncResult<Void>>(){

                                        public void handle(AsyncResult<Void> result) {
                                            if (result.failed()) {
                                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                            } else {
                                                DefaultNodeManager.this.context.execute(new Action<Void>(){

                                                    public Void perform() {
                                                        DefaultNodeManager.this.networks.remove(context.address());
                                                        data.remove(context.status());
                                                        return null;
                                                    }
                                                }, new Handler<AsyncResult<Void>>(){

                                                    public void handle(AsyncResult<Void> result) {
                                                        message.reply(new JsonObject().putString("status", "ok"));
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    }
                }, new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> result) {
                        if (result.failed()) {
                            message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                        } else {
                            DefaultNodeManager.this.context.run(new Runnable(){

                                @Override
                                public void run() {
                                    data.remove(context.address());
                                }
                            });
                        }
                    }
                });
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
            }
        }
    }

    private void doUndeployNetwork(NetworkConfig network, final Message<JsonObject> message) {
        final WrappedWatchableMap<String, String> data = new WrappedWatchableMap<String, String>(String.format("%s.%s", this.cluster, network.getName()), this.data.getMap(String.format("%s.%s", this.cluster, network.getName())), this.vertx);
        String scontext = (String)data.get(String.format("%s.%s", this.cluster, network.getName()));
        if (scontext == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
        } else {
            DefaultNetworkContext tempContext = DefaultNetworkContext.fromJson(new JsonObject(scontext));
            if (this.managers.containsKey(tempContext.address())) {
                NetworkConfig updatedConfig = Configs.unmergeNetworks(tempContext.config(), network);
                final NetworkContext context = ContextBuilder.buildContext(updatedConfig, this.cluster);
                if (context.components().isEmpty()) {
                    data.watch(context.status(), MapEvent.Type.CHANGE, new Handler<MapEvent<String, String>>(){

                        public void handle(MapEvent<String, String> event) {
                            if (event.value() != null && event.value().equals("")) {
                                data.unwatch(context.status(), MapEvent.Type.CHANGE, this, new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        DefaultNodeManager.this.platform.undeployVerticle((String)DefaultNodeManager.this.managers.remove(context.address()), new Handler<AsyncResult<Void>>(){

                                            public void handle(AsyncResult<Void> result) {
                                                if (result.failed()) {
                                                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                                } else {
                                                    DefaultNodeManager.this.context.execute(new Action<Void>(){

                                                        public Void perform() {
                                                            DefaultNodeManager.this.networks.remove(context.address());
                                                            data.remove(context.status());
                                                            return null;
                                                        }
                                                    }, new Handler<AsyncResult<Void>>(){

                                                        public void handle(AsyncResult<Void> result) {
                                                            message.reply(new JsonObject().putString("status", "ok"));
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    }, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                DefaultNodeManager.this.context.run(new Runnable(){

                                    @Override
                                    public void run() {
                                        data.remove(context.address());
                                    }
                                });
                            }
                        }
                    });
                } else {
                    data.watch(context.status(), MapEvent.Type.CHANGE, new Handler<MapEvent<String, String>>(){

                        public void handle(MapEvent<String, String> event) {
                            if (event.value() != null && event.value().equals(context.version())) {
                                data.unwatch(context.status(), null, this, new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        message.reply(new JsonObject().putString("status", "ok").putObject("context", DefaultNetworkContext.toJson(context)));
                                    }
                                });
                            }
                        }
                    }, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                DefaultNodeManager.this.context.run(new Runnable(){

                                    @Override
                                    public void run() {
                                        data.put(context.address(), DefaultNetworkContext.toJson(context).encode());
                                    }
                                });
                            }
                        }
                    });
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
            }
        }
    }
}

