/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import com.hazelcast.core.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.kuujo.vertigo.Config;
import net.kuujo.vertigo.cluster.manager.ClusterManager;
import net.kuujo.vertigo.cluster.manager.impl.ClusterData;
import net.kuujo.vertigo.cluster.manager.impl.ClusterListener;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.platform.PlatformManager;
import net.kuujo.vertigo.util.ContextManager;
import net.kuujo.vertigo.util.serialization.SerializationException;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.spi.Action;

public class DefaultClusterManager
implements ClusterManager {
    private static final Serializer serializer = SerializerFactory.getSerializer(Config.class);
    private final String cluster;
    private final Vertx vertx;
    private final ContextManager context;
    private final PlatformManager platform;
    private final ClusterListener listener;
    private final ClusterData data;
    private final MultiMap<String, String> nodes;
    private final MultiMap<String, String> groups;
    private final MultiMap<String, String> deployments;
    private final Set<String> networks;
    private final Map<Object, String> groupSelectors;
    private final Map<Object, String> nodeSelectors;
    private final Handler<Message<JsonObject>> messageHandler = new Handler<Message<JsonObject>>(){

        public void handle(Message<JsonObject> message) {
            String action = ((JsonObject)message.body()).getString("action");
            if (action != null) {
                block8 : switch (action) {
                    case "ping": {
                        DefaultClusterManager.this.doPing((Message<JsonObject>)message);
                        break;
                    }
                    case "find": {
                        DefaultClusterManager.this.doFind((Message<JsonObject>)message);
                        break;
                    }
                    case "list": {
                        DefaultClusterManager.this.doList((Message<JsonObject>)message);
                        break;
                    }
                    case "select": {
                        DefaultClusterManager.this.doSelect((Message<JsonObject>)message);
                        break;
                    }
                    case "deploy": {
                        DefaultClusterManager.this.doDeploy((Message<JsonObject>)message);
                        break;
                    }
                    case "undeploy": {
                        DefaultClusterManager.this.doUndeploy((Message<JsonObject>)message);
                        break;
                    }
                    default: {
                        String type = ((JsonObject)message.body()).getString("type");
                        if (type == null) {
                            message.reply(new JsonObject().putString("status", "error").putString("message", "No data type specified."));
                            return;
                        }
                        switch (type) {
                            case "key": {
                                switch (action) {
                                    case "get": {
                                        DefaultClusterManager.this.doKeyGet((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "set": {
                                        DefaultClusterManager.this.doKeySet((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "delete": {
                                        DefaultClusterManager.this.doKeyDelete((Message<JsonObject>)message);
                                        break block8;
                                    }
                                }
                                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                                break block8;
                            }
                            case "counter": {
                                switch (action) {
                                    case "increment": {
                                        DefaultClusterManager.this.doCounterIncrement((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "decrement": {
                                        DefaultClusterManager.this.doCounterDecrement((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "get": {
                                        DefaultClusterManager.this.doCounterGet((Message<JsonObject>)message);
                                        break block8;
                                    }
                                }
                                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                                break block8;
                            }
                            case "multimap": {
                                switch (action) {
                                    case "put": {
                                        DefaultClusterManager.this.doMultiMapPut((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "get": {
                                        DefaultClusterManager.this.doMultiMapGet((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "remove": {
                                        DefaultClusterManager.this.doMultiMapRemove((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "contains": {
                                        DefaultClusterManager.this.doMultiMapContains((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "keys": {
                                        DefaultClusterManager.this.doMultiMapKeys((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "values": {
                                        DefaultClusterManager.this.doMultiMapValues((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "empty": {
                                        DefaultClusterManager.this.doMultiMapIsEmpty((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "clear": {
                                        DefaultClusterManager.this.doMultiMapClear((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "size": {
                                        DefaultClusterManager.this.doMultiMapSize((Message<JsonObject>)message);
                                    }
                                }
                                break block8;
                            }
                            case "map": {
                                switch (action) {
                                    case "put": {
                                        DefaultClusterManager.this.doMapPut((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "get": {
                                        DefaultClusterManager.this.doMapGet((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "remove": {
                                        DefaultClusterManager.this.doMapRemove((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "contains": {
                                        DefaultClusterManager.this.doMapContainsKey((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "keys": {
                                        DefaultClusterManager.this.doMapKeys((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "values": {
                                        DefaultClusterManager.this.doMapValues((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "empty": {
                                        DefaultClusterManager.this.doMapIsEmpty((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "clear": {
                                        DefaultClusterManager.this.doMapClear((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "size": {
                                        DefaultClusterManager.this.doMapSize((Message<JsonObject>)message);
                                        break block8;
                                    }
                                }
                                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                                break block8;
                            }
                            case "list": {
                                switch (action) {
                                    case "add": {
                                        DefaultClusterManager.this.doListAdd((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "get": {
                                        DefaultClusterManager.this.doListGet((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "remove": {
                                        DefaultClusterManager.this.doListRemove((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "contains": {
                                        DefaultClusterManager.this.doListContains((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "size": {
                                        DefaultClusterManager.this.doListSize((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "empty": {
                                        DefaultClusterManager.this.doListIsEmpty((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "clear": {
                                        DefaultClusterManager.this.doListClear((Message<JsonObject>)message);
                                        break block8;
                                    }
                                }
                                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                                break block8;
                            }
                            case "set": {
                                switch (action) {
                                    case "add": {
                                        DefaultClusterManager.this.doSetAdd((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "remove": {
                                        DefaultClusterManager.this.doSetRemove((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "contains": {
                                        DefaultClusterManager.this.doSetContains((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "size": {
                                        DefaultClusterManager.this.doSetSize((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "empty": {
                                        DefaultClusterManager.this.doSetIsEmpty((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "clear": {
                                        DefaultClusterManager.this.doSetClear((Message<JsonObject>)message);
                                        break block8;
                                    }
                                }
                                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                                break block8;
                            }
                            case "queue": {
                                switch (action) {
                                    case "add": {
                                        DefaultClusterManager.this.doQueueAdd((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "remove": {
                                        DefaultClusterManager.this.doQueueRemove((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "contains": {
                                        DefaultClusterManager.this.doQueueContains((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "empty": {
                                        DefaultClusterManager.this.doQueueIsEmpty((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "size": {
                                        DefaultClusterManager.this.doQueueSize((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "clear": {
                                        DefaultClusterManager.this.doQueueClear((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "offer": {
                                        DefaultClusterManager.this.doQueueOffer((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "element": {
                                        DefaultClusterManager.this.doQueueElement((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "poll": {
                                        DefaultClusterManager.this.doQueuePoll((Message<JsonObject>)message);
                                        break block8;
                                    }
                                    case "peek": {
                                        DefaultClusterManager.this.doQueuePeek((Message<JsonObject>)message);
                                        break block8;
                                    }
                                }
                                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                            }
                        }
                        break;
                    }
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Must specify an action"));
            }
        }
    };
    private final Handler<String> joinHandler = new Handler<String>(){

        public void handle(String nodeID) {
            DefaultClusterManager.this.doNodeJoined(nodeID);
        }
    };
    private final Handler<String> leaveHandler = new Handler<String>(){

        public void handle(String nodeID) {
            DefaultClusterManager.this.doNodeLeft(nodeID);
        }
    };

    public DefaultClusterManager(String cluster, Vertx vertx, ContextManager context, PlatformManager platform, ClusterListener listener, ClusterData data) {
        this.cluster = cluster;
        this.vertx = vertx;
        this.context = context;
        this.platform = platform;
        this.listener = listener;
        this.data = data;
        this.nodes = data.getMultiMap(String.format("nodes.%s", cluster));
        this.groups = data.getMultiMap(String.format("groups.%s", cluster));
        this.deployments = data.getMultiMap(String.format("deployments.%s", cluster));
        this.networks = data.getSet(String.format("run.%s", cluster));
        this.groupSelectors = data.getMap(String.format("selectors.group.%s", cluster));
        this.nodeSelectors = data.getMap(String.format("selectors.node.%s", cluster));
    }

    @Override
    public String address() {
        return this.cluster;
    }

    @Override
    public ClusterManager start() {
        return this.start(null);
    }

    @Override
    public ClusterManager start(Handler<AsyncResult<Void>> doneHandler) {
        this.listener.joinHandler(this.joinHandler);
        this.listener.leaveHandler(this.leaveHandler);
        this.vertx.eventBus().registerHandler(this.address(), this.messageHandler, doneHandler);
        return this;
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(Handler<AsyncResult<Void>> doneHandler) {
        this.listener.joinHandler(null);
        this.listener.leaveHandler(null);
        this.vertx.eventBus().unregisterHandler(this.address(), this.messageHandler, doneHandler);
    }

    private String formatKey(String key) {
        return String.format("%s.%s", this.cluster, key);
    }

    private void doNodeJoined(String nodeID) {
    }

    private synchronized void doNodeLeft(final String nodeID) {
        this.context.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MultiMap multiMap = DefaultClusterManager.this.nodes;
                synchronized (multiMap) {
                    Collection removedNodes = DefaultClusterManager.this.nodes.remove((Object)nodeID);
                    if (removedNodes != null) {
                        Object object = DefaultClusterManager.this.groups;
                        synchronized (object) {
                            for (final String node : removedNodes) {
                                for (final String group : DefaultClusterManager.this.groups.keySet()) {
                                    DefaultClusterManager.this.groups.remove((Object)group, (Object)node);
                                    DefaultClusterManager.this.vertx.runOnContext((Handler)new Handler<Void>(){

                                        public void handle(Void event) {
                                            DefaultClusterManager.this.vertx.eventBus().publish(String.format("%s.leave", group), node);
                                        }
                                    });
                                }
                                DefaultClusterManager.this.vertx.runOnContext((Handler)new Handler<Void>(){

                                    public void handle(Void event) {
                                        DefaultClusterManager.this.vertx.eventBus().publish(String.format("%s.leave", DefaultClusterManager.this.cluster), node);
                                    }
                                });
                            }
                        }
                        object = DefaultClusterManager.this.networks;
                        synchronized (object) {
                            for (final String name : DefaultClusterManager.this.networks) {
                                String address = (String)DefaultClusterManager.this.nodeSelectors.get(name);
                                if (address == null || !removedNodes.contains(address)) continue;
                                DefaultClusterManager.this.selectNode(name, (Handler<AsyncResult<String>>)((Handler)new Handler<AsyncResult<String>>(){

                                    public void handle(AsyncResult<String> result) {
                                        if (result.succeeded() && result.result() != null) {
                                            JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "network").putString("network", name);
                                            DefaultClusterManager.this.vertx.eventBus().send((String)result.result(), message);
                                        }
                                    }
                                }));
                            }
                        }
                    }
                }
            }
        });
    }

    private void doPing(Message<JsonObject> message) {
        message.reply(new JsonObject().putString("status", "pong").putString("result", "cluster"));
    }

    private void doFind(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type != null) {
            switch (type) {
                case "group": {
                    this.doFindGroup(message);
                    break;
                }
                case "node": {
                    this.doFindNode(message);
                    break;
                }
                case "network": {
                    this.doFindNetwork(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid type specified."));
                    break;
                }
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No type specified."));
        }
    }

    private void doFindGroup(final Message<JsonObject> message) {
        String group = ((JsonObject)message.body()).getString("group");
        if (group == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid group name."));
            return;
        }
        final String address = String.format("%s.%s", this.cluster, group);
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.groups.containsKey((Object)address);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else if (!((Boolean)result.result()).booleanValue()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid group."));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putString("result", address));
                }
            }
        });
    }

    private void doFindNode(final Message<JsonObject> message) {
        final String node = ((JsonObject)message.body()).getString("node");
        if (node == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid node address."));
            return;
        }
        this.context.execute(new Action<String>(){

            public String perform() {
                for (String group : DefaultClusterManager.this.groups.keySet()) {
                    String address = String.format("%s.%s", group, node);
                    if (!DefaultClusterManager.this.groups.containsEntry((Object)group, (Object)address)) continue;
                    return address;
                }
                return null;
            }
        }, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else if (result.result() == null) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid node."));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putString("result", (String)result.result()));
                }
            }
        });
    }

    private void doFindNetwork(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("network");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network name specified."));
        } else {
            this.context.execute(new Action<NetworkContext>(){

                public NetworkContext perform() {
                    String scontext = (String)DefaultClusterManager.this.data.getMap(String.format("%s.%s", DefaultClusterManager.this.cluster, name)).get(String.format("%s.%s", DefaultClusterManager.this.cluster, name));
                    if (scontext != null) {
                        return DefaultNetworkContext.fromJson(new JsonObject(scontext));
                    }
                    return null;
                }
            }, new Handler<AsyncResult<NetworkContext>>(){

                public void handle(AsyncResult<NetworkContext> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (result.result() == null) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "Not a valid network."));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putObject("result", DefaultNetworkContext.toJson((NetworkContext)result.result())));
                    }
                }
            });
        }
    }

    private void doList(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type != null) {
            switch (type) {
                case "group": {
                    this.doListGroup(message);
                    break;
                }
                case "node": {
                    this.doListNode(message);
                    break;
                }
                case "network": {
                    this.doListNetwork(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid type specified."));
                    break;
                }
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No type specified."));
        }
    }

    private void doListGroup(final Message<JsonObject> message) {
        this.context.execute(new Action<Set<String>>(){

            public Set<String> perform() {
                return DefaultClusterManager.this.groups.keySet();
            }
        }, new Handler<AsyncResult<Set<String>>>(){

            public void handle(AsyncResult<Set<String>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray((Object[])((Set)result.result()).toArray(new String[((Set)result.result()).size()]))));
                }
            }
        });
    }

    private void doListNode(final Message<JsonObject> message) {
        this.context.execute(new Action<Collection<String>>(){

            public Collection<String> perform() {
                ArrayList<String> nodes = new ArrayList<String>();
                for (String group : DefaultClusterManager.this.groups.keySet()) {
                    nodes.addAll(DefaultClusterManager.this.groups.get((Object)group));
                }
                return nodes;
            }
        }, new Handler<AsyncResult<Collection<String>>>(){

            public void handle(AsyncResult<Collection<String>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray((Object[])((Collection)result.result()).toArray(new String[((Collection)result.result()).size()]))));
                }
            }
        });
    }

    private void doListNetwork(final Message<JsonObject> message) {
        this.context.execute(new Action<List<NetworkContext>>(){

            public List<NetworkContext> perform() {
                ArrayList<NetworkContext> contexts = new ArrayList<NetworkContext>();
                for (String name : DefaultClusterManager.this.networks) {
                    String scontext = (String)DefaultClusterManager.this.data.getMap(String.format("%s.%s", DefaultClusterManager.this.cluster, name)).get(String.format("%s.%s", DefaultClusterManager.this.cluster, name));
                    if (scontext == null) continue;
                    contexts.add(DefaultNetworkContext.fromJson(new JsonObject(scontext)));
                }
                return contexts;
            }
        }, new Handler<AsyncResult<List<NetworkContext>>>(){

            public void handle(AsyncResult<List<NetworkContext>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    JsonArray contexts = new JsonArray();
                    for (NetworkContext context : (List)result.result()) {
                        contexts.addObject(DefaultNetworkContext.toJson(context));
                    }
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", contexts));
                }
            }
        });
    }

    private void doSelect(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type != null) {
            switch (type) {
                case "group": {
                    this.doSelectGroup(message);
                    break;
                }
                case "node": {
                    this.doSelectNode(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid type specified."));
                    break;
                }
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No type specified."));
        }
    }

    private void doSelectGroup(final Message<JsonObject> message) {
        Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
        } else {
            this.selectGroup(key, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (result.result() == null) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "No groups to select."));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putString("result", (String)result.result()));
                    }
                }
            });
        }
    }

    private void selectGroup(final Object key, Handler<AsyncResult<String>> doneHandler) {
        this.context.execute(new Action<String>(){

            public String perform() {
                String address = (String)DefaultClusterManager.this.groupSelectors.get(key);
                if (address != null) {
                    return address;
                }
                Set groups = DefaultClusterManager.this.groups.keySet();
                int index = new Random().nextInt(groups.size());
                int i = 0;
                for (String group : groups) {
                    if (i == index) {
                        DefaultClusterManager.this.groupSelectors.put(key, group);
                        return group;
                    }
                    ++i;
                }
                return null;
            }
        }, doneHandler);
    }

    private void doSelectNode(final Message<JsonObject> message) {
        Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
        } else {
            this.selectNode(key, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (result.result() == null) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "No nodes to select."));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putString("result", (String)result.result()));
                    }
                }
            });
        }
    }

    private void selectNode(final Object key, Handler<AsyncResult<String>> doneHandler) {
        this.context.execute(new Action<String>(){

            public String perform() {
                String address = (String)DefaultClusterManager.this.nodeSelectors.get(key);
                if (address != null) {
                    return address;
                }
                HashSet nodes = new HashSet();
                for (String group : DefaultClusterManager.this.groups.keySet()) {
                    nodes.addAll(DefaultClusterManager.this.groups.get((Object)group));
                }
                int index = new Random().nextInt(nodes.size());
                int i = 0;
                for (String node : nodes) {
                    if (i == index) {
                        DefaultClusterManager.this.nodeSelectors.put(key, node);
                        return node;
                    }
                    ++i;
                }
                return null;
            }
        }, doneHandler);
    }

    private void doDeploy(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment type specified."));
        } else {
            switch (type) {
                case "module": {
                    this.doDeployModule(message);
                    break;
                }
                case "verticle": {
                    this.doDeployVerticle(message);
                    break;
                }
                case "network": {
                    this.doDeployNetwork(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid deployment type."));
                }
            }
        }
    }

    private void doDeployModule(final Message<JsonObject> message) {
        String moduleName = ((JsonObject)message.body()).getString("module");
        if (moduleName == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No module name specified."));
            return;
        }
        JsonObject config = ((JsonObject)message.body()).getObject("config");
        if (config == null) {
            config = new JsonObject();
        }
        int instances = ((JsonObject)message.body()).getInteger("instances", 1);
        this.platform.deployModule(moduleName, config, instances, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    final String deploymentID = (String)result.result();
                    DefaultClusterManager.this.context.execute(new Action<String>(){

                        public String perform() {
                            DefaultClusterManager.this.deployments.put((Object)DefaultClusterManager.this.cluster, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                            return deploymentID;
                        }
                    }, new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> result) {
                            message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                        }
                    });
                }
            }
        });
    }

    private void doDeployVerticle(final Message<JsonObject> message) {
        String main = ((JsonObject)message.body()).getString("main");
        if (main == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No verticle main specified."));
            return;
        }
        JsonObject config = ((JsonObject)message.body()).getObject("config");
        if (config == null) {
            config = new JsonObject();
        }
        int instances = ((JsonObject)message.body()).getInteger("instances", 1);
        boolean worker = ((JsonObject)message.body()).getBoolean("worker", false);
        if (worker) {
            boolean multiThreaded = ((JsonObject)message.body()).getBoolean("multi-threaded", false);
            this.platform.deployWorkerVerticle(main, config, instances, multiThreaded, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultClusterManager.this.context.execute(new Action<String>(){

                            public String perform() {
                                DefaultClusterManager.this.deployments.put((Object)DefaultClusterManager.this.cluster, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                                return deploymentID;
                            }
                        }, new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                            }
                        });
                    }
                }
            });
        } else {
            this.platform.deployVerticle(main, config, instances, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultClusterManager.this.context.execute(new Action<String>(){

                            public String perform() {
                                DefaultClusterManager.this.deployments.put((Object)DefaultClusterManager.this.cluster, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                                return deploymentID;
                            }
                        }, new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                            }
                        });
                    }
                }
            });
        }
    }

    private void doDeployNetwork(final Message<JsonObject> message) {
        Object network = ((JsonObject)message.body()).getValue("network");
        if (network != null) {
            String key;
            if (network instanceof String) {
                key = (String)network;
            } else if (network instanceof JsonObject) {
                try {
                    key = serializer.deserializeObject((JsonObject)network, NetworkConfig.class).getName();
                }
                catch (SerializationException e) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                    return;
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid network configuration."));
                return;
            }
            this.selectNode(key, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (result.result() == null) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "No nodes available."));
                    } else {
                        DefaultClusterManager.this.vertx.eventBus().sendWithTimeout((String)result.result(), (JsonObject)message.body(), 120000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                            public void handle(AsyncResult<Message<JsonObject>> result) {
                                if (result.failed()) {
                                    message.reply(new JsonObject().putString("status", "error").putString("message", "Failed to reach node."));
                                } else {
                                    message.reply((JsonObject)((Message)result.result()).body());
                                }
                            }
                        });
                    }
                }
            });
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network specified."));
        }
    }

    private void doUndeploy(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment type specified."));
        } else {
            switch (type) {
                case "module": {
                    this.doUndeployModule(message);
                    break;
                }
                case "verticle": {
                    this.doUndeployVerticle(message);
                    break;
                }
                case "network": {
                    this.doUndeployNetwork(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid deployment type " + type));
                }
            }
        }
    }

    private void doUndeployModule(final Message<JsonObject> message) {
        final String deploymentID = ((JsonObject)message.body()).getString("id");
        if (deploymentID == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment ID specified."));
        } else {
            this.removeDeployment(deploymentID, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    DefaultClusterManager.this.platform.undeployModule(deploymentID, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                }
            });
        }
    }

    private void doUndeployVerticle(final Message<JsonObject> message) {
        final String deploymentID = ((JsonObject)message.body()).getString("id");
        if (deploymentID == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment ID specified."));
        } else {
            this.removeDeployment(deploymentID, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    DefaultClusterManager.this.platform.undeployVerticle(deploymentID, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                }
            });
        }
    }

    private void removeDeployment(final String deploymentID, Handler<AsyncResult<Void>> doneHandler) {
        this.context.execute(new Action<Void>(){

            public Void perform() {
                Collection clusterDeployments = DefaultClusterManager.this.deployments.get((Object)DefaultClusterManager.this.cluster);
                if (clusterDeployments != null) {
                    String deployment = null;
                    for (String sdeployment : clusterDeployments) {
                        JsonObject info = new JsonObject(sdeployment);
                        if (!info.getString("id").equals(deploymentID)) continue;
                        deployment = sdeployment;
                        break;
                    }
                    if (deployment != null) {
                        DefaultClusterManager.this.deployments.remove((Object)DefaultClusterManager.this.cluster, deployment);
                    }
                }
                return null;
            }
        }, doneHandler);
    }

    private void doUndeployNetwork(final Message<JsonObject> message) {
        Object network = ((JsonObject)message.body()).getValue("network");
        if (network != null) {
            String key;
            if (network instanceof String) {
                key = (String)network;
            } else if (network instanceof JsonObject) {
                try {
                    key = serializer.deserializeObject((JsonObject)network, NetworkConfig.class).getName();
                }
                catch (SerializationException e) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                    return;
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid network configuration."));
                return;
            }
            this.selectNode(key, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (result.result() == null) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "No nodes available."));
                    } else {
                        DefaultClusterManager.this.vertx.eventBus().sendWithTimeout((String)result.result(), (JsonObject)message.body(), 120000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                            public void handle(AsyncResult<Message<JsonObject>> result) {
                                if (result.failed()) {
                                    message.reply(new JsonObject().putString("status", "error").putString("message", "Failed to reach node."));
                                } else {
                                    message.reply((JsonObject)((Message)result.result()).body());
                                }
                            }
                        });
                    }
                }
            });
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network specified."));
        }
    }

    private void doKeySet(final Message<JsonObject> message) {
        final String key = ((JsonObject)message.body()).getString("name");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey("keys")).put(key, value);
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doKeyGet(final Message<JsonObject> message) {
        final String key = ((JsonObject)message.body()).getString("name");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey("keys")).get(key);
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result));
                }
            }
        });
    }

    private void doKeyDelete(final Message<JsonObject> message) {
        final String key = ((JsonObject)message.body()).getString("name");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey("keys")).remove(key);
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doCounterGet(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Long>(){

            public Long perform() {
                Map counters = DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey("counters"));
                Long value = (Long)counters.get(name);
                if (value == null) {
                    value = 0L;
                }
                return value;
            }
        }, new Handler<AsyncResult<Long>>(){

            public void handle(AsyncResult<Long> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doCounterIncrement(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Long>(){

            public Long perform() {
                Map<String, Long> counters = DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey("counters"));
                Long value = (Long)counters.get(name);
                if (value == null) {
                    value = 0L;
                }
                Long l = value;
                Long l2 = value = Long.valueOf(value + 1L);
                counters.put(name, value);
                return value;
            }
        }, new Handler<AsyncResult<Long>>(){

            public void handle(AsyncResult<Long> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doCounterDecrement(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Long>(){

            public Long perform() {
                Map<String, Long> counters = DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey("counters"));
                Long value = (Long)counters.get(name);
                if (value == null) {
                    value = 0L;
                }
                Long l = value;
                Long l2 = value = Long.valueOf(value - 1L);
                counters.put(name, value);
                return value;
            }
        }, new Handler<AsyncResult<Long>>(){

            public void handle(AsyncResult<Long> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doMultiMapPut(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).put(key, value);
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }

    private void doMultiMapGet(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        this.context.execute(new Action<Collection<Object>>(){

            public Collection<Object> perform() {
                return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).get(key);
            }
        }, new Handler<AsyncResult<Collection<Object>>>(){

            public void handle(AsyncResult<Collection<Object>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray(((Collection)result.result()).toArray(new Object[((Collection)result.result()).size()]))));
                }
            }
        });
    }

    private void doMultiMapRemove(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value != null) {
            this.context.execute(new Action<Boolean>(){

                public Boolean perform() {
                    return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).remove(key, value);
                }
            }, new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                    }
                }
            });
        } else {
            this.context.execute(new Action<Collection<Object>>(){

                public Collection<Object> perform() {
                    return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).remove(key);
                }
            }, new Handler<AsyncResult<Collection<Object>>>(){

                public void handle(AsyncResult<Collection<Object>> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray(((Collection)result.result()).toArray(new Object[((Collection)result.result()).size()]))));
                    }
                }
            });
        }
    }

    private void doMultiMapContains(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (key != null && value != null) {
            this.context.execute(new Action<Boolean>(){

                public Boolean perform() {
                    return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).containsEntry(key, value);
                }
            }, new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                    }
                }
            });
        } else if (key != null) {
            this.context.execute(new Action<Boolean>(){

                public Boolean perform() {
                    return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).containsKey(key);
                }
            }, new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                    }
                }
            });
        } else if (value != null) {
            this.context.execute(new Action<Boolean>(){

                public Boolean perform() {
                    return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).containsValue(key);
                }
            }, new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                    }
                }
            });
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key or value specified."));
        }
    }

    private void doMultiMapKeys(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Set<Object>>(){

            public Set<Object> perform() {
                return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).keySet();
            }
        }, new Handler<AsyncResult<Set<Object>>>(){

            public void handle(AsyncResult<Set<Object>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray(((Set)result.result()).toArray(new Object[((Set)result.result()).size()]))));
                }
            }
        });
    }

    private void doMultiMapValues(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Collection<Object>>(){

            public Collection<Object> perform() {
                return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).values();
            }
        }, new Handler<AsyncResult<Collection<Object>>>(){

            public void handle(AsyncResult<Collection<Object>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray(((Collection)result.result()).toArray(new Object[((Collection)result.result()).size()]))));
                }
            }
        });
    }

    private void doMultiMapIsEmpty(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).size() == 0;
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doMultiMapSize(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Integer>(){

            public Integer perform() {
                return DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).size();
            }
        }, new Handler<AsyncResult<Integer>>(){

            public void handle(AsyncResult<Integer> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doMultiMapClear(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultClusterManager.this.data.getMultiMap(DefaultClusterManager.this.formatKey(name)).clear();
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doMapPut(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).put(key, value);
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }

    private void doMapGet(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).get(key);
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }

    private void doMapRemove(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).remove(key);
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }

    private void doMapContainsKey(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).containsKey(key);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doMapKeys(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Set<Object>>(){

            public Set<Object> perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).keySet();
            }
        }, new Handler<AsyncResult<Set<Object>>>(){

            public void handle(AsyncResult<Set<Object>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray(((Set)result.result()).toArray(new Object[((Set)result.result()).size()]))));
                }
            }
        });
    }

    private void doMapValues(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Collection<Object>>(){

            public Collection<Object> perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).values();
            }
        }, new Handler<AsyncResult<Collection<Object>>>(){

            public void handle(AsyncResult<Collection<Object>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray(((Collection)result.result()).toArray(new Object[((Collection)result.result()).size()]))));
                }
            }
        });
    }

    private void doMapIsEmpty(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).isEmpty();
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doMapSize(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Integer>(){

            public Integer perform() {
                return DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).size();
            }
        }, new Handler<AsyncResult<Integer>>(){

            public void handle(AsyncResult<Integer> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doMapClear(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultClusterManager.this.data.getMap(DefaultClusterManager.this.formatKey(name)).clear();
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doListAdd(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).add(value);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doListGet(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Integer index = ((JsonObject)message.body()).getInteger("index");
        if (index == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No index specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).get(index);
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }

    private void doListRemove(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        if (((JsonObject)message.body()).containsField("index")) {
            final int index = ((JsonObject)message.body()).getInteger("index");
            this.context.execute(new Action<Object>(){

                public Object perform() {
                    return DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).remove(index);
                }
            }, new Handler<AsyncResult<Object>>(){

                public void handle(AsyncResult<Object> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                    }
                }
            });
        } else {
            final Object value = ((JsonObject)message.body()).getValue("value");
            if (value == null) {
                message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            } else {
                this.context.execute(new Action<Boolean>(){

                    public Boolean perform() {
                        return DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).remove(value);
                    }
                }, new Handler<AsyncResult<Boolean>>(){

                    public void handle(AsyncResult<Boolean> result) {
                        if (result.failed()) {
                            message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                        } else {
                            message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                        }
                    }
                });
            }
        }
    }

    private void doListContains(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).contains(value);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doListIsEmpty(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).isEmpty();
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doListSize(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Integer>(){

            public Integer perform() {
                return DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).size();
            }
        }, new Handler<AsyncResult<Integer>>(){

            public void handle(AsyncResult<Integer> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doListClear(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultClusterManager.this.data.getList(DefaultClusterManager.this.formatKey(name)).clear();
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doSetAdd(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getSet(DefaultClusterManager.this.formatKey(name)).add(value);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doSetRemove(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
        } else {
            this.context.execute(new Action<Boolean>(){

                public Boolean perform() {
                    return DefaultClusterManager.this.data.getSet(DefaultClusterManager.this.formatKey(name)).remove(value);
                }
            }, new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                    }
                }
            });
        }
    }

    private void doSetContains(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getSet(DefaultClusterManager.this.formatKey(name)).contains(value);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doSetIsEmpty(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getSet(DefaultClusterManager.this.formatKey(name)).isEmpty();
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doSetSize(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Integer>(){

            public Integer perform() {
                return DefaultClusterManager.this.data.getSet(DefaultClusterManager.this.formatKey(name)).size();
            }
        }, new Handler<AsyncResult<Integer>>(){

            public void handle(AsyncResult<Integer> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doSetClear(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultClusterManager.this.data.getSet(DefaultClusterManager.this.formatKey(name)).clear();
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doQueueAdd(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).add(value);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doQueueRemove(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
        } else {
            this.context.execute(new Action<Boolean>(){

                public Boolean perform() {
                    return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).remove(value);
                }
            }, new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                    }
                }
            });
        }
    }

    private void doQueueContains(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).contains(value);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doQueueIsEmpty(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).isEmpty();
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doQueueSize(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Integer>(){

            public Integer perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).size();
            }
        }, new Handler<AsyncResult<Integer>>(){

            public void handle(AsyncResult<Integer> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putNumber("result", (Number)result.result()));
                }
            }
        });
    }

    private void doQueueClear(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).clear();
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok"));
                }
            }
        });
    }

    private void doQueueOffer(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        final Object value = ((JsonObject)message.body()).getValue("value");
        if (value == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No value specified."));
            return;
        }
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).offer(value);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                }
            }
        });
    }

    private void doQueueElement(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).element();
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }

    private void doQueuePoll(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).poll();
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }

    private void doQueuePeek(final Message<JsonObject> message) {
        final String name = ((JsonObject)message.body()).getString("name");
        if (name == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No name specified."));
            return;
        }
        this.context.execute(new Action<Object>(){

            public Object perform() {
                return DefaultClusterManager.this.data.getQueue(DefaultClusterManager.this.formatKey(name)).peek();
            }
        }, new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putValue("result", result.result()));
                }
            }
        });
    }
}

