/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import java.util.UUID;
import net.kuujo.vertigo.cluster.manager.ClusterManager;
import net.kuujo.vertigo.cluster.manager.GroupManager;
import net.kuujo.vertigo.cluster.manager.NodeManager;
import net.kuujo.vertigo.cluster.manager.impl.ClusterData;
import net.kuujo.vertigo.cluster.manager.impl.ClusterDataFactory;
import net.kuujo.vertigo.cluster.manager.impl.ClusterListener;
import net.kuujo.vertigo.cluster.manager.impl.ClusterListenerFactory;
import net.kuujo.vertigo.cluster.manager.impl.DefaultClusterManager;
import net.kuujo.vertigo.cluster.manager.impl.DefaultGroupManager;
import net.kuujo.vertigo.cluster.manager.impl.DefaultNodeManager;
import net.kuujo.vertigo.platform.impl.DefaultPlatformManager;
import net.kuujo.vertigo.util.ContextManager;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Future;
import org.vertx.java.core.Handler;
import org.vertx.java.platform.Verticle;

public class ClusterAgent
extends Verticle {
    private ClusterManager cluster;
    private GroupManager group;
    private NodeManager node;

    public void start(final Future<Void> startResult) {
        String clusterName = this.container.config().getString("cluster", "vertigo");
        String groupName = this.container.config().getString("group", "__DEFAULT__");
        String nodeAddress = this.container.config().getString("node", UUID.randomUUID().toString());
        DefaultPlatformManager platform = new DefaultPlatformManager(this.vertx, this.container);
        ClusterListener listener = new ClusterListenerFactory(this.vertx).createClusterListener();
        ClusterData data = new ClusterDataFactory(this.vertx).createClusterData();
        this.cluster = new DefaultClusterManager(clusterName, this.vertx, new ContextManager(this.vertx), platform, listener, data);
        this.group = new DefaultGroupManager(String.format("%s.%s", clusterName, groupName), clusterName, this.vertx, new ContextManager(this.vertx), platform, listener, data);
        this.node = new DefaultNodeManager(String.format("%s.%s.%s", clusterName, groupName, nodeAddress), String.format("%s.%s", clusterName, groupName), clusterName, this.vertx, new ContextManager(this.vertx), platform, listener, data);
        CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(3);
        counter.setHandler(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    startResult.setFailure(result.cause());
                } else {
                    startResult.setResult((Object)null);
                }
            }
        });
        this.cluster.start(counter);
        this.group.start(counter);
        this.node.start(counter);
    }

    public void stop() {
        this.cluster.stop();
        this.group.stop();
        this.node.stop();
    }
}

