/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import net.kuujo.vertigo.cluster.ClusterException;
import net.kuujo.vertigo.cluster.Node;
import net.kuujo.vertigo.platform.PlatformManager;
import net.kuujo.vertigo.platform.impl.DefaultPlatformManager;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;

public class DefaultNode
implements Node {
    private static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private final String address;
    private final Vertx vertx;
    private final PlatformManager platform;

    public DefaultNode(String address, Vertx vertx, Container container) {
        this.address = address;
        this.vertx = vertx;
        this.platform = new DefaultPlatformManager(vertx, container);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Node ping(final Handler<AsyncResult<Node>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "ping");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("pong")) {
                    if (((JsonObject)((Message)result.result()).body()).getString("result").equals("cluster")) {
                        new DefaultFutureResult((Object)DefaultNode.this).setHandler(resultHandler);
                    } else {
                        new DefaultFutureResult((Throwable)((Object)new ClusterException("Not a valid node address."))).setHandler(resultHandler);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Node installModule(String moduleName) {
        return this.installModule(moduleName);
    }

    @Override
    public Node installModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "installed").putString("type", "module").putString("module", moduleName);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getBoolean("result", false)) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                } else {
                    DefaultNode.this.platform.zipModule(moduleName, new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                String zipFile = (String)result.result();
                                DefaultNode.this.vertx.fileSystem().open(zipFile, (Handler)new Handler<AsyncResult<AsyncFile>>(){

                                    public void handle(AsyncResult<AsyncFile> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                                        } else {
                                            final AsyncFile file = (AsyncFile)result.result();
                                            JsonObject message = new JsonObject().putString("action", "upload");
                                            DefaultNode.this.vertx.eventBus().sendWithTimeout(DefaultNode.this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                                                public void handle(AsyncResult<Message<JsonObject>> result) {
                                                    if (result.failed()) {
                                                        new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                                                    } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                                                        new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                                                    } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                                                        final String id = ((JsonObject)((Message)result.result()).body()).getString("id");
                                                        DefaultNode.this.uploadFile(file, id, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                                                            public void handle(AsyncResult<Void> result) {
                                                                if (result.failed()) {
                                                                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                                                                } else {
                                                                    JsonObject message = new JsonObject().putString("action", "install").putString("type", "module").putString("module", moduleName).putString("upload", id);
                                                                    DefaultNode.this.vertx.eventBus().sendWithTimeout(DefaultNode.this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                                                                        public void handle(AsyncResult<Message<JsonObject>> result) {
                                                                            if (result.failed()) {
                                                                                new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                                                                            } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                                                                                new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                                                                            } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                                                                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                                                                            }
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }));
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    private void uploadFile(AsyncFile file, String address, Handler<AsyncResult<Void>> doneHandler) {
        this.uploadFile(file, 0L, address, doneHandler);
    }

    private void uploadFile(final AsyncFile file, final long position, final String address, final Handler<AsyncResult<Void>> doneHandler) {
        Buffer buffer = new Buffer(4096);
        file.read(buffer, 0, position, 4096, (Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    final Buffer buffer = (Buffer)result.result();
                    DefaultNode.this.vertx.eventBus().sendWithTimeout(address, buffer, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                        public void handle(AsyncResult<Message<JsonObject>> result) {
                            if (result.failed()) {
                                new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                            } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                                new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                            } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                                if (buffer.length() > 0) {
                                    DefaultNode.this.uploadFile(file, position + (long)buffer.length(), address, (Handler<AsyncResult<Void>>)doneHandler);
                                } else {
                                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public Node uninstallModule(String moduleName) {
        return this.uninstallModule(moduleName, null);
    }

    @Override
    public Node uninstallModule(String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "uninstall").putString("type", "module").putString("module", moduleName);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Node deployModule(String moduleName) {
        return this.deployModule(moduleName, null, 1, null);
    }

    @Override
    public Node deployModule(String moduleName, JsonObject config) {
        return this.deployModule(moduleName, config, 1, null);
    }

    @Override
    public Node deployModule(String moduleName, int instances) {
        return this.deployModule(moduleName, null, instances, null);
    }

    @Override
    public Node deployModule(String moduleName, JsonObject config, int instances) {
        return this.deployModule(moduleName, config, instances, null);
    }

    @Override
    public Node deployModule(String moduleName, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, null, 1, doneHandler);
    }

    @Override
    public Node deployModule(String moduleName, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, config, 1, doneHandler);
    }

    @Override
    public Node deployModule(String moduleName, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, null, instances, doneHandler);
    }

    @Override
    public Node deployModule(String moduleName, JsonObject config, int instances, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "module").putString("module", moduleName).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Node deployVerticle(String main) {
        return this.deployVerticle(main, null, 1, null);
    }

    @Override
    public Node deployVerticle(String main, JsonObject config) {
        return this.deployVerticle(main, config, 1, null);
    }

    @Override
    public Node deployVerticle(String main, int instances) {
        return this.deployVerticle(main, null, instances, null);
    }

    @Override
    public Node deployVerticle(String main, JsonObject config, int instances) {
        return this.deployVerticle(main, config, instances, null);
    }

    @Override
    public Node deployVerticle(String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, null, 1, doneHandler);
    }

    @Override
    public Node deployVerticle(String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, config, 1, doneHandler);
    }

    @Override
    public Node deployVerticle(String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, null, instances, doneHandler);
    }

    @Override
    public Node deployVerticle(String main, JsonObject config, int instances, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "verticle").putString("main", main).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Node deployWorkerVerticle(String main) {
        return this.deployWorkerVerticle(main, null, 1, false, null);
    }

    @Override
    public Node deployWorkerVerticle(String main, JsonObject config) {
        return this.deployWorkerVerticle(main, config, 1, false, null);
    }

    @Override
    public Node deployWorkerVerticle(String main, int instances) {
        return this.deployWorkerVerticle(main, null, instances, false, null);
    }

    @Override
    public Node deployWorkerVerticle(String main, JsonObject config, int instances, boolean multiThreaded) {
        return this.deployWorkerVerticle(main, config, instances, multiThreaded, null);
    }

    @Override
    public Node deployWorkerVerticle(String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, null, 1, false, doneHandler);
    }

    @Override
    public Node deployWorkerVerticle(String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, config, 1, false, doneHandler);
    }

    @Override
    public Node deployWorkerVerticle(String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, null, instances, false, doneHandler);
    }

    @Override
    public Node deployWorkerVerticle(String main, JsonObject config, int instances, boolean multiThreaded, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "verticle").putString("main", main).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances).putBoolean("worker", Boolean.valueOf(true)).putBoolean("multi-threaded", Boolean.valueOf(multiThreaded));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Node undeployModule(String deploymentID) {
        return this.undeployModule(deploymentID, null);
    }

    @Override
    public Node undeployModule(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "module").putString("id", deploymentID);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Node undeployVerticle(String deploymentID) {
        return this.undeployVerticle(deploymentID, null);
    }

    @Override
    public Node undeployVerticle(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "verticle").putString("id", deploymentID);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    public String toString() {
        return String.format("node:%s", this.address);
    }

    public boolean equals(Object object) {
        return object instanceof Node && ((Node)object).address().equals(this.address);
    }
}

