/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.cluster.ClusterException;
import net.kuujo.vertigo.cluster.Group;
import net.kuujo.vertigo.cluster.Node;
import net.kuujo.vertigo.cluster.impl.DefaultNode;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;

public class DefaultGroup
implements Group {
    private static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private final String address;
    private final Vertx vertx;
    private final Container container;
    private final Map<Handler<Node>, Handler<Message<String>>> joinHandlers = new HashMap<Handler<Node>, Handler<Message<String>>>();
    private final Map<Handler<Node>, Handler<Message<String>>> leaveHandlers = new HashMap<Handler<Node>, Handler<Message<String>>>();

    public DefaultGroup(String address, Vertx vertx, Container container) {
        this.address = address;
        this.vertx = vertx;
        this.container = container;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Group registerJoinHandler(Handler<Node> handler) {
        return this.registerJoinHandler(handler, null);
    }

    @Override
    public Group registerJoinHandler(final Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = new Handler<Message<String>>(){

            public void handle(Message<String> message) {
                handler.handle((Object)new DefaultNode((String)message.body(), DefaultGroup.this.vertx, DefaultGroup.this.container));
            }
        };
        this.joinHandlers.put(handler, messageHandler);
        this.vertx.eventBus().registerHandler(String.format("%s.join", this.address), (Handler)messageHandler, doneHandler);
        return this;
    }

    @Override
    public Group unregisterJoinHandler(Handler<Node> handler) {
        return this.unregisterJoinHandler(handler, null);
    }

    @Override
    public Group unregisterJoinHandler(Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = this.joinHandlers.remove(handler);
        if (messageHandler != null) {
            this.vertx.eventBus().unregisterHandler(String.format("%s.join", this.address), messageHandler, doneHandler);
        } else {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public Group registerLeaveHandler(Handler<Node> handler) {
        return this.registerLeaveHandler(handler, null);
    }

    @Override
    public Group registerLeaveHandler(final Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = new Handler<Message<String>>(){

            public void handle(Message<String> message) {
                handler.handle((Object)new DefaultNode((String)message.body(), DefaultGroup.this.vertx, DefaultGroup.this.container));
            }
        };
        this.leaveHandlers.put(handler, messageHandler);
        this.vertx.eventBus().registerHandler(String.format("%s.leave", this.address), (Handler)messageHandler, doneHandler);
        return this;
    }

    @Override
    public Group unregisterLeaveHandler(Handler<Node> handler) {
        return this.unregisterLeaveHandler(handler, null);
    }

    @Override
    public Group unregisterLeaveHandler(Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = this.leaveHandlers.remove(handler);
        if (messageHandler != null) {
            this.vertx.eventBus().unregisterHandler(String.format("%s.leave", this.address), messageHandler, doneHandler);
        } else {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public Group ping(final Handler<AsyncResult<Group>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "ping");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("pong")) {
                    if (((JsonObject)((Message)result.result()).body()).getString("result").equals("cluster")) {
                        new DefaultFutureResult((Object)DefaultGroup.this).setHandler(resultHandler);
                    } else {
                        new DefaultFutureResult((Throwable)((Object)new ClusterException("Not a valid group address."))).setHandler(resultHandler);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Group getNode(String node, final Handler<AsyncResult<Node>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "find").putString("type", "node").putString("node", node);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)new DefaultNode(((JsonObject)((Message)result.result()).body()).getString("result"), DefaultGroup.this.vertx, DefaultGroup.this.container)).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Group getNodes(final Handler<AsyncResult<Collection<Node>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "list").putString("type", "node");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    JsonArray jsonNodes = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    ArrayList<DefaultNode> nodes = new ArrayList<DefaultNode>();
                    for (Object jsonNode : jsonNodes) {
                        nodes.add(new DefaultNode((String)jsonNode, DefaultGroup.this.vertx, DefaultGroup.this.container));
                    }
                    new DefaultFutureResult(nodes).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Group selectNode(Object key, final Handler<AsyncResult<Node>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "select").putString("type", "node").putValue("key", key);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)new DefaultNode(((JsonObject)((Message)result.result()).body()).getString("result"), DefaultGroup.this.vertx, DefaultGroup.this.container)).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Group installModule(String moduleName) {
        return this.installModule(moduleName, null);
    }

    @Override
    public Group installModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        this.getNodes(new Handler<AsyncResult<Collection<Node>>>(){

            public void handle(AsyncResult<Collection<Node>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    CountingCompletionHandler<Void> counter = new CountingCompletionHandler(((Collection)result.result()).size()).setHandler(doneHandler);
                    for (Node node : (Collection)result.result()) {
                        node.installModule(moduleName, counter);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Group uninstallModule(String moduleName) {
        return this.uninstallModule(moduleName, null);
    }

    @Override
    public Group uninstallModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        this.getNodes(new Handler<AsyncResult<Collection<Node>>>(){

            public void handle(AsyncResult<Collection<Node>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    CountingCompletionHandler<Void> counter = new CountingCompletionHandler(((Collection)result.result()).size()).setHandler(doneHandler);
                    for (Node node : (Collection)result.result()) {
                        node.uninstallModule(moduleName, counter);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Group deployModule(String moduleName) {
        return this.deployModule(moduleName, null, 1, null);
    }

    @Override
    public Group deployModule(String moduleName, JsonObject config) {
        return this.deployModule(moduleName, config, 1, null);
    }

    @Override
    public Group deployModule(String moduleName, int instances) {
        return this.deployModule(moduleName, null, instances, null);
    }

    @Override
    public Group deployModule(String moduleName, JsonObject config, int instances) {
        return this.deployModule(moduleName, config, instances, null);
    }

    @Override
    public Group deployModule(String moduleName, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, null, 1, doneHandler);
    }

    @Override
    public Group deployModule(String moduleName, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, config, 1, doneHandler);
    }

    @Override
    public Group deployModule(String moduleName, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, null, instances, doneHandler);
    }

    @Override
    public Group deployModule(String moduleName, JsonObject config, int instances, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "module").putString("module", moduleName).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Group deployVerticle(String main) {
        return this.deployVerticle(main, null, 1, null);
    }

    @Override
    public Group deployVerticle(String main, JsonObject config) {
        return this.deployVerticle(main, config, 1, null);
    }

    @Override
    public Group deployVerticle(String main, int instances) {
        return this.deployVerticle(main, null, instances, null);
    }

    @Override
    public Group deployVerticle(String main, JsonObject config, int instances) {
        return this.deployVerticle(main, config, instances, null);
    }

    @Override
    public Group deployVerticle(String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, null, 1, doneHandler);
    }

    @Override
    public Group deployVerticle(String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, config, 1, doneHandler);
    }

    @Override
    public Group deployVerticle(String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, null, instances, doneHandler);
    }

    @Override
    public Group deployVerticle(String main, JsonObject config, int instances, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "verticle").putString("main", main).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Group deployWorkerVerticle(String main) {
        return this.deployWorkerVerticle(main, null, 1, false, null);
    }

    @Override
    public Group deployWorkerVerticle(String main, JsonObject config) {
        return this.deployWorkerVerticle(main, config, 1, false, null);
    }

    @Override
    public Group deployWorkerVerticle(String main, int instances) {
        return this.deployWorkerVerticle(main, null, instances, false, null);
    }

    @Override
    public Group deployWorkerVerticle(String main, JsonObject config, int instances, boolean multiThreaded) {
        return this.deployWorkerVerticle(main, config, instances, false, null);
    }

    @Override
    public Group deployWorkerVerticle(String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, null, 1, false, doneHandler);
    }

    @Override
    public Group deployWorkerVerticle(String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, config, 1, false, doneHandler);
    }

    @Override
    public Group deployWorkerVerticle(String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, null, instances, false, doneHandler);
    }

    @Override
    public Group deployWorkerVerticle(String main, JsonObject config, int instances, boolean multiThreaded, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "verticle").putString("main", main).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances).putBoolean("worker", Boolean.valueOf(true)).putBoolean("multi-threaded", Boolean.valueOf(multiThreaded));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Group undeployModule(String deploymentID) {
        return this.undeployModule(deploymentID, null);
    }

    @Override
    public Group undeployModule(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "module").putString("id", deploymentID);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Group undeployVerticle(String deploymentID) {
        return this.undeployVerticle(deploymentID, null);
    }

    @Override
    public Group undeployVerticle(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "verticle").putString("id", deploymentID);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    public String toString() {
        return String.format("group:%s", this.address);
    }

    public boolean equals(Object object) {
        return object instanceof Group && ((Group)object).address().equals(this.address);
    }
}

