/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.data.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.kuujo.vertigo.cluster.data.AsyncMultiMap;
import net.kuujo.vertigo.cluster.data.DataException;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class DefaultAsyncMultiMap<K, V>
implements AsyncMultiMap<K, V> {
    private final String address;
    private final String name;
    private final EventBus eventBus;

    public DefaultAsyncMultiMap(String address, String name, Vertx vertx) {
        this.address = address;
        this.name = name;
        this.eventBus = vertx.eventBus();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, null);
    }

    @Override
    public void put(K key, V value, final Handler<AsyncResult<Boolean>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "put").putString("type", "multimap").putString("name", this.name).putValue("key", key).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void get(K key, final Handler<AsyncResult<Collection<V>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "get").putString("type", "multimap").putString("name", this.name).putValue("key", key);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    JsonArray jsonValues = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    ArrayList values = new ArrayList();
                    for (Object jsonValue : jsonValues) {
                        values.add(jsonValue);
                    }
                    new DefaultFutureResult(values).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void remove(K key) {
        this.remove(key, (V)null);
    }

    @Override
    public void remove(K key, final Handler<AsyncResult<Collection<V>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "remove").putString("type", "multimap").putString("name", this.name).putValue("key", key);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    JsonArray jsonValues = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    ArrayList values = new ArrayList();
                    for (Object jsonValue : jsonValues) {
                        values.add(jsonValue);
                    }
                    new DefaultFutureResult(values).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void remove(K key, V value) {
        this.remove(key, value, null);
    }

    @Override
    public void remove(K key, V value, final Handler<AsyncResult<Boolean>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "remove").putString("type", "multimap").putString("name", this.name).putValue("key", key).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void containsKey(K key, final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "contains").putString("type", "multimap").putString("name", this.name).putValue("key", key);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void containsValue(V value, final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "contains").putString("type", "multimap").putString("name", this.name).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void containsEntry(K key, V value, final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "contains").putString("type", "multimap").putString("name", this.name).putValue("key", key).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void keySet(final Handler<AsyncResult<Set<K>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "keys").putString("type", "multimap").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    JsonArray jsonKeys = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    if (jsonKeys != null) {
                        HashSet keys = new HashSet();
                        for (Object key : jsonKeys) {
                            keys.add(key);
                        }
                        new DefaultFutureResult(keys).setHandler(resultHandler);
                    } else {
                        new DefaultFutureResult((Throwable)((Object)new DataException("Invalid response."))).setHandler(resultHandler);
                    }
                }
            }
        });
    }

    @Override
    public void values(final Handler<AsyncResult<Collection<V>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "values").putString("type", "multimap").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    JsonArray jsonValues = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    if (jsonValues != null) {
                        ArrayList values = new ArrayList();
                        for (Object value : jsonValues) {
                            values.add(value);
                        }
                        new DefaultFutureResult(values).setHandler(resultHandler);
                    } else {
                        new DefaultFutureResult((Throwable)((Object)new DataException("Invalid response."))).setHandler(resultHandler);
                    }
                }
            }
        });
    }

    @Override
    public void size(final Handler<AsyncResult<Integer>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "size").putString("type", "multimap").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getInteger("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void isEmpty(final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "empty").putString("type", "multimap").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void clear() {
        this.clear(null);
    }

    @Override
    public void clear(final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "clear").putString("type", "multimap").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
    }
}

