/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.data.impl;

import net.kuujo.vertigo.cluster.data.AsyncList;
import net.kuujo.vertigo.cluster.data.DataException;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;

public class DefaultAsyncList<T>
implements AsyncList<T> {
    private final String address;
    private final String name;
    private final EventBus eventBus;

    public DefaultAsyncList(String address, String name, Vertx vertx) {
        this.address = address;
        this.name = name;
        this.eventBus = vertx.eventBus();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void add(T value) {
        this.add(value, null);
    }

    @Override
    public void add(T value, final Handler<AsyncResult<Boolean>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "add").putString("type", "list").putString("name", this.name).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void remove(T value) {
        this.remove(value, null);
    }

    @Override
    public void remove(T value, final Handler<AsyncResult<Boolean>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "remove").putString("type", "list").putString("name", this.name).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void remove(int index) {
        this.remove(index, (Handler<AsyncResult<T>>)null);
    }

    @Override
    public void remove(int index, final Handler<AsyncResult<T>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "remove").putString("type", "list").putString("name", this.name).putValue("index", (Object)index);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult(((JsonObject)((Message)result.result()).body()).getValue("result")).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void contains(Object value, final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "contains").putString("type", "list").putString("name", this.name).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void size(final Handler<AsyncResult<Integer>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "size").putString("type", "list").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getInteger("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void isEmpty(final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "empty").putString("type", "list").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void clear() {
        this.clear(null);
    }

    @Override
    public void clear(final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "clear").putString("type", "list").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void get(int index, final Handler<AsyncResult<T>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "get").putString("type", "list").putString("name", this.name).putNumber("index", (Number)index);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult(((JsonObject)((Message)result.result()).body()).getValue("result")).setHandler(resultHandler);
                }
            }
        });
    }

    @Override
    public void set(int index, T value) {
        this.set(index, value, null);
    }

    @Override
    public void set(int index, T value, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "set").putString("type", "list").putString("name", this.name).putNumber("index", (Number)index).putValue("value", value);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
    }
}

