/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util;

import java.util.ArrayDeque;
import java.util.Queue;
import net.kuujo.vertigo.util.Task;
import org.vertx.java.core.Handler;

public class TaskRunner {
    private final Queue<Handler<Task>> queue = new ArrayDeque<Handler<Task>>();
    private Task currentTask;

    public void runTask(Handler<Task> task) {
        if (this.currentTask == null) {
            this.currentTask = new Task(this);
            task.handle((Object)this.currentTask);
        } else {
            this.queue.add(task);
        }
    }

    void complete(Task task) {
        if (task.equals(this.currentTask)) {
            this.currentTask = null;
            this.checkTasks();
        }
    }

    private void checkTasks() {
        Handler<Task> task;
        if (this.currentTask == null && (task = this.queue.poll()) != null) {
            this.currentTask = new Task(this);
            task.handle((Object)this.currentTask);
        }
    }
}

