/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util;

import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.impl.DefaultCluster;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;

public final class Config {
    static Cluster parseCluster(JsonObject config, Vertx vertx, Container container) {
        if (!config.containsField("__cluster__")) {
            throw new IllegalArgumentException("No component cluster found.");
        }
        String cluster = config.getString("__cluster__");
        config.removeField("__cluster__");
        return new DefaultCluster(cluster, vertx, container);
    }

    public static JsonObject buildConfig(InstanceContext context, Cluster cluster) {
        JsonObject config = context.component().config().copy();
        return config.putObject("__context__", DefaultInstanceContext.toJson(context)).putString("__cluster__", cluster.address());
    }

    static InstanceContext parseContext(JsonObject config) {
        JsonObject context = config.getObject("__context__");
        if (context == null) {
            throw new IllegalArgumentException("No component context found.");
        }
        config.removeField("__context__");
        return DefaultInstanceContext.fromJson(context);
    }
}

