/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.platform.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.kuujo.vertigo.platform.ModuleFields;
import net.kuujo.vertigo.platform.ModuleIdentifier;
import net.kuujo.vertigo.platform.ModuleInfo;
import net.kuujo.vertigo.platform.PlatformManager;
import net.kuujo.vertigo.platform.PlatformManagerException;
import net.kuujo.vertigo.util.Args;
import net.kuujo.vertigo.util.ContextManager;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.spi.Action;
import org.vertx.java.platform.Container;

public class DefaultPlatformManager
implements PlatformManager {
    private static final String MODS_DIR_PROP_NAME = "vertx.mods";
    private static final String LOCAL_MODS_DIR = "mods";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String MOD_JSON_FILE = "mod.json";
    private static final int BUFFER_SIZE = 4096;
    private final Vertx vertx;
    private final ContextManager context;
    private final Container container;
    private File modRoot;

    public DefaultPlatformManager(Vertx vertx, Container container) {
        this(vertx, container, new ContextManager(vertx));
    }

    public DefaultPlatformManager(Vertx vertx, Container container, ContextManager context) {
        this.vertx = vertx;
        this.container = container;
        this.context = context;
        String modDir = System.getProperty(MODS_DIR_PROP_NAME);
        this.modRoot = modDir != null && !modDir.trim().equals("") ? new File(modDir) : new File(LOCAL_MODS_DIR);
    }

    @Override
    public PlatformManager getModuleInfo(Handler<AsyncResult<Collection<ModuleInfo>>> resultHandler) {
        this.context.execute(new Action<Collection<ModuleInfo>>(){

            public Collection<ModuleInfo> perform() {
                List modDirs = DefaultPlatformManager.this.locateModules();
                ArrayList<ModuleInfo> modInfo = new ArrayList<ModuleInfo>();
                for (File modDir : modDirs) {
                    ModuleIdentifier modID = new ModuleIdentifier(modDir.getName());
                    File modJson = new File(modDir, DefaultPlatformManager.MOD_JSON_FILE);
                    try {
                        modInfo.add(DefaultPlatformManager.this.loadModuleInfo(modID, modJson));
                    }
                    catch (Exception e) {}
                }
                return modInfo;
            }
        }, resultHandler);
        return this;
    }

    @Override
    public PlatformManager getModuleInfo(final String moduleName, Handler<AsyncResult<ModuleInfo>> resultHandler) {
        Args.checkNotNull(moduleName, "module name cannot be null", new Object[0]);
        this.context.execute(new Action<ModuleInfo>(){

            public ModuleInfo perform() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                File modDir = DefaultPlatformManager.this.locateModule(modID);
                if (modDir != null) {
                    File modJson = new File(modDir, DefaultPlatformManager.MOD_JSON_FILE);
                    return DefaultPlatformManager.this.loadModuleInfo(modID, modJson);
                }
                throw new PlatformManagerException("Invalid module.");
            }
        }, resultHandler);
        return this;
    }

    @Override
    public synchronized PlatformManager zipModule(final String moduleName, Handler<AsyncResult<String>> doneHandler) {
        Args.checkNotNull(moduleName, "module name cannot be null", new Object[0]);
        this.context.execute(new Action<String>(){

            public String perform() {
                File file = DefaultPlatformManager.this.zipModule(new ModuleIdentifier(moduleName));
                return file.getAbsolutePath();
            }
        }, doneHandler);
        return this;
    }

    @Override
    public PlatformManager installModule(final String zipFile, Handler<AsyncResult<Void>> doneHandler) {
        Args.checkNotNull(zipFile, "zip file cannot be null", new Object[0]);
        this.context.execute(new Action<Void>(){

            public Void perform() {
                File file = new File(zipFile);
                if (!file.exists()) {
                    throw new PlatformManagerException("File does not exist.");
                }
                DefaultPlatformManager.this.installModule(file);
                return null;
            }
        }, doneHandler);
        return this;
    }

    @Override
    public PlatformManager uninstallModule(final String moduleName, Handler<AsyncResult<Void>> doneHandler) {
        Args.checkNotNull(moduleName, "module name cannot be null", new Object[0]);
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultPlatformManager.this.uninstallModule(new ModuleIdentifier(moduleName));
                return null;
            }
        }, doneHandler);
        return this;
    }

    @Override
    public PlatformManager deployModule(String moduleName, JsonObject config, int instances, Handler<AsyncResult<String>> doneHandler) {
        this.container.deployModule(moduleName, config, instances, doneHandler);
        return this;
    }

    @Override
    public PlatformManager deployVerticle(String main, JsonObject config, int instances, Handler<AsyncResult<String>> doneHandler) {
        this.container.deployVerticle(main, config, instances, doneHandler);
        return this;
    }

    @Override
    public PlatformManager deployWorkerVerticle(String main, JsonObject config, int instances, boolean multiThreaded, Handler<AsyncResult<String>> doneHandler) {
        this.container.deployWorkerVerticle(main, config, instances, multiThreaded, doneHandler);
        return this;
    }

    @Override
    public PlatformManager undeployModule(String deploymentID, Handler<AsyncResult<Void>> doneHandler) {
        this.container.undeployModule(deploymentID, doneHandler);
        return this;
    }

    @Override
    public PlatformManager undeployVerticle(String deploymentID, Handler<AsyncResult<Void>> doneHandler) {
        this.container.undeployVerticle(deploymentID, doneHandler);
        return this;
    }

    private List<File> locateModules() {
        File[] files = this.modRoot.listFiles();
        ArrayList<File> modFiles = new ArrayList<File>();
        for (File file : files) {
            File modJson;
            if (!file.isDirectory()) continue;
            boolean isValid = true;
            try {
                new ModuleIdentifier(file.getName());
            }
            catch (Exception e) {
                isValid = false;
            }
            if (!isValid || !(modJson = new File(file, MOD_JSON_FILE)).exists()) continue;
            modFiles.add(file);
        }
        return modFiles;
    }

    private File locateModule(ModuleIdentifier modID) {
        File modDir = new File(this.modRoot, modID.toString());
        if (modDir.exists()) {
            return modDir;
        }
        return null;
    }

    private ModuleInfo loadModuleInfo(ModuleIdentifier modID, File modJsonFile) {
        return new ModuleInfo(modID, new ModuleFields(this.loadModuleConfig(modID, modJsonFile)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadModuleConfig(ModuleIdentifier modID, File modJsonFile) {
        try (Scanner scanner = new Scanner(modJsonFile, "UTF-8").useDelimiter("\\A");){
            JsonObject jsonObject = new JsonObject(scanner.next());
            return jsonObject;
        }
        catch (FileNotFoundException e) {
            throw new PlatformManagerException("Module " + (Object)((Object)modID) + " does not contains a mod.json file");
        }
        catch (NoSuchElementException e) {
            throw new PlatformManagerException("Module " + (Object)((Object)modID) + " contains an empty mod.json");
        }
        catch (DecodeException e) {
            throw new PlatformManagerException("Module " + (Object)((Object)modID) + " mod.json contains invalid json");
        }
    }

    private void pullInDependencies(ModuleIdentifier modID, File modDir) {
        String[] deploys;
        String sdeploys;
        String[] includes;
        File modJsonFile = new File(modDir, MOD_JSON_FILE);
        ModuleInfo info = this.loadModuleInfo(modID, modJsonFile);
        ModuleFields fields = info.fields();
        ArrayList<String> mods = new ArrayList<String>();
        String sincludes = fields.getIncludes();
        if (sincludes != null && (includes = this.parseIncludes(sincludes)) != null) {
            mods.addAll(Arrays.asList(includes));
        }
        if ((sdeploys = fields.getDeploys()) != null && (deploys = this.parseIncludes(sdeploys)) != null) {
            mods.addAll(Arrays.asList(deploys));
        }
        if (!mods.isEmpty()) {
            File internalModsDir = new File(modDir, LOCAL_MODS_DIR);
            if (!internalModsDir.exists() && !internalModsDir.mkdir()) {
                throw new PlatformManagerException("Failed to create directory " + internalModsDir);
            }
            for (String moduleName : mods) {
                ModuleIdentifier childModID;
                File includeModDir;
                File internalModDir = new File(internalModsDir, moduleName);
                if (internalModDir.exists() || (includeModDir = this.locateModule(childModID = new ModuleIdentifier(moduleName))) == null) continue;
                this.vertx.fileSystem().copySync(includeModDir.getAbsolutePath(), internalModDir.getAbsolutePath(), true);
                this.pullInDependencies(childModID, internalModDir);
            }
        }
    }

    private File zipModule(ModuleIdentifier modID) {
        File modDir = new File(this.modRoot, modID.toString());
        if (!modDir.exists()) {
            throw new PlatformManagerException("Cannot find module");
        }
        File modRoot = new File(TEMP_DIR, "vertx-zip-mods");
        File zipFile = new File(modRoot, modID.toString() + ".zip");
        if (zipFile.exists()) {
            return zipFile;
        }
        File modDest = new File(modRoot, modID.toString() + "-" + UUID.randomUUID().toString());
        File modHome = new File(modDest, modID.toString());
        this.vertx.fileSystem().mkdirSync(modHome.getAbsolutePath(), true);
        this.vertx.fileSystem().copySync(modDir.getAbsolutePath(), modHome.getAbsolutePath(), true);
        this.pullInDependencies(modID, modHome);
        this.zipDirectory(zipFile.getPath(), modDest.getAbsolutePath());
        this.vertx.fileSystem().deleteSync(modDest.getAbsolutePath(), true);
        return zipFile;
    }

    private void zipDirectory(String zipFile, String dirToZip) {
        File directory = new File(dirToZip);
        try (ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(zipFile));){
            this.addDirectoryToZip(directory, directory, stream);
        }
        catch (Exception e) {
            throw new PlatformManagerException("Failed to zip module", e);
        }
    }

    private void addDirectoryToZip(File topDirectory, File directory, ZipOutputStream out) throws IOException {
        Path top = Paths.get(topDirectory.getAbsolutePath(), new String[0]);
        File[] files = directory.listFiles();
        byte[] buffer = new byte[4096];
        for (int i = 0; i < files.length; ++i) {
            Path entry = Paths.get(files[i].getAbsolutePath(), new String[0]);
            Path relative = top.relativize(entry);
            String entryName = relative.toString();
            if (files[i].isDirectory()) {
                entryName = entryName + FILE_SEPARATOR;
            }
            out.putNextEntry(new ZipEntry(entryName.replace("\\", "/")));
            if (!files[i].isDirectory()) {
                try (FileInputStream in = new FileInputStream(files[i]);){
                    int bytesRead;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                out.closeEntry();
            }
            if (!files[i].isDirectory()) continue;
            this.addDirectoryToZip(topDirectory, files[i], out);
        }
    }

    private String[] parseIncludes(String sincludes) {
        if ("".equals(sincludes = sincludes.trim())) {
            return null;
        }
        String[] arr = sincludes.split(",");
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i].trim();
            }
        }
        return arr;
    }

    private void installModule(File zipFile) {
        this.modRoot.mkdirs();
        this.unzipModuleData(this.modRoot, zipFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipModuleData(File directory, File zipFile, boolean deleteZip) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
             ZipInputStream zin = new ZipInputStream(new BufferedInputStream(in));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.isEmpty()) continue;
                if (entry.isDirectory()) {
                    File dir = new File(directory, entryName);
                    if (dir.exists() || new File(directory, entryName).mkdir()) continue;
                    throw new PlatformManagerException("Failed to create directory");
                }
                byte[] buffer = new byte[4096];
                FilterOutputStream out = null;
                try {
                    int count;
                    FileOutputStream os = new FileOutputStream(new File(directory, entryName));
                    out = new BufferedOutputStream(os, 4096);
                    while ((count = zin.read(buffer, 0, 4096)) != -1) {
                        ((BufferedOutputStream)out).write(buffer, 0, count);
                    }
                    ((BufferedOutputStream)out).flush();
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PlatformManagerException("Failed to unzip module", e);
        }
        finally {
            if (deleteZip) {
                zipFile.delete();
            }
        }
    }

    private void uninstallModule(ModuleIdentifier modID) {
        File modDir = new File(this.modRoot, modID.toString());
        if (modDir.exists()) {
            modDir.delete();
        }
    }
}

