/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.network.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.component.ComponentContext;
import net.kuujo.vertigo.component.impl.DefaultComponentContext;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

public class DefaultNetworkContext
extends BaseContext<NetworkContext>
implements NetworkContext {
    private String name;
    private String version;
    private NetworkConfig config;
    private String status;
    private Map<String, ComponentContext<?>> components = new HashMap();

    private DefaultNetworkContext() {
    }

    public static DefaultNetworkContext fromJson(JsonObject context) {
        return SerializerFactory.getSerializer(BaseContext.class).deserializeObject(context.getObject("network"), DefaultNetworkContext.class);
    }

    public static JsonObject toJson(NetworkContext context) {
        return new JsonObject().putObject("network", SerializerFactory.getSerializer(NetworkContext.class).serializeToObject(context));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public NetworkConfig config() {
        return this.config;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public List<ComponentContext<?>> components() {
        ArrayList components = new ArrayList();
        for (ComponentContext<?> component : this.components.values()) {
            components.add((ComponentContext<?>)((DefaultComponentContext)component).setNetworkContext(this));
        }
        return components;
    }

    @Override
    public boolean hasComponent(String name) {
        return this.components.containsKey(name);
    }

    @Override
    public <T extends ComponentContext<?>> T component(String name) {
        return this.components.containsKey(name) ? (T)((DefaultComponentContext)this.components.get(name)).setNetworkContext(this) : null;
    }

    @Override
    public void notify(NetworkContext update) {
        if (update == null) {
            for (ComponentContext<?> component : this.components.values()) {
                component.notify(null);
            }
            this.components.clear();
        } else {
            Iterator<Map.Entry<String, ComponentContext<?>>> iter = this.components.entrySet().iterator();
            while (iter.hasNext()) {
                ComponentContext<?> component = iter.next().getValue();
                ComponentContext<?> match = null;
                for (ComponentContext<?> c : update.components()) {
                    if (!component.equals(c)) continue;
                    match = c;
                    break;
                }
                if (match != null) {
                    component.notify(match);
                    continue;
                }
                component.notify(null);
                iter.remove();
            }
            for (ComponentContext<?> component : update.components()) {
                if (this.components.values().contains(component)) continue;
                this.components.put(component.name(), component);
            }
        }
        super.notify(this);
    }

    @Override
    public String toString() {
        return this.address();
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultNetworkContext> {
        private Builder() {
            super(new DefaultNetworkContext());
        }

        private Builder(DefaultNetworkContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultNetworkContext context) {
            return new Builder(context);
        }

        public Builder setName(String name) {
            ((DefaultNetworkContext)this.context).name = name;
            ((DefaultNetworkContext)this.context).address = name;
            return this;
        }

        public Builder setVersion(String version) {
            ((DefaultNetworkContext)this.context).version = version;
            return this;
        }

        public Builder setConfig(NetworkConfig config) {
            ((DefaultNetworkContext)this.context).config = config;
            return this;
        }

        @Override
        public Builder setAddress(String address) {
            ((DefaultNetworkContext)this.context).address = address;
            return this;
        }

        public Builder setStatusAddress(String address) {
            ((DefaultNetworkContext)this.context).status = address;
            return this;
        }

        public Builder setComponents(Collection<DefaultComponentContext<?>> components) {
            ((DefaultNetworkContext)this.context).components = new HashMap();
            for (DefaultComponentContext<?> component : components) {
                component.setNetworkContext((DefaultNetworkContext)this.context);
                ((DefaultNetworkContext)this.context).components.put(component.name(), component);
            }
            return this;
        }

        public Builder addComponent(DefaultComponentContext<?> component) {
            component.setNetworkContext((DefaultNetworkContext)this.context);
            if (((DefaultNetworkContext)this.context).components == null) {
                ((DefaultNetworkContext)this.context).components = new HashMap();
            }
            ((DefaultNetworkContext)this.context).components.put(component.name(), component);
            return this;
        }

        public Builder removeComponent(DefaultComponentContext<?> component) {
            if (((DefaultNetworkContext)this.context).components == null) {
                ((DefaultNetworkContext)this.context).components = new HashMap();
            }
            ((DefaultNetworkContext)this.context).components.remove(component.name());
            return this;
        }
    }
}

