/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.network.impl;

import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.component.ModuleConfig;
import net.kuujo.vertigo.component.VerticleConfig;
import net.kuujo.vertigo.io.connection.ConnectionConfig;
import net.kuujo.vertigo.io.selector.Selector;
import net.kuujo.vertigo.network.ActiveNetwork;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.util.Observer;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;

public class DefaultActiveNetwork
implements ActiveNetwork,
Observer<NetworkContext> {
    private NetworkConfig network;
    private Cluster cluster;

    public DefaultActiveNetwork(NetworkConfig network, Cluster cluster) {
        this.network = network;
        this.cluster = cluster;
    }

    @Override
    public void update(NetworkContext context) {
        this.network = context.config();
    }

    @Override
    public NetworkConfig getConfig() {
        return this.network;
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(T component) {
        return this.addComponent(component, null);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(T component, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.network.addComponent(component);
        this.cluster.deployNetwork(this.network, doneHandler);
        return component;
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain) {
        return this.addComponent(name, moduleOrMain, null, 1, null);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, JsonObject config) {
        return this.addComponent(name, moduleOrMain, config, 1, null);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, int instances) {
        return this.addComponent(name, moduleOrMain, null, instances, null);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, JsonObject config, int instances) {
        return this.addComponent(name, moduleOrMain, config, instances, null);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addComponent(name, moduleOrMain, null, 1, doneHandler);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, JsonObject config, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addComponent(name, moduleOrMain, config, 1, doneHandler);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, int instances, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addComponent(name, moduleOrMain, null, instances, doneHandler);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, JsonObject config, int instances, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        Object component = this.network.addComponent(name, moduleOrMain, config, instances);
        this.cluster.deployNetwork(this.network, doneHandler);
        return component;
    }

    @Override
    public <T extends ComponentConfig<T>> T removeComponent(T component) {
        return this.removeComponent(component.getName(), null);
    }

    @Override
    public <T extends ComponentConfig<T>> T removeComponent(T component, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.removeComponent(component.getName(), doneHandler);
    }

    @Override
    public <T extends ComponentConfig<T>> T removeComponent(String name) {
        return this.removeComponent(name, null);
    }

    @Override
    public <T extends ComponentConfig<T>> T removeComponent(String name, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        Object component = this.network.removeComponent(name);
        DefaultNetworkConfig undeploy = new DefaultNetworkConfig(this.network.getName());
        undeploy.addComponent(component);
        this.cluster.undeployNetwork(undeploy, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)DefaultActiveNetwork.this).setHandler(doneHandler);
                }
            }
        });
        return component;
    }

    @Override
    public ModuleConfig addModule(ModuleConfig module) {
        return this.addModule(module, null);
    }

    @Override
    public ModuleConfig addModule(ModuleConfig module, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.network.addModule(module);
        this.cluster.deployNetwork(this.network, doneHandler);
        return module;
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName) {
        return this.addModule(name, moduleName, null, 1, null);
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, JsonObject config) {
        return this.addModule(name, moduleName, config, 1, null);
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, int instances) {
        return this.addModule(name, moduleName, null, instances, null);
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, JsonObject config, int instances) {
        return this.addModule(name, moduleName, config, instances, null);
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addModule(name, moduleName, null, 1, doneHandler);
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, JsonObject config, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addModule(name, moduleName, config, 1, doneHandler);
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, int instances, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addModule(name, moduleName, null, instances, doneHandler);
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, JsonObject config, int instances, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        ModuleConfig module = this.network.addModule(name, moduleName, config, instances);
        this.cluster.deployNetwork(this.network, doneHandler);
        return module;
    }

    @Override
    public ModuleConfig removeModule(ModuleConfig module) {
        return this.removeModule(module.getName(), null);
    }

    @Override
    public ModuleConfig removeModule(ModuleConfig module, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.removeModule(module.getName(), doneHandler);
    }

    @Override
    public ModuleConfig removeModule(String name) {
        return this.removeModule(name, null);
    }

    @Override
    public ModuleConfig removeModule(String name, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        ModuleConfig module = this.network.removeModule(name);
        DefaultNetworkConfig undeploy = new DefaultNetworkConfig(this.network.getName());
        undeploy.addModule(module);
        this.cluster.undeployNetwork(undeploy, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)DefaultActiveNetwork.this).setHandler(doneHandler);
                }
            }
        });
        return module;
    }

    @Override
    public VerticleConfig addVerticle(VerticleConfig verticle) {
        return this.addVerticle(verticle, null);
    }

    @Override
    public VerticleConfig addVerticle(VerticleConfig verticle, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.network.addVerticle(verticle);
        this.cluster.deployNetwork(this.network, doneHandler);
        return verticle;
    }

    @Override
    public VerticleConfig addVerticle(String name, String main) {
        return this.addVerticle(name, main, null, 1, null);
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, JsonObject config) {
        return this.addVerticle(name, main, config, 1, null);
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, int instances) {
        return this.addVerticle(name, main, null, instances, null);
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, JsonObject config, int instances) {
        return this.addVerticle(name, main, config, instances, null);
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addVerticle(name, main, null, 1, doneHandler);
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, JsonObject config, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addVerticle(name, main, config, 1, doneHandler);
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, int instances, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.addVerticle(name, main, null, instances, doneHandler);
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, JsonObject config, int instances, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        VerticleConfig verticle = this.network.addVerticle(name, main, config, instances);
        this.cluster.deployNetwork(this.network, doneHandler);
        return verticle;
    }

    @Override
    public VerticleConfig removeVerticle(VerticleConfig verticle) {
        return this.removeVerticle(verticle, null);
    }

    @Override
    public VerticleConfig removeVerticle(VerticleConfig verticle, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.removeVerticle(verticle, doneHandler);
    }

    @Override
    public VerticleConfig removeVerticle(String name) {
        return this.removeVerticle(name, null);
    }

    @Override
    public VerticleConfig removeVerticle(String name, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        VerticleConfig verticle = this.network.removeVerticle(name);
        DefaultNetworkConfig undeploy = new DefaultNetworkConfig(this.network.getName());
        undeploy.addVerticle(verticle);
        this.cluster.undeployNetwork(undeploy, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)DefaultActiveNetwork.this).setHandler(doneHandler);
                }
            }
        });
        return verticle;
    }

    @Override
    public ConnectionConfig createConnection(ConnectionConfig connection) {
        return this.createConnection(connection, null);
    }

    @Override
    public ConnectionConfig createConnection(String source, String target) {
        ConnectionConfig connection = this.network.createConnection(source, target);
        this.cluster.deployNetwork(this.network);
        return connection;
    }

    @Override
    public ConnectionConfig createConnection(String source, String target, Selector selector) {
        return this.createConnection(source, target, selector, null);
    }

    @Override
    public ConnectionConfig createConnection(String source, String out, String target, String in) {
        return this.createConnection(source, out, target, in, null, null);
    }

    @Override
    public ConnectionConfig createConnection(String source, String out, String target, String in, Selector selector) {
        return this.createConnection(source, out, target, in, selector, null);
    }

    @Override
    public ConnectionConfig createConnection(ConnectionConfig connection, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.network.createConnection(connection);
        this.cluster.deployNetwork(this.network, doneHandler);
        return connection;
    }

    @Override
    public ConnectionConfig createConnection(String source, String target, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.createConnection(source, target, doneHandler);
    }

    @Override
    public ConnectionConfig createConnection(String source, String target, Selector selector, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        ConnectionConfig connection = this.network.createConnection(source, target, selector);
        this.cluster.deployNetwork(this.network, doneHandler);
        return connection;
    }

    @Override
    public ConnectionConfig createConnection(String source, String out, String target, String in, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.createConnection(source, out, target, in, null, doneHandler);
    }

    @Override
    public ConnectionConfig createConnection(String source, String out, String target, String in, Selector selector, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        ConnectionConfig connection = this.network.createConnection(source, out, target, in, selector);
        this.cluster.deployNetwork(this.network, doneHandler);
        return connection;
    }

    @Override
    public ActiveNetwork destroyConnection(ConnectionConfig connection) {
        return this.destroyConnection(connection, null);
    }

    @Override
    public ActiveNetwork destroyConnection(ConnectionConfig connection, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.network.destroyConnection(connection);
        DefaultNetworkConfig undeploy = new DefaultNetworkConfig(this.network.getName());
        undeploy.createConnection(connection);
        this.cluster.undeployNetwork(undeploy, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)DefaultActiveNetwork.this).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public ActiveNetwork destroyConnection(String source, String target) {
        return this.destroyConnection(source, target, null);
    }

    @Override
    public ActiveNetwork destroyConnection(String source, String out, String target, String in) {
        return this.destroyConnection(source, out, target, in, null);
    }

    @Override
    public ActiveNetwork destroyConnection(String source, String target, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.network.destroyConnection(source, target);
        DefaultNetworkConfig undeploy = new DefaultNetworkConfig(this.network.getName());
        undeploy.createConnection(source, target);
        this.cluster.undeployNetwork(undeploy, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)DefaultActiveNetwork.this).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public ActiveNetwork destroyConnection(String source, String out, String target, String in, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.network.destroyConnection(source, target);
        DefaultNetworkConfig undeploy = new DefaultNetworkConfig(this.network.getName());
        undeploy.createConnection(source, out, target, in);
        this.cluster.undeployNetwork(undeploy, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)DefaultActiveNetwork.this).setHandler(doneHandler);
                }
            }
        });
        return this;
    }
}

