/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.logging;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.io.OutputCollector;
import net.kuujo.vertigo.io.logging.PortLogger;
import net.kuujo.vertigo.util.Args;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class PortLoggerFactory {
    private static final Map<String, Map<OutputCollector, PortLogger>> loggers = new HashMap<String, Map<OutputCollector, PortLogger>>();

    public static PortLogger getLogger(Class<?> clazz, OutputCollector output) {
        return PortLoggerFactory.getLogger(clazz.getCanonicalName(), output);
    }

    public static PortLogger getLogger(String name, OutputCollector output) {
        PortLogger logger;
        Args.checkNotNull(name, "logger name cannot be null", new Object[0]);
        Map<OutputCollector, PortLogger> loggers = PortLoggerFactory.loggers.get(name);
        if (loggers == null) {
            loggers = new HashMap<OutputCollector, PortLogger>();
            PortLoggerFactory.loggers.put(name, loggers);
        }
        if ((logger = loggers.get(output)) == null) {
            logger = new PortLogger(LoggerFactory.getLogger((String)name), output);
            loggers.put(output, logger);
        }
        return logger;
    }
}

