/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.component.ComponentContext;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.ModuleConfig;
import net.kuujo.vertigo.component.VerticleConfig;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.component.impl.DefaultModuleContext;
import net.kuujo.vertigo.component.impl.DefaultVerticleContext;
import net.kuujo.vertigo.hook.IOHook;
import net.kuujo.vertigo.io.connection.ConnectionConfig;
import net.kuujo.vertigo.io.connection.impl.DefaultInputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.DefaultOutputConnectionContext;
import net.kuujo.vertigo.io.impl.DefaultInputContext;
import net.kuujo.vertigo.io.impl.DefaultOutputContext;
import net.kuujo.vertigo.io.port.InputPortContext;
import net.kuujo.vertigo.io.port.OutputPortContext;
import net.kuujo.vertigo.io.port.impl.DefaultInputPortContext;
import net.kuujo.vertigo.io.port.impl.DefaultOutputPortContext;
import net.kuujo.vertigo.io.stream.impl.DefaultOutputStreamContext;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;

public final class ContextBuilder {
    private static final String COMPONENT_ADDRESS_PATTERN = System.getProperty("vertigo.component.address", "%1$s.%2$s.%3$s");

    public static NetworkContext buildContext(NetworkConfig network, String cluster) {
        DefaultNetworkContext.Builder context = DefaultNetworkContext.Builder.newBuilder();
        context.setName(network.getName());
        context.setVersion(UUID.randomUUID().toString());
        context.setAddress(String.format("%s.%s", cluster, network.getName()));
        context.setConfig(network);
        context.setStatusAddress(String.format("%s.%s.__status", cluster, network.getName()));
        HashMap components = new HashMap();
        for (ComponentConfig<?> component : network.getComponents()) {
            DefaultInstanceContext.Builder instance;
            int i;
            ArrayList<DefaultInstanceContext> instances;
            String address;
            if (component.getType().equals((Object)ComponentConfig.Type.MODULE)) {
                DefaultModuleContext.Builder module = DefaultModuleContext.Builder.newBuilder();
                module.setName(component.getName());
                address = String.format(COMPONENT_ADDRESS_PATTERN, cluster, network.getName(), component.getName());
                module.setAddress(address);
                module.setStatusAddress(String.format("%s.__status", address));
                module.setModule(((ModuleConfig)component).getModule());
                module.setConfig(component.getConfig());
                module.setGroup(component.getGroup());
                module.setHooks(component.getHooks());
                instances = new ArrayList<DefaultInstanceContext>();
                for (i = 1; i <= component.getInstances(); ++i) {
                    instance = DefaultInstanceContext.Builder.newBuilder();
                    instance.setAddress(String.format("%s-%d", address, i));
                    instance.setStatusAddress(String.format("%s-%d.__status", address, i));
                    instance.setNumber(i);
                    instance.setInput((DefaultInputContext)DefaultInputContext.Builder.newBuilder().build());
                    instance.setOutput((DefaultOutputContext)DefaultOutputContext.Builder.newBuilder().build());
                    instances.add((DefaultInstanceContext)instance.build());
                }
                module.setInstances(instances);
                components.put(component.getName(), module.build());
                continue;
            }
            DefaultVerticleContext.Builder verticle = DefaultVerticleContext.Builder.newBuilder();
            verticle.setName(component.getName());
            address = String.format(COMPONENT_ADDRESS_PATTERN, cluster, network.getName(), component.getName());
            verticle.setAddress(address);
            verticle.setStatusAddress(String.format("%s.__status", address));
            verticle.setMain(((VerticleConfig)component).getMain());
            verticle.setWorker(((VerticleConfig)component).isWorker());
            verticle.setMultiThreaded(((VerticleConfig)component).isMultiThreaded());
            verticle.setConfig(component.getConfig());
            verticle.setGroup(component.getGroup());
            verticle.setHooks(component.getHooks());
            instances = new ArrayList();
            for (i = 1; i <= component.getInstances(); ++i) {
                instance = DefaultInstanceContext.Builder.newBuilder();
                instance.setAddress(String.format("%s-%d", address, i));
                instance.setStatusAddress(String.format("%s-%d.__status", address, i));
                instance.setNumber(i);
                instance.setInput((DefaultInputContext)DefaultInputContext.Builder.newBuilder().build());
                instance.setOutput((DefaultOutputContext)DefaultOutputContext.Builder.newBuilder().build());
                instances.add((DefaultInstanceContext)instance.build());
            }
            verticle.setInstances(instances);
            components.put(component.getName(), verticle.build());
        }
        for (ConnectionConfig connection : network.getConnections()) {
            ComponentContext source = (ComponentContext)components.get(connection.getSource().getComponent());
            ComponentContext target = (ComponentContext)components.get(connection.getTarget().getComponent());
            if (source == null || target == null) continue;
            for (InstanceContext sourceInstance : source.instances()) {
                DefaultOutputPortContext.Builder output = null;
                for (OutputPortContext port : sourceInstance.output().ports()) {
                    if (!port.name().equals(connection.getSource().getPort())) continue;
                    output = DefaultOutputPortContext.Builder.newBuilder((DefaultOutputPortContext)port);
                    break;
                }
                if (output == null) {
                    DefaultOutputPortContext port = (DefaultOutputPortContext)((DefaultOutputPortContext.Builder)DefaultOutputPortContext.Builder.newBuilder().setAddress(String.format("out:%s@%s.%s.%s[%d]", connection.getSource().getPort(), cluster, network.getName(), source.name(), sourceInstance.number()))).setName(connection.getSource().getPort()).build();
                    DefaultOutputContext.Builder.newBuilder((DefaultOutputContext)sourceInstance.output()).addPort(port).build();
                    output = DefaultOutputPortContext.Builder.newBuilder(port);
                }
                DefaultOutputStreamContext.Builder outStream = DefaultOutputStreamContext.Builder.newBuilder();
                outStream.setAddress(String.format("out:%s@%s.%s.%s[%d]->in:%s@%s.%s.%s[]", connection.getSource().getPort(), cluster, network.getName(), source.name(), sourceInstance.number(), connection.getTarget().getPort(), cluster, network.getName(), target.name()));
                outStream.setSelector(connection.getSelector());
                for (InstanceContext targetInstance : target.instances()) {
                    DefaultInputPortContext.Builder input = null;
                    for (InputPortContext port : targetInstance.input().ports()) {
                        if (!port.name().equals(connection.getTarget().getPort())) continue;
                        input = DefaultInputPortContext.Builder.newBuilder((DefaultInputPortContext)port);
                        break;
                    }
                    if (input == null) {
                        DefaultInputPortContext port = (DefaultInputPortContext)((DefaultInputPortContext.Builder)DefaultInputPortContext.Builder.newBuilder().setAddress(String.format("in:%s@%s.%s.%s[%d]", connection.getTarget().getPort(), cluster, network.getName(), target.name(), targetInstance.number()))).setName(connection.getTarget().getPort()).build();
                        DefaultInputContext.Builder.newBuilder((DefaultInputContext)targetInstance.input()).addPort(port).build();
                        input = DefaultInputPortContext.Builder.newBuilder(port);
                    }
                    DefaultInputConnectionContext.Builder inConnection = DefaultInputConnectionContext.Builder.newBuilder();
                    String address = String.format("out:%s@%s.%s.%s[%d]->in:%s@%s.%s.%s[%d]", connection.getSource().getPort(), cluster, network.getName(), source.name(), sourceInstance.number(), connection.getTarget().getPort(), cluster, network.getName(), target.name(), targetInstance.number());
                    inConnection.setAddress(address);
                    inConnection.setHooks(connection.getTarget().getHooks());
                    for (IOHook hook : connection.getHooks()) {
                        inConnection.addHook(hook);
                    }
                    input.addConnection((DefaultInputConnectionContext)inConnection.build()).build();
                    DefaultOutputConnectionContext.Builder outConnection = DefaultOutputConnectionContext.Builder.newBuilder();
                    outConnection.setAddress(address);
                    outConnection.setHooks(connection.getSource().getHooks());
                    for (IOHook hook : connection.getHooks()) {
                        outConnection.addHook(hook);
                    }
                    outStream.addConnection((DefaultOutputConnectionContext)outConnection.build());
                }
                output.addStream((DefaultOutputStreamContext)outStream.build()).build();
            }
        }
        context.setComponents(components.values());
        return (NetworkContext)context.build();
    }
}

