/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.hook;

import com.fasterxml.jackson.annotation.JsonIgnore;
import net.kuujo.vertigo.component.Component;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.hook.ComponentHook;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.json.JsonObject;

public class EventBusHook
implements ComponentHook {
    @JsonIgnore
    private InstanceContext context;
    @JsonIgnore
    private EventBus eventBus;
    private String address;

    public EventBusHook() {
    }

    public EventBusHook(String address) {
        this.address = address;
    }

    @Override
    public void handleStart(Component component) {
        this.eventBus = component.vertx().eventBus();
        this.context = component.context();
        if (this.address == null) {
            this.address = component.context().component().address();
        }
        this.eventBus.publish(this.address, new JsonObject().putString("event", "start").putObject("context", DefaultInstanceContext.toJson(this.context)));
    }

    @Override
    public void handleSend(Object message) {
        this.eventBus.publish(this.address, new JsonObject().putString("event", "send").putValue("message", message));
    }

    @Override
    public void handleReceive(Object message) {
        this.eventBus.publish(this.address, new JsonObject().putString("event", "receive").putValue("message", message));
    }

    @Override
    public void handleStop(Component subject) {
        this.eventBus.publish(this.address, new JsonObject().putString("event", "stop").putObject("context", DefaultInstanceContext.toJson(this.context)));
    }
}

