/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.component.VerticleContext;
import net.kuujo.vertigo.component.impl.DefaultComponentContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.hook.ComponentHook;
import net.kuujo.vertigo.impl.BaseContext;
import org.vertx.java.core.json.JsonObject;

public class DefaultVerticleContext
extends DefaultComponentContext<VerticleContext>
implements VerticleContext {
    private String main;
    private boolean worker;
    @JsonProperty(value="multi-threaded")
    private boolean multiThreaded;

    @Override
    protected String type() {
        return "verticle";
    }

    @Override
    public boolean isVerticle() {
        return true;
    }

    @Override
    public String main() {
        return this.main;
    }

    @Override
    public boolean isWorker() {
        return this.worker;
    }

    @Override
    public boolean isMultiThreaded() {
        return this.isWorker() && this.multiThreaded;
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultVerticleContext> {
        private Builder() {
            super(new DefaultVerticleContext());
        }

        private Builder(DefaultVerticleContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultVerticleContext context) {
            return new Builder(context);
        }

        public Builder setName(String name) {
            ((DefaultVerticleContext)this.context).name = name;
            return this;
        }

        public Builder setStatusAddress(String address) {
            ((DefaultVerticleContext)this.context).status = address;
            return this;
        }

        public Builder setMain(String main) {
            ((DefaultVerticleContext)this.context).main = main;
            return this;
        }

        public Builder setConfig(JsonObject config) {
            ((DefaultVerticleContext)this.context).config = config.toMap();
            return this;
        }

        public Builder setConfig(Map<String, Object> config) {
            ((DefaultVerticleContext)this.context).config = config;
            return this;
        }

        public Builder setWorker(boolean isWorker) {
            ((DefaultVerticleContext)this.context).worker = isWorker;
            return this;
        }

        public Builder setMultiThreaded(boolean isMultiThreaded) {
            if (isMultiThreaded) {
                ((DefaultVerticleContext)this.context).worker = true;
            }
            ((DefaultVerticleContext)this.context).multiThreaded = isMultiThreaded;
            return this;
        }

        public Builder setGroup(String group) {
            ((DefaultVerticleContext)this.context).group = group;
            return this;
        }

        public Builder setInstances(DefaultInstanceContext ... instances) {
            ((DefaultVerticleContext)this.context).instances = new ArrayList();
            for (DefaultInstanceContext instance : instances) {
                ((DefaultVerticleContext)this.context).instances.add(instance.setComponentContext((DefaultComponentContext)this.context));
            }
            return this;
        }

        public Builder setInstances(List<DefaultInstanceContext> instances) {
            ((DefaultVerticleContext)this.context).instances = new ArrayList();
            for (DefaultInstanceContext instance : instances) {
                ((DefaultVerticleContext)this.context).instances.add(instance.setComponentContext((DefaultComponentContext)this.context));
            }
            return this;
        }

        public Builder addInstance(DefaultInstanceContext instance) {
            instance.setComponentContext((DefaultComponentContext)this.context);
            ((DefaultVerticleContext)this.context).instances.add(instance);
            return this;
        }

        public Builder removeInstance(DefaultInstanceContext instance) {
            ((DefaultVerticleContext)this.context).instances.remove(instance);
            return this;
        }

        public Builder setHooks(ComponentHook ... hooks) {
            ((DefaultVerticleContext)this.context).hooks = Arrays.asList(hooks);
            return this;
        }

        public Builder setHooks(List<ComponentHook> hooks) {
            ((DefaultVerticleContext)this.context).hooks = hooks;
            return this;
        }

        public Builder addHook(ComponentHook hook) {
            ((DefaultVerticleContext)this.context).hooks.add(hook);
            return this;
        }

        public Builder removeHook(ComponentHook hook) {
            ((DefaultVerticleContext)this.context).hooks.remove(hook);
            return this;
        }
    }
}

