/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import java.util.List;
import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.component.Component;
import net.kuujo.vertigo.component.ComponentCoordinator;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultComponentCoordinator;
import net.kuujo.vertigo.hook.ComponentHook;
import net.kuujo.vertigo.io.InputCollector;
import net.kuujo.vertigo.io.OutputCollector;
import net.kuujo.vertigo.io.impl.DefaultInputCollector;
import net.kuujo.vertigo.io.impl.DefaultOutputCollector;
import net.kuujo.vertigo.io.logging.PortLoggerFactory;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Future;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.platform.Container;

public class DefaultComponent
implements Component {
    protected final Vertx vertx;
    protected final Container container;
    protected final Cluster cluster;
    protected final Logger logger;
    private final ComponentCoordinator coordinator;
    private final String address;
    protected InstanceContext context;
    protected final DefaultInputCollector input;
    protected final DefaultOutputCollector output;
    private boolean started;

    protected DefaultComponent(InstanceContext context, Vertx vertx, Container container, Cluster cluster) {
        this.address = context.address();
        this.vertx = vertx;
        this.container = container;
        this.context = context;
        this.cluster = cluster;
        this.coordinator = new DefaultComponentCoordinator(context, vertx, cluster);
        this.input = new DefaultInputCollector(vertx, context.input());
        this.output = new DefaultOutputCollector(vertx, context.output());
        this.logger = PortLoggerFactory.getLogger(String.format("%s-%s", this.getClass().getCanonicalName(), this.address), (OutputCollector)this.output);
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public Container container() {
        return this.container;
    }

    @Override
    public InputCollector input() {
        return this.input;
    }

    @Override
    public OutputCollector output() {
        return this.output;
    }

    @Override
    public InstanceContext context() {
        return this.context;
    }

    @Override
    public Cluster cluster() {
        return this.cluster;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    private void setup(final Handler<AsyncResult<Void>> doneHandler) {
        this.coordinator.start(new Handler<AsyncResult<InstanceContext>>(){

            public void handle(AsyncResult<InstanceContext> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    DefaultComponent.this.context = (InstanceContext)result.result();
                    CountingCompletionHandler<Void> ioHandler = new CountingCompletionHandler<Void>(2);
                    ioHandler.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                DefaultComponent.this.coordinator.resume();
                            }
                        }
                    });
                    DefaultComponent.this.output.open(ioHandler);
                    DefaultComponent.this.input.open(ioHandler);
                }
            }
        });
        this.coordinator.resumeHandler(new Handler<Void>(){

            public void handle(Void _) {
                if (!DefaultComponent.this.started) {
                    DefaultComponent.this.started = true;
                    List<ComponentHook> hooks = DefaultComponent.this.context.component().hooks();
                    for (ComponentHook hook : hooks) {
                        hook.handleStart(DefaultComponent.this);
                    }
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public Component start() {
        return this.start(null);
    }

    @Override
    public Component start(Handler<AsyncResult<Component>> doneHandler) {
        DefaultFutureResult future = new DefaultFutureResult().setHandler(doneHandler);
        if (!this.started) {
            this.setup(new Handler<AsyncResult<Void>>((Future)future){
                final /* synthetic */ Future val$future;
                {
                    this.val$future = future;
                }

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        this.val$future.setFailure(result.cause());
                    } else {
                        this.val$future.setResult((Object)DefaultComponent.this);
                    }
                }
            });
        } else {
            future.setResult((Object)this);
        }
        return this;
    }
}

