/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;

class WrappedWatchableMap<K, V>
implements Map<K, V> {
    private final String name;
    private final Map<K, V> map;
    private final EventBus eventBus;
    private final Map<MapEvent.Type, Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>> watchHandlers = new HashMap<MapEvent.Type, Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>>();

    public WrappedWatchableMap(String name, Map<K, V> map, Vertx vertx) {
        this.name = name;
        this.map = map;
        this.eventBus = vertx.eventBus();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        V result = this.map.put(key, value);
        this.eventBus.publish(String.format("%s.%s.%s", this.name, key, MapEvent.Type.CHANGE.toString()), new JsonObject().putString("type", MapEvent.Type.CHANGE.toString()).putValue("key", key).putValue("value", value));
        String event = result == null ? MapEvent.Type.CREATE.toString() : MapEvent.Type.UPDATE.toString();
        this.eventBus.publish(String.format("%s.%s.%s", this.name, key, event), new JsonObject().putString("type", event).putValue("key", key).putValue("value", value));
        return result;
    }

    @Override
    public V remove(Object key) {
        V result = this.map.remove(key);
        this.eventBus.publish(String.format("%s.%s.%s", this.name, key, MapEvent.Type.CHANGE.toString()), new JsonObject().putString("type", MapEvent.Type.CHANGE.toString()).putValue("key", key).putValue("value", result));
        this.eventBus.publish(String.format("%s.%s.%s", this.name, key, MapEvent.Type.DELETE.toString()), new JsonObject().putString("type", MapEvent.Type.DELETE.toString()).putValue("key", key).putValue("value", result));
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public void watch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        if (event == null) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(4).setHandler(doneHandler);
            this.addWatcher(key, MapEvent.Type.CHANGE, handler, counter);
            this.addWatcher(key, MapEvent.Type.CREATE, handler, counter);
            this.addWatcher(key, MapEvent.Type.UPDATE, handler, counter);
            this.addWatcher(key, MapEvent.Type.DELETE, handler, counter);
        } else {
            this.addWatcher(key, event, handler, doneHandler);
        }
    }

    private void addWatcher(K key, final MapEvent.Type event, final Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<JsonObject>> wrappedHandler;
        Map<Handler<MapEvent<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>>, Handler<Message<JsonObject>>> watchHandlers = this.watchHandlers.get((Object)event);
        if (watchHandlers == null) {
            watchHandlers = new HashMap<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>();
            this.watchHandlers.put(event, watchHandlers);
        }
        if (!watchHandlers.containsKey(handler)) {
            wrappedHandler = new Handler<Message<JsonObject>>(){

                public void handle(Message<JsonObject> message) {
                    Object key = ((JsonObject)message.body()).getValue("key");
                    Object value = ((JsonObject)message.body()).getValue("value");
                    handler.handle(new MapEvent<Object, Object>(event, key, value));
                }
            };
            watchHandlers.put(handler, wrappedHandler);
        } else {
            wrappedHandler = watchHandlers.get(handler);
        }
        this.eventBus.registerHandler(String.format("%s.%s.%s", this.name, key, event.toString()), (Handler)wrappedHandler, doneHandler);
    }

    public void unwatch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        if (event == null) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(4).setHandler(doneHandler);
            this.removeWatcher(key, MapEvent.Type.CHANGE, handler, counter);
            this.removeWatcher(key, MapEvent.Type.CREATE, handler, counter);
            this.removeWatcher(key, MapEvent.Type.UPDATE, handler, counter);
            this.removeWatcher(key, MapEvent.Type.DELETE, handler, counter);
        } else {
            this.removeWatcher(key, event, handler, doneHandler);
        }
    }

    private void removeWatcher(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>> watchHandlers = this.watchHandlers.get((Object)event);
        if (watchHandlers == null || !watchHandlers.containsKey(handler)) {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        } else {
            Handler<Message<JsonObject>> wrappedHandler = watchHandlers.remove(handler);
            this.eventBus.unregisterHandler(String.format("%s.%s.%s", this.name, key, event.toString()), wrappedHandler, doneHandler);
        }
    }
}

