/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.data.impl;

import net.kuujo.vertigo.cluster.data.AsyncCounter;
import net.kuujo.vertigo.cluster.data.DataException;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;

public class DefaultAsyncCounter
implements AsyncCounter {
    private final String address;
    private final String name;
    private final EventBus eventBus;

    public DefaultAsyncCounter(String address, String name, Vertx vertx) {
        this.address = address;
        this.name = name;
        this.eventBus = vertx.eventBus();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void get(final Handler<AsyncResult<Long>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "get").putString("type", "counter").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getLong("result", 0L)).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void increment() {
        this.increment(null);
    }

    @Override
    public void increment(final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "increment").putString("type", "counter").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void incrementAndGet(final Handler<AsyncResult<Long>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "increment").putString("type", "counter").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getLong("result", 0L)).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void decrement() {
        this.decrement(null);
    }

    @Override
    public void decrement(final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "decrement").putString("type", "counter").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public void decrementAndGet(final Handler<AsyncResult<Long>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "decrement").putString("type", "counter").putString("name", this.name);
        this.eventBus.sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new DataException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getLong("result", 0L)).setHandler(doneHandler);
                }
            }
        });
    }
}

