/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo;

import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.impl.DefaultCluster;
import net.kuujo.vertigo.cluster.manager.impl.ClusterAgent;
import net.kuujo.vertigo.network.ActiveNetwork;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.util.Configs;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.Verticle;

public class Vertigo {
    private static final String CLUSTER_MAIN_PROPERTY_NAME = "net.kuujo.vertigo.cluster";
    private final Vertx vertx;
    private final Container container;
    private static String clusterMain;

    public Vertigo(Verticle verticle) {
        this(verticle.getVertx(), verticle.getContainer());
    }

    public Vertigo(Vertx vertx, Container container) {
        this.vertx = vertx;
        this.container = container;
    }

    public NetworkConfig createNetwork(String name) {
        return new DefaultNetworkConfig(name);
    }

    public NetworkConfig createNetwork(JsonObject json) {
        return Configs.createNetwork(json);
    }

    private String getClusterMain() {
        if (clusterMain == null) {
            try {
                clusterMain = System.getProperty(CLUSTER_MAIN_PROPERTY_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clusterMain = ClusterAgent.class.getName();
        }
        return clusterMain;
    }

    public Vertigo deployCluster(String cluster) {
        return this.deployCluster(cluster, null, 1, null);
    }

    public Vertigo deployCluster(String cluster, Handler<AsyncResult<Cluster>> doneHandler) {
        return this.deployCluster(cluster, null, 1, doneHandler);
    }

    public Vertigo deployCluster(String cluster, String group) {
        return this.deployCluster(cluster, group, 1, null);
    }

    public Vertigo deployCluster(String cluster, String group, Handler<AsyncResult<Cluster>> doneHandler) {
        return this.deployCluster(cluster, group, 1, doneHandler);
    }

    public Vertigo deployCluster(String cluster, int nodes) {
        return this.deployCluster(cluster, null, nodes, null);
    }

    public Vertigo deployCluster(String cluster, int nodes, Handler<AsyncResult<Cluster>> doneHandler) {
        return this.deployCluster(cluster, null, nodes, doneHandler);
    }

    public Vertigo deployCluster(String cluster, String group, int nodes) {
        return this.deployCluster(cluster, group, nodes, null);
    }

    public Vertigo deployCluster(final String cluster, String group, int nodes, final Handler<AsyncResult<Cluster>> doneHandler) {
        JsonObject config = new JsonObject().putString("cluster", cluster).putString("group", group);
        this.container.deployVerticle(this.getClusterMain(), config, nodes, (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    Vertigo.this.getCluster(cluster, (Handler<AsyncResult<Cluster>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo getCluster(String address, Handler<AsyncResult<Cluster>> resultHandler) {
        DefaultCluster cluster = new DefaultCluster(address, this.vertx, this.container);
        cluster.ping(resultHandler);
        return this;
    }

    public Vertigo deployNetwork(String cluster, String name) {
        return this.deployNetwork(cluster, name, null);
    }

    public Vertigo deployNetwork(String cluster, final String name, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.getCluster(cluster, new Handler<AsyncResult<Cluster>>(){

            public void handle(AsyncResult<Cluster> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((Cluster)result.result()).deployNetwork(name, (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo deployNetwork(String cluster, JsonObject network) {
        return this.deployNetwork(cluster, network, null);
    }

    public Vertigo deployNetwork(String cluster, final JsonObject network, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.getCluster(cluster, new Handler<AsyncResult<Cluster>>(){

            public void handle(AsyncResult<Cluster> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((Cluster)result.result()).deployNetwork(network, (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo deployNetwork(String cluster, NetworkConfig network) {
        return this.deployNetwork(cluster, network, null);
    }

    public Vertigo deployNetwork(String cluster, final NetworkConfig network, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.getCluster(cluster, new Handler<AsyncResult<Cluster>>(){

            public void handle(AsyncResult<Cluster> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((Cluster)result.result()).deployNetwork(network, (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo undeployNetwork(String cluster, String name) {
        return this.undeployNetwork(cluster, name, null);
    }

    public Vertigo undeployNetwork(String cluster, final String name, final Handler<AsyncResult<Void>> doneHandler) {
        this.getCluster(cluster, new Handler<AsyncResult<Cluster>>(){

            public void handle(AsyncResult<Cluster> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((Cluster)result.result()).undeployNetwork(name, (Handler<AsyncResult<Void>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo undeployNetwork(String cluster, JsonObject network) {
        return this.undeployNetwork(cluster, network, null);
    }

    public Vertigo undeployNetwork(String cluster, final JsonObject network, final Handler<AsyncResult<Void>> doneHandler) {
        this.getCluster(cluster, new Handler<AsyncResult<Cluster>>(){

            public void handle(AsyncResult<Cluster> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((Cluster)result.result()).undeployNetwork(network, (Handler<AsyncResult<Void>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo undeployNetwork(String cluster, NetworkConfig network) {
        return this.undeployNetwork(cluster, network, null);
    }

    public Vertigo undeployNetwork(String cluster, final NetworkConfig network, final Handler<AsyncResult<Void>> doneHandler) {
        this.getCluster(cluster, new Handler<AsyncResult<Cluster>>(){

            public void handle(AsyncResult<Cluster> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((Cluster)result.result()).undeployNetwork(network, (Handler<AsyncResult<Void>>)doneHandler);
                }
            }
        });
        return this;
    }
}

