/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kuujo.vertigo.cluster.manager;

import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;

/**
 * Manages a server-side node.
 *
 * @author <a href="http://github.com/kuujo">Jordan Halterman</a>
 */
public interface NodeManager {

  /**
   * Returns the node address.
   *
   * @return The node address.
   */
  String address();

  /**
   * Starts the node manager.
   *
   * @return The node manager.
   */
  NodeManager start();

  /**
   * Starts the node manager.
   *
   * @param doneHandler An asynchronous handler to be called once complete.
   * @return The node manager.
   */
  NodeManager start(Handler<AsyncResult<Void>> doneHandler);

  /**
   * Stops the node manager.
   */
  void stop();

  /**
   * Stops the node manager.
   *
   * @param doneHandler An asynchronous handler to be called once complete.
   */
  void stop(Handler<AsyncResult<Void>> doneHandler);

}
