/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.network.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.ClusterFactory;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.cluster.data.WatchableAsyncMap;
import net.kuujo.vertigo.cluster.data.impl.WrappedWatchableAsyncMap;
import net.kuujo.vertigo.component.ComponentContext;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultComponentContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.util.Config;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.Task;
import net.kuujo.vertigo.util.TaskRunner;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Future;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.Verticle;

public class NetworkManager
extends Verticle {
    private static final Logger log = LoggerFactory.getLogger(NetworkManager.class);
    private String address;
    private Cluster cluster;
    private WatchableAsyncMap<String, String> data;
    private Set<String> ready = new HashSet<String>();
    private NetworkContext currentContext;
    private final TaskRunner tasks = new TaskRunner();
    private final Map<String, Handler<MapEvent<String, String>>> watchHandlers = new HashMap<String, Handler<MapEvent<String, String>>>();
    private final Handler<MapEvent<String, String>> watchHandler = new Handler<MapEvent<String, String>>(){

        public void handle(MapEvent<String, String> event) {
            if (event.type().equals((Object)MapEvent.Type.CREATE)) {
                NetworkManager.this.handleCreate(DefaultNetworkContext.fromJson(new JsonObject(event.value())));
            } else if (event.type().equals((Object)MapEvent.Type.UPDATE)) {
                NetworkManager.this.handleUpdate(DefaultNetworkContext.fromJson(new JsonObject(event.value())));
            } else if (event.type().equals((Object)MapEvent.Type.DELETE)) {
                NetworkManager.this.handleDelete();
            }
        }
    };

    public void start(final Future<Void> startResult) {
        this.address = this.container.config().getString("address");
        if (this.address == null) {
            startResult.setFailure((Throwable)new IllegalArgumentException("No network address specified."));
            return;
        }
        String scluster = this.container.config().getString("cluster");
        if (scluster == null) {
            startResult.setFailure((Throwable)new IllegalArgumentException("No cluster address specified."));
            return;
        }
        this.cluster = ClusterFactory.getCluster(scluster, this.vertx, this.container);
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                NetworkManager.this.data = new WrappedWatchableAsyncMap(NetworkManager.this.cluster.getMap(NetworkManager.this.address), NetworkManager.this.vertx);
                NetworkManager.this.data.watch(NetworkManager.this.address, NetworkManager.this.watchHandler, new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> result) {
                        if (result.failed()) {
                            startResult.setFailure(result.cause());
                        } else {
                            NetworkManager.this.data.get(NetworkManager.this.address, new Handler<AsyncResult<String>>(){

                                public void handle(AsyncResult<String> result) {
                                    if (result.failed()) {
                                        startResult.setFailure(result.cause());
                                    } else if (result.result() != null) {
                                        NetworkManager.this.currentContext = DefaultNetworkContext.fromJson(new JsonObject((String)result.result()));
                                        final CountingCompletionHandler<Void> componentCounter = new CountingCompletionHandler<Void>(NetworkManager.this.currentContext.components().size());
                                        componentCounter.setHandler(new Handler<AsyncResult<Void>>(){

                                            public void handle(AsyncResult<Void> result) {
                                                if (result.failed()) {
                                                    startResult.setFailure(result.cause());
                                                } else {
                                                    NetworkManager.super.start(startResult);
                                                }
                                                task.complete();
                                            }
                                        });
                                        for (ComponentContext<?> component : NetworkManager.this.currentContext.components()) {
                                            final CountingCompletionHandler<Void> instanceCounter = new CountingCompletionHandler<Void>(component.instances().size());
                                            instanceCounter.setHandler(new Handler<AsyncResult<Void>>(){

                                                public void handle(AsyncResult<Void> result) {
                                                    if (result.failed()) {
                                                        componentCounter.fail(result.cause());
                                                    } else {
                                                        componentCounter.succeed();
                                                    }
                                                }
                                            });
                                            for (final InstanceContext instance : component.instances()) {
                                                NetworkManager.this.data.containsKey(instance.status(), new Handler<AsyncResult<Boolean>>(){

                                                    public void handle(AsyncResult<Boolean> result) {
                                                        if (result.failed()) {
                                                            instanceCounter.fail(result.cause());
                                                        } else if (((Boolean)result.result()).booleanValue()) {
                                                            NetworkManager.this.handleReady(instance.address());
                                                            instanceCounter.succeed();
                                                        } else {
                                                            NetworkManager.this.handleUnready(instance.address());
                                                            instanceCounter.succeed();
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    } else {
                                        task.complete();
                                        NetworkManager.super.start(startResult);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private void handleCreate(final NetworkContext context) {
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                NetworkManager.this.currentContext = context;
                NetworkManager.this.unready((Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> result) {
                        if (result.failed()) {
                            log.error((Object)result.cause());
                        } else {
                            NetworkManager.this.deployNetwork(context, (Handler<AsyncResult<NetworkContext>>)((Handler)new Handler<AsyncResult<NetworkContext>>(){

                                public void handle(AsyncResult<NetworkContext> result) {
                                    if (result.failed()) {
                                        log.error((Object)result.cause());
                                    } else {
                                        log.info((Object)("Successfully deployed network " + context.address()));
                                        task.complete();
                                        NetworkManager.this.checkReady();
                                    }
                                }
                            }));
                        }
                    }
                }));
            }
        });
    }

    private void handleUpdate(final NetworkContext context) {
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                NetworkManager.this.unready((Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> result) {
                        if (result.failed()) {
                            log.error((Object)result.cause());
                        } else if (NetworkManager.this.currentContext != null) {
                            final NetworkContext runningContext = NetworkManager.this.currentContext;
                            NetworkManager.this.currentContext = context;
                            log.info((Object)("Updating network " + NetworkManager.this.currentContext.name() + " in cluster " + NetworkManager.this.address));
                            NetworkManager.this.updateNetwork(NetworkManager.this.currentContext, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> result) {
                                    if (result.failed()) {
                                        log.error((Object)result.cause());
                                    } else {
                                        NetworkManager.this.undeployRemovedComponents(NetworkManager.this.currentContext, runningContext, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                                            public void handle(AsyncResult<Void> result) {
                                                if (result.failed()) {
                                                    log.error((Object)result.cause());
                                                } else {
                                                    NetworkManager.this.deployAddedComponents(NetworkManager.this.currentContext, runningContext, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                                                        public void handle(AsyncResult<Void> result) {
                                                            if (result.failed()) {
                                                                log.error((Object)result.cause());
                                                            } else {
                                                                task.complete();
                                                                NetworkManager.this.checkReady();
                                                            }
                                                        }
                                                    }));
                                                }
                                            }
                                        }));
                                    }
                                }
                            }));
                        } else {
                            NetworkManager.this.currentContext = context;
                            NetworkManager.this.deployNetwork(context, (Handler<AsyncResult<NetworkContext>>)((Handler)new Handler<AsyncResult<NetworkContext>>(){

                                public void handle(AsyncResult<NetworkContext> result) {
                                    if (result.failed()) {
                                        log.error((Object)result.cause());
                                    } else {
                                        log.info((Object)("Successfully deployed network " + context.address()));
                                        task.complete();
                                        NetworkManager.this.checkReady();
                                    }
                                }
                            }));
                        }
                    }
                }));
            }
        });
    }

    private void undeployRemovedComponents(final NetworkContext context, NetworkContext runningContext, final Handler<AsyncResult<Void>> doneHandler) {
        final ArrayList removedComponents = new ArrayList();
        for (ComponentContext<?> runningComponent : runningContext.components()) {
            if (context.component(runningComponent.name()) != null) continue;
            removedComponents.add(runningComponent);
        }
        if (!removedComponents.isEmpty()) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(removedComponents.size());
            counter.setHandler(new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        log.info((Object)String.format("Removed %s components from %s", removedComponents.size(), context.name()));
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    }
                }
            });
            this.undeployComponents(removedComponents, counter);
        } else {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        }
    }

    private void deployAddedComponents(final NetworkContext context, NetworkContext runningContext, final Handler<AsyncResult<Void>> doneHandler) {
        final ArrayList addedComponents = new ArrayList();
        for (ComponentContext<?> component : context.components()) {
            if (runningContext.component(component.name()) != null) continue;
            addedComponents.add(component);
        }
        if (!addedComponents.isEmpty()) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(addedComponents.size());
            counter.setHandler(new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        log.info((Object)String.format("Added %s components to %s", addedComponents.size(), context.name()));
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    }
                }
            });
            this.deployComponents(addedComponents, counter);
        } else {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        }
    }

    private void handleDelete() {
        this.tasks.runTask(new Handler<Task>(){

            public void handle(Task task) {
                NetworkManager.this.unready((Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> result) {
                        if (result.failed()) {
                            log.error((Object)result.cause());
                        }
                        if (NetworkManager.this.currentContext != null) {
                            NetworkManager.this.undeployNetwork(NetworkManager.this.currentContext, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> result) {
                                    if (result.failed()) {
                                        log.error((Object)result.cause());
                                    } else {
                                        NetworkManager.this.data.put(NetworkManager.this.currentContext.status(), "", new Handler<AsyncResult<String>>(){

                                            public void handle(AsyncResult<String> result) {
                                                if (result.failed()) {
                                                    log.error((Object)result.cause());
                                                } else {
                                                    log.info((Object)("Successfully undeployed components of " + NetworkManager.this.currentContext.address()));
                                                }
                                            }
                                        });
                                    }
                                }
                            }));
                        }
                    }
                }));
            }
        });
    }

    private void unready(final Handler<AsyncResult<Void>> doneHandler) {
        if (this.currentContext != null && this.data != null) {
            this.data.remove(this.currentContext.status(), new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    }
                }
            });
        }
    }

    private void handleReady(String address) {
        this.ready.add(address);
        this.checkReady();
    }

    private void checkReady() {
        if (this.allReady()) {
            this.data.put(this.currentContext.status(), this.currentContext.version(), new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        log.error((Object)result.cause());
                    }
                }
            });
        }
    }

    private void handleUnready(String address) {
        this.ready.remove(address);
        this.checkUnready();
    }

    private void checkUnready() {
        if (!this.allReady()) {
            this.data.remove(this.currentContext.address(), new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        log.error((Object)result.cause());
                    }
                }
            });
        }
    }

    private boolean allReady() {
        if (this.currentContext == null) {
            return false;
        }
        ArrayList<InstanceContext> instances = new ArrayList<InstanceContext>();
        boolean match = true;
        block0: for (ComponentContext<?> component : this.currentContext.components()) {
            instances.addAll(component.instances());
            for (InstanceContext instance : component.instances()) {
                if (this.ready.contains(instance.address())) continue;
                match = false;
                break block0;
            }
        }
        return match;
    }

    private void deployNetwork(final NetworkContext context, final Handler<AsyncResult<NetworkContext>> doneHandler) {
        CountingCompletionHandler<Void> complete = new CountingCompletionHandler<Void>(context.components().size());
        complete.setHandler(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)context).setHandler(doneHandler);
                }
            }
        });
        this.deployComponents(context.components(), complete);
    }

    private void deployComponents(List<ComponentContext<?>> components, final CountingCompletionHandler<Void> complete) {
        for (final ComponentContext<?> component : components) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(component.instances().size());
            counter.setHandler(new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        complete.fail(result.cause());
                    } else {
                        NetworkManager.this.data.put(component.address(), DefaultComponentContext.toJson(component).encode(), new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                if (result.failed()) {
                                    complete.fail(result.cause());
                                } else {
                                    complete.succeed();
                                }
                            }
                        });
                    }
                }
            });
            this.deployInstances(component.instances(), counter);
        }
    }

    private void deployInstances(List<InstanceContext> instances, final CountingCompletionHandler<Void> counter) {
        for (final InstanceContext instance : instances) {
            this.cluster.isDeployed(instance.address(), new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        counter.fail(result.cause());
                    } else if (((Boolean)result.result()).booleanValue()) {
                        NetworkManager.this.data.put(instance.address(), DefaultInstanceContext.toJson(instance).encode(), new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                if (result.failed()) {
                                    counter.fail(result.cause());
                                } else {
                                    counter.succeed();
                                }
                            }
                        });
                    } else {
                        NetworkManager.this.deployInstance(instance, counter);
                    }
                }
            });
        }
    }

    private void deployInstance(final InstanceContext instance, final CountingCompletionHandler<Void> counter) {
        log.info((Object)String.format("Deploying instance %d of %s", instance.number(), instance.component().name()));
        this.data.put(instance.address(), DefaultInstanceContext.toJson(instance).encode(), new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    counter.fail(result.cause());
                } else if (!NetworkManager.this.watchHandlers.containsKey(instance.address())) {
                    Handler<MapEvent<String, String>> watchHandler = new Handler<MapEvent<String, String>>(){

                        public void handle(MapEvent<String, String> event) {
                            if (event.type().equals((Object)MapEvent.Type.CREATE)) {
                                NetworkManager.this.handleReady(instance.address());
                            } else if (event.type().equals((Object)MapEvent.Type.DELETE)) {
                                NetworkManager.this.handleUnready(instance.address());
                            }
                        }
                    };
                    NetworkManager.this.data.watch(instance.status(), watchHandler, new Handler<AsyncResult<Void>>((Handler)watchHandler){
                        final /* synthetic */ Handler val$watchHandler;
                        {
                            this.val$watchHandler = handler;
                        }

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                counter.fail(result.cause());
                            } else {
                                NetworkManager.this.watchHandlers.put(instance.address(), this.val$watchHandler);
                                if (instance.component().isModule()) {
                                    NetworkManager.this.deployModule(instance, counter);
                                } else if (instance.component().isVerticle() && !instance.component().asVerticle().isWorker()) {
                                    NetworkManager.this.deployVerticle(instance, counter);
                                } else if (instance.component().isVerticle() && instance.component().asVerticle().isWorker()) {
                                    NetworkManager.this.deployWorkerVerticle(instance, counter);
                                }
                            }
                        }
                    });
                } else if (instance.component().isModule()) {
                    NetworkManager.this.deployModule(instance, counter);
                } else if (instance.component().isVerticle() && !instance.component().asVerticle().isWorker()) {
                    NetworkManager.this.deployVerticle(instance, counter);
                } else if (instance.component().isVerticle() && instance.component().asVerticle().isWorker()) {
                    NetworkManager.this.deployWorkerVerticle(instance, counter);
                }
            }
        });
    }

    private void deployModule(InstanceContext instance, final CountingCompletionHandler<Void> counter) {
        this.cluster.deployModuleTo(instance.address(), instance.component().group(), instance.component().asModule().module(), Config.buildConfig(instance, this.cluster), 1, true, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    counter.fail(result.cause());
                } else {
                    counter.succeed();
                }
            }
        });
    }

    private void deployVerticle(InstanceContext instance, final CountingCompletionHandler<Void> counter) {
        this.cluster.deployVerticleTo(instance.address(), instance.component().group(), instance.component().asVerticle().main(), Config.buildConfig(instance, this.cluster), 1, true, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    counter.fail(result.cause());
                } else {
                    counter.succeed();
                }
            }
        });
    }

    private void deployWorkerVerticle(InstanceContext instance, final CountingCompletionHandler<Void> counter) {
        this.cluster.deployWorkerVerticleTo(instance.address(), instance.component().group(), instance.component().asVerticle().main(), Config.buildConfig(instance, this.cluster), 1, instance.component().asVerticle().isMultiThreaded(), true, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    counter.fail(result.cause());
                } else {
                    counter.succeed();
                }
            }
        });
    }

    private void undeployNetwork(NetworkContext context, final Handler<AsyncResult<Void>> doneHandler) {
        CountingCompletionHandler<Void> complete = new CountingCompletionHandler<Void>(context.components().size());
        complete.setHandler(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        this.undeployComponents(context.components(), complete);
    }

    private void undeployComponents(List<ComponentContext<?>> components, final CountingCompletionHandler<Void> complete) {
        for (final ComponentContext<?> component : components) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(component.instances().size());
            counter.setHandler(new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        complete.fail(result.cause());
                    } else {
                        NetworkManager.this.data.remove(component.address(), new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                if (result.failed()) {
                                    complete.fail(result.cause());
                                } else {
                                    complete.succeed();
                                }
                            }
                        });
                    }
                }
            });
            this.undeployInstances(component.instances(), counter);
        }
    }

    private void undeployInstances(List<InstanceContext> instances, final CountingCompletionHandler<Void> counter) {
        for (final InstanceContext instance : instances) {
            this.cluster.isDeployed(instance.address(), new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        counter.fail(result.cause());
                    } else if (((Boolean)result.result()).booleanValue()) {
                        if (instance.component().isModule()) {
                            NetworkManager.this.undeployModule(instance, counter);
                        } else if (instance.component().isVerticle()) {
                            NetworkManager.this.undeployVerticle(instance, counter);
                        }
                    } else {
                        NetworkManager.this.unwatchInstance(instance, counter);
                    }
                }
            });
        }
    }

    private void unwatchInstance(final InstanceContext instance, final CountingCompletionHandler<Void> counter) {
        Handler<MapEvent<String, String>> watchHandler = this.watchHandlers.remove(instance.address());
        if (watchHandler != null) {
            this.data.unwatch(instance.status(), watchHandler, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    NetworkManager.this.data.remove(instance.address(), new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> result) {
                            if (result.failed()) {
                                counter.fail(result.cause());
                            } else {
                                counter.succeed();
                            }
                        }
                    });
                }
            });
        } else {
            this.data.remove(instance.address(), new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        counter.fail(result.cause());
                    } else {
                        counter.succeed();
                    }
                }
            });
        }
    }

    private void undeployModule(final InstanceContext instance, final CountingCompletionHandler<Void> counter) {
        this.cluster.undeployModule(instance.address(), new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                NetworkManager.this.unwatchInstance(instance, counter);
            }
        });
    }

    private void undeployVerticle(final InstanceContext instance, final CountingCompletionHandler<Void> counter) {
        this.cluster.undeployVerticle(instance.address(), new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                NetworkManager.this.unwatchInstance(instance, counter);
            }
        });
    }

    private void updateNetwork(NetworkContext context, final Handler<AsyncResult<Void>> doneHandler) {
        CountingCompletionHandler<Void> complete = new CountingCompletionHandler<Void>(context.components().size());
        complete.setHandler(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        this.updateComponents(context.components(), complete);
    }

    private void updateComponents(List<ComponentContext<?>> components, final CountingCompletionHandler<Void> complete) {
        for (ComponentContext<?> component : components) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(component.instances().size());
            counter.setHandler(new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        complete.fail(result.cause());
                    } else {
                        complete.succeed();
                    }
                }
            });
            this.updateInstances(component.instances(), counter);
        }
    }

    private void updateInstances(List<InstanceContext> instances, final CountingCompletionHandler<Void> counter) {
        for (InstanceContext instance : instances) {
            this.data.put(instance.address(), DefaultInstanceContext.toJson(instance).encode(), new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        counter.fail(result.cause());
                    } else {
                        counter.succeed();
                    }
                }
            });
        }
    }
}

