/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.network.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.component.ModuleConfig;
import net.kuujo.vertigo.component.VerticleConfig;
import net.kuujo.vertigo.component.impl.DefaultModuleConfig;
import net.kuujo.vertigo.component.impl.DefaultVerticleConfig;
import net.kuujo.vertigo.io.connection.ConnectionConfig;
import net.kuujo.vertigo.io.connection.impl.DefaultConnectionConfig;
import net.kuujo.vertigo.io.selector.Selector;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.util.Components;
import org.vertx.java.core.json.JsonObject;

public class DefaultNetworkConfig
implements NetworkConfig {
    private String name;
    private Map<String, ComponentConfig<?>> components = new HashMap();
    private List<ConnectionConfig> connections = new ArrayList<ConnectionConfig>();

    public DefaultNetworkConfig() {
        this.name = UUID.randomUUID().toString();
    }

    public DefaultNetworkConfig(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ComponentConfig<?>> getComponents() {
        ArrayList components = new ArrayList();
        for (Map.Entry<String, ComponentConfig<?>> entry : this.components.entrySet()) {
            components.add((ComponentConfig<?>)entry.getValue().setName(entry.getKey()));
        }
        return components;
    }

    @Override
    public <T extends ComponentConfig<T>> T getComponent(String name) {
        return (T)this.components.get(name);
    }

    @Override
    public <T extends ComponentConfig> T addComponent(T component) {
        this.components.put(component.getName(), component);
        return component;
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain) {
        return this.addComponent(name, moduleOrMain, null, 1);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, JsonObject config) {
        return this.addComponent(name, moduleOrMain, config, 1);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, int instances) {
        return this.addComponent(name, moduleOrMain, null, instances);
    }

    @Override
    public <T extends ComponentConfig<T>> T addComponent(String name, String moduleOrMain, JsonObject config, int instances) {
        if (Components.isModuleName(moduleOrMain)) {
            return (T)this.addModule(name, moduleOrMain, config, instances);
        }
        return (T)this.addVerticle(name, moduleOrMain, config, instances);
    }

    @Override
    public boolean hasComponent(String name) {
        return this.components.containsKey(name);
    }

    @Override
    public <T extends ComponentConfig<T>> T removeComponent(T component) {
        return this.removeComponent(component.getName());
    }

    @Override
    public <T extends ComponentConfig<T>> T removeComponent(String name) {
        return (T)this.components.remove(name);
    }

    @Override
    public ModuleConfig addModule(ModuleConfig module) {
        this.components.put(module.getName(), module);
        return module;
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName) {
        return this.addModule(new DefaultModuleConfig(name, moduleName, this));
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, JsonObject config) {
        return this.addModule(new DefaultModuleConfig(name, moduleName, this).setConfig(config));
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, int numInstances) {
        return this.addModule(new DefaultModuleConfig(name, moduleName, this).setInstances(numInstances));
    }

    @Override
    public ModuleConfig addModule(String name, String moduleName, JsonObject config, int numInstances) {
        return this.addModule((ModuleConfig)new DefaultModuleConfig(name, moduleName, this).setConfig(config).setInstances(numInstances));
    }

    @Override
    public ModuleConfig removeModule(ModuleConfig module) {
        return this.removeModule(module.getName());
    }

    @Override
    public ModuleConfig removeModule(String name) {
        ComponentConfig<?> component = this.components.get(name);
        if (!(component instanceof ModuleConfig)) {
            throw new IllegalArgumentException("Component is not a module component.");
        }
        return (ModuleConfig)component;
    }

    @Override
    public VerticleConfig addVerticle(VerticleConfig verticle) {
        this.components.put(verticle.getName(), verticle);
        return verticle;
    }

    @Override
    public VerticleConfig addVerticle(String name, String main) {
        return this.addVerticle(new DefaultVerticleConfig(name, main, this));
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, JsonObject config) {
        return this.addVerticle(new DefaultVerticleConfig(name, main, this).setConfig(config));
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, int numInstances) {
        return this.addVerticle(new DefaultVerticleConfig(name, main, this).setInstances(numInstances));
    }

    @Override
    public VerticleConfig addVerticle(String name, String main, JsonObject config, int numInstances) {
        return this.addVerticle((VerticleConfig)new DefaultVerticleConfig(name, main, this).setConfig(config).setInstances(numInstances));
    }

    @Override
    public VerticleConfig removeVerticle(VerticleConfig verticle) {
        return this.removeVerticle(verticle.getName());
    }

    @Override
    public VerticleConfig removeVerticle(String name) {
        ComponentConfig<?> component = this.components.get(name);
        if (!(component instanceof VerticleConfig)) {
            throw new IllegalArgumentException("Component is not a verticle component.");
        }
        return (VerticleConfig)component;
    }

    @Override
    public ConnectionConfig createConnection(ConnectionConfig connection) {
        this.connections.add(connection);
        return connection;
    }

    @Override
    public ConnectionConfig createConnection(String source, String target) {
        DefaultConnectionConfig connection = new DefaultConnectionConfig(source, target, this);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public ConnectionConfig createConnection(String source, String target, Selector selector) {
        DefaultConnectionConfig connection = new DefaultConnectionConfig(source, target, selector, this);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public ConnectionConfig createConnection(String source, String out, String target, String in) {
        DefaultConnectionConfig connection = new DefaultConnectionConfig(source, out, target, in, this);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public ConnectionConfig createConnection(String source, String out, String target, String in, Selector selector) {
        DefaultConnectionConfig connection = new DefaultConnectionConfig(source, out, target, in, selector, this);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public NetworkConfig destroyConnection(ConnectionConfig connection) {
        Iterator<ConnectionConfig> iter = this.connections.iterator();
        while (iter.hasNext()) {
            ConnectionConfig check = iter.next();
            if (!check.equals(connection)) continue;
            iter.remove();
        }
        return this;
    }

    @Override
    public NetworkConfig destroyConnection(String source, String target) {
        return this.destroyConnection(new DefaultConnectionConfig(source, target, this));
    }

    @Override
    public NetworkConfig destroyConnection(String source, String out, String target, String in) {
        return this.destroyConnection(new DefaultConnectionConfig(source, out, target, in, this));
    }

    @Override
    public Collection<ConnectionConfig> getConnections() {
        return this.connections;
    }

    public String toString() {
        return this.getName();
    }
}

