/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.stream.impl;

import java.util.ArrayList;
import java.util.List;
import net.kuujo.vertigo.io.batch.OutputBatch;
import net.kuujo.vertigo.io.connection.ConnectionOutputBatch;
import net.kuujo.vertigo.io.connection.OutputConnection;
import net.kuujo.vertigo.io.group.OutputGroup;
import net.kuujo.vertigo.io.group.impl.BaseOutputGroup;
import net.kuujo.vertigo.io.stream.impl.DefaultOutputStream;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class StreamOutputBatch
implements OutputBatch {
    private final String id;
    private final DefaultOutputStream stream;
    private final List<ConnectionOutputBatch> batches;

    public StreamOutputBatch(String id, DefaultOutputStream stream, List<ConnectionOutputBatch> batches) {
        this.id = id;
        this.stream = stream;
        this.batches = batches;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Vertx vertx() {
        return this.stream.vertx();
    }

    @Override
    public int size() {
        return this.stream.size();
    }

    @Override
    public OutputBatch setSendQueueMaxSize(int maxSize) {
        this.stream.setSendQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        return this.stream.getSendQueueMaxSize();
    }

    @Override
    public boolean sendQueueFull() {
        return this.stream.sendQueueFull();
    }

    @Override
    public OutputBatch drainHandler(Handler<Void> handler) {
        this.stream.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public OutputBatch send(Object message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(String message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Short message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Integer message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Long message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Float message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Double message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Boolean message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Byte message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(byte[] message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Character message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Buffer message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(JsonArray message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(JsonObject message) {
        for (OutputConnection outputConnection : this.stream.selector.select(message, this.batches)) {
            outputConnection.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch group(final String name, final Handler<OutputGroup> handler) {
        final ArrayList groups = new ArrayList();
        List<ConnectionOutputBatch> batches = this.stream.selector.select(name, this.batches);
        final int batchesSize = batches.size();
        for (ConnectionOutputBatch batch : batches) {
            batch.group(name, new Handler<OutputGroup>(){

                public void handle(OutputGroup group) {
                    groups.add(group);
                    if (groups.size() == batchesSize) {
                        handler.handle((Object)new BaseOutputGroup(name, StreamOutputBatch.this.stream.vertx(), groups));
                    }
                }
            });
        }
        return this;
    }

    @Override
    public void end() {
        for (ConnectionOutputBatch batch : this.batches) {
            batch.end();
        }
    }
}

