/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.stream.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kuujo.vertigo.io.batch.OutputBatch;
import net.kuujo.vertigo.io.connection.ConnectionOutputBatch;
import net.kuujo.vertigo.io.connection.OutputConnection;
import net.kuujo.vertigo.io.connection.OutputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.DefaultOutputConnection;
import net.kuujo.vertigo.io.group.OutputGroup;
import net.kuujo.vertigo.io.group.impl.BaseOutputGroup;
import net.kuujo.vertigo.io.selector.Selector;
import net.kuujo.vertigo.io.stream.OutputStream;
import net.kuujo.vertigo.io.stream.OutputStreamContext;
import net.kuujo.vertigo.io.stream.impl.StreamOutputBatch;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class DefaultOutputStream
implements OutputStream {
    private final Vertx vertx;
    private final OutputStreamContext context;
    final List<OutputConnection> connections = new ArrayList<OutputConnection>();
    private int maxQueueSize;
    Selector selector;

    public DefaultOutputStream(Vertx vertx, OutputStreamContext context) {
        this.vertx = vertx;
        this.context = context;
        for (OutputConnectionContext connection : context.connections()) {
            this.connections.add(new DefaultOutputConnection(vertx, connection));
        }
        this.selector = context.selector();
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public String address() {
        return this.context.address();
    }

    @Override
    public OutputStream open() {
        return this.open((Handler)null);
    }

    @Override
    public OutputStream open(Handler<AsyncResult<Void>> doneHandler) {
        CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(this.connections.size()).setHandler(doneHandler);
        for (OutputConnection connection : this.connections) {
            connection.open(counter);
        }
        return this;
    }

    @Override
    public OutputStream setSendQueueMaxSize(int maxSize) {
        this.maxQueueSize = maxSize;
        for (OutputConnection connection : this.connections) {
            connection.setSendQueueMaxSize(Math.round(this.maxQueueSize / this.connections.size()));
        }
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        return this.maxQueueSize;
    }

    @Override
    public int size() {
        int highest = 0;
        for (OutputConnection connection : this.connections) {
            highest = Math.max(highest, connection.size());
        }
        return highest;
    }

    @Override
    public boolean sendQueueFull() {
        for (OutputConnection connection : this.connections) {
            if (!connection.sendQueueFull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OutputStream drainHandler(Handler<Void> handler) {
        for (OutputConnection connection : this.connections) {
            connection.drainHandler(handler);
        }
        return this;
    }

    @Override
    public OutputStream batch(Handler<OutputBatch> handler) {
        return this.batch(UUID.randomUUID().toString(), (Handler)handler);
    }

    @Override
    public OutputStream batch(final String id, final Handler<OutputBatch> handler) {
        final ArrayList<ConnectionOutputBatch> batches = new ArrayList<ConnectionOutputBatch>();
        final int connectionsSize = this.connections.size();
        if (connectionsSize == 0) {
            handler.handle((Object)new StreamOutputBatch(id, this, batches));
        } else {
            for (OutputConnection connection : this.connections) {
                connection.batch(id, new Handler<ConnectionOutputBatch>(){

                    public void handle(ConnectionOutputBatch batch) {
                        batches.add(batch);
                        if (batches.size() == connectionsSize) {
                            handler.handle((Object)new StreamOutputBatch(id, DefaultOutputStream.this, batches));
                        }
                    }
                });
            }
        }
        return this;
    }

    @Override
    public OutputStream group(final String name, final Handler<OutputGroup> handler) {
        final ArrayList<OutputGroup> groups = new ArrayList<OutputGroup>();
        List<OutputConnection> connections = this.selector.select(name, this.connections);
        final int connectionsSize = connections.size();
        if (connectionsSize == 0) {
            handler.handle((Object)new BaseOutputGroup(name, this.vertx, groups));
        } else {
            for (OutputConnection connection : connections) {
                connection.group(name, new Handler<OutputGroup>(){

                    public void handle(OutputGroup group) {
                        groups.add(group);
                        if (groups.size() == connectionsSize) {
                            handler.handle((Object)new BaseOutputGroup(name, DefaultOutputStream.this.vertx, groups));
                        }
                    }
                });
            }
        }
        return this;
    }

    @Override
    public OutputStream send(Object message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(String message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Boolean message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Character message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Short message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Integer message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Long message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Double message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Float message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Buffer message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(JsonObject message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(JsonArray message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Byte message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(byte[] message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> doneHandler) {
        CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(this.connections.size()).setHandler(doneHandler);
        for (OutputConnection connection : this.connections) {
            connection.close(counter);
        }
    }
}

