/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.logging;

import net.kuujo.vertigo.io.OutputCollector;
import net.kuujo.vertigo.io.port.OutputPort;
import org.vertx.java.core.logging.Logger;

public class PortLogger
extends Logger {
    public static final String FATAL_PORT = "fatal";
    public static final String ERROR_PORT = "error";
    public static final String WARN_PORT = "warn";
    public static final String INFO_PORT = "info";
    public static final String DEBUG_PORT = "debug";
    public static final String TRACE_PORT = "trace";
    private final Logger logger;
    private final OutputPort fatal;
    private final OutputPort error;
    private final OutputPort warn;
    private final OutputPort info;
    private final OutputPort debug;
    private final OutputPort trace;

    PortLogger(Logger logger, OutputCollector output) {
        super(null);
        this.logger = logger;
        this.fatal = output.port(FATAL_PORT);
        this.error = output.port(ERROR_PORT);
        this.warn = output.port(WARN_PORT);
        this.info = output.port(INFO_PORT);
        this.debug = output.port(DEBUG_PORT);
        this.trace = output.port(TRACE_PORT);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void fatal(Object message) {
        this.logger.fatal(message);
        this.fatal.send(message);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.fatal(message, t);
        this.fatal.send(message);
    }

    public void error(Object message) {
        this.logger.error(message);
        this.error.send(message);
    }

    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
        this.error.send(message);
    }

    public void warn(Object message) {
        this.logger.warn(message);
        this.warn.send(message);
    }

    public void warn(Object message, Throwable t) {
        this.logger.warn(message, t);
        this.warn.send(message);
    }

    public void info(Object message) {
        this.logger.info(message);
        this.info.send(message);
    }

    public void info(Object message, Throwable t) {
        this.logger.info(message, t);
        this.info.send(message);
    }

    public void debug(Object message) {
        this.logger.debug(message);
        this.debug.send(message);
    }

    public void debug(Object message, Throwable t) {
        this.logger.debug(message, t);
        this.debug.send(message);
    }

    public void trace(Object message) {
        this.logger.trace(message);
        this.trace.send(message);
    }

    public void trace(Object message, Throwable t) {
        this.logger.trace(message, t);
        this.trace.send(message);
    }
}

