/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import net.kuujo.vertigo.util.serialization.SerializationException;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class OutputSerializer {
    private final Set<Class<?>> eventBusTypes = new HashSet<Class<?>>(){
        {
            this.add(String.class);
            this.add(Integer.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Byte.class);
            this.add(byte[].class);
            this.add(Character.class);
            this.add(Buffer.class);
            this.add(JsonObject.class);
            this.add(JsonArray.class);
        }
    };

    public JsonObject serialize(Object message) {
        Class<?> clazz = message.getClass();
        if (this.eventBusTypes.contains(clazz)) {
            return new JsonObject().putValue("value", message);
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = null;
        byte[] serialized = null;
        try {
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(message);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        serialized = byteStream.toByteArray();
        return new JsonObject().putBoolean("serialized", Boolean.valueOf(true)).putBinary("value", serialized);
    }
}

