/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import net.kuujo.vertigo.util.serialization.SerializationException;
import org.vertx.java.core.json.JsonObject;

public class InputDeserializer {
    public Object deserialize(JsonObject message) {
        boolean serialized = message.getBoolean("serialized", false);
        if (!serialized) {
            return message.getValue("value");
        }
        byte[] bytes = message.getBinary("value");
        ObjectInputStream stream = null;
        try {
            stream = new ThreadObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = stream.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializationException(e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private class ThreadObjectInputStream
    extends ObjectInputStream {
        public ThreadObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                return loader.loadClass(desc.getName());
            }
            catch (Exception exception) {
                return super.resolveClass(desc);
            }
        }
    }
}

