/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.io.OutputContext;
import net.kuujo.vertigo.io.impl.DefaultIOContext;
import net.kuujo.vertigo.io.port.OutputPortContext;
import net.kuujo.vertigo.io.port.impl.DefaultOutputPortContext;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

public class DefaultOutputContext
extends DefaultIOContext<OutputContext>
implements OutputContext {
    private Collection<OutputPortContext> ports = new ArrayList<OutputPortContext>();

    public static DefaultOutputContext fromJson(JsonObject context) {
        Serializer serializer = SerializerFactory.getSerializer(DefaultInstanceContext.class);
        DefaultOutputContext output = serializer.deserializeObject(context.getObject("output"), DefaultOutputContext.class);
        DefaultInstanceContext instance = DefaultInstanceContext.fromJson(context);
        return (DefaultOutputContext)output.setInstanceContext(instance);
    }

    public static JsonObject toJson(DefaultOutputContext context) {
        Serializer serializer = SerializerFactory.getSerializer(DefaultInstanceContext.class);
        JsonObject json = DefaultInstanceContext.toJson(context.instance());
        return json.putObject("output", serializer.serializeToObject(context));
    }

    @Override
    public String address() {
        return null;
    }

    @Override
    public Collection<OutputPortContext> ports() {
        return this.ports;
    }

    @Override
    public void notify(OutputContext update) {
        if (update == null) {
            for (OutputPortContext port : this.ports) {
                port.notify(null);
            }
            this.ports.clear();
        } else {
            Iterator<OutputPortContext> iter = this.ports.iterator();
            while (iter.hasNext()) {
                OutputPortContext port = iter.next();
                OutputPortContext match = null;
                for (OutputPortContext p : update.ports()) {
                    if (!port.name().equals(p.name())) continue;
                    match = p;
                    break;
                }
                if (match != null) {
                    port.notify(match);
                    continue;
                }
                port.notify(null);
                iter.remove();
            }
            for (OutputPortContext port : update.ports()) {
                boolean exists = false;
                for (OutputPortContext p : this.ports) {
                    if (!p.name().equals(port.name())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.ports.add(port);
            }
        }
        super.notify(this);
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultOutputContext> {
        private Builder() {
            super(new DefaultOutputContext());
        }

        private Builder(DefaultOutputContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultOutputContext context) {
            return new Builder(context);
        }

        public Builder setPorts(DefaultOutputPortContext ... ports) {
            ((DefaultOutputContext)this.context).ports = new ArrayList();
            for (DefaultOutputPortContext port : ports) {
                ((DefaultOutputContext)this.context).ports.add(port.setOutput((OutputContext)((Object)this.context)));
            }
            return this;
        }

        public Builder setPorts(Collection<DefaultOutputPortContext> ports) {
            ((DefaultOutputContext)this.context).ports = new ArrayList();
            for (DefaultOutputPortContext port : ports) {
                ((DefaultOutputContext)this.context).ports.add(port.setOutput((OutputContext)((Object)this.context)));
            }
            return this;
        }

        public Builder addPort(DefaultOutputPortContext port) {
            ((DefaultOutputContext)this.context).ports.add(port.setOutput((OutputContext)((Object)this.context)));
            return this;
        }

        public Builder removePort(OutputPortContext port) {
            ((DefaultOutputContext)this.context).ports.remove(port);
            return this;
        }
    }
}

