/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.group.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.kuujo.vertigo.io.group.OutputGroup;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class BaseOutputGroup
implements OutputGroup {
    private final String id = UUID.randomUUID().toString();
    private final String name;
    private final Vertx vertx;
    private final Collection<OutputGroup> connections;

    public BaseOutputGroup(String name, Vertx vertx, Collection<OutputGroup> connections) {
        this.name = name;
        this.vertx = vertx;
        this.connections = connections;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public OutputGroup setSendQueueMaxSize(int maxSize) {
        for (OutputGroup group : this.connections) {
            group.setSendQueueMaxSize(maxSize);
        }
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        int maxSize = 0;
        for (OutputGroup group : this.connections) {
            maxSize += group.getSendQueueMaxSize();
        }
        return maxSize;
    }

    @Override
    public int size() {
        int highest = 0;
        for (OutputGroup group : this.connections) {
            highest = Math.max(highest, group.size());
        }
        return highest;
    }

    @Override
    public boolean sendQueueFull() {
        for (OutputGroup group : this.connections) {
            if (!group.sendQueueFull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OutputGroup drainHandler(Handler<Void> handler) {
        for (OutputGroup group : this.connections) {
            group.drainHandler(handler);
        }
        return this;
    }

    @Override
    public OutputGroup group(final String name, final Handler<OutputGroup> handler) {
        final ArrayList<OutputGroup> groups = new ArrayList<OutputGroup>();
        final int connectionsSize = this.connections.size();
        if (connectionsSize == 0) {
            handler.handle((Object)new BaseOutputGroup(name, this.vertx, groups));
        } else {
            for (OutputGroup connection : this.connections) {
                connection.group(name, new Handler<OutputGroup>(){

                    public void handle(OutputGroup group) {
                        groups.add(group);
                        if (groups.size() == connectionsSize) {
                            handler.handle((Object)new BaseOutputGroup(name, BaseOutputGroup.this.vertx, groups));
                        }
                    }
                });
            }
        }
        return this;
    }

    @Override
    public OutputGroup send(Object message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(String message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Boolean message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Character message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Short message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Integer message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Long message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Double message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Float message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Buffer message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(JsonObject message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(JsonArray message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(Byte message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup send(byte[] message) {
        for (OutputGroup output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputGroup end() {
        for (OutputGroup output : this.connections) {
            output.end();
        }
        return this;
    }
}

