/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import net.kuujo.vertigo.io.connection.ConnectionOutputGroup;
import net.kuujo.vertigo.io.connection.impl.DefaultOutputConnection;
import net.kuujo.vertigo.io.group.OutputGroup;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class DefaultConnectionOutputGroup
implements ConnectionOutputGroup {
    private final String id;
    private final String parent;
    private final String name;
    private final DefaultOutputConnection connection;
    private Handler<OutputGroup> startHandler;
    private Handler<Void> endHandler;
    private int children;
    private boolean started;
    private boolean ended;
    private boolean closed;

    public DefaultConnectionOutputGroup(String id, String name, DefaultOutputConnection connection) {
        this.id = id;
        this.name = name;
        this.parent = null;
        this.connection = connection;
    }

    public DefaultConnectionOutputGroup(String id, String name, String parent, DefaultOutputConnection connection) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.connection = connection;
    }

    private void checkEnd() {
        if (this.ended && !this.closed && this.children == 0) {
            this.closed = true;
            this.connection.doGroupEnd(this.id);
            if (this.endHandler != null) {
                this.endHandler.handle((Object)null);
            }
        }
    }

    void endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        this.checkEnd();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Vertx vertx() {
        return this.connection.vertx();
    }

    void start(Handler<OutputGroup> startHandler) {
        this.connection.doGroupStart(this.id, this.name, this.parent);
        this.startHandler = startHandler;
    }

    void handleStart() {
        if (!this.started && this.startHandler != null) {
            this.startHandler.handle((Object)this);
            this.started = true;
        }
    }

    @Override
    public OutputGroup setSendQueueMaxSize(int maxSize) {
        this.connection.setSendQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        return this.connection.getSendQueueMaxSize();
    }

    @Override
    public int size() {
        return this.connection.size();
    }

    @Override
    public boolean sendQueueFull() {
        return this.connection.sendQueueFull();
    }

    @Override
    public OutputGroup drainHandler(Handler<Void> handler) {
        this.connection.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public DefaultConnectionOutputGroup group(String name, Handler<OutputGroup> handler) {
        DefaultConnectionOutputGroup group = this.connection.group(name, this.id, handler);
        ++this.children;
        group.endHandler((Handler<Void>)new VoidHandler(){

            protected void handle() {
                DefaultConnectionOutputGroup.this.children--;
                DefaultConnectionOutputGroup.this.checkEnd();
            }
        });
        return this;
    }

    private OutputGroup doSend(Object value) {
        if (!this.ended) {
            this.connection.doGroupSend(this.id, value);
        }
        return this;
    }

    @Override
    public OutputGroup send(Object message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(String message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Boolean message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Character message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Short message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Integer message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Long message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Double message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Float message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Buffer message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(JsonObject message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(JsonArray message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(Byte message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup send(byte[] message) {
        return this.doSend(message);
    }

    @Override
    public OutputGroup end() {
        this.ended = true;
        this.checkEnd();
        return this;
    }
}

